/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.option.DeltaStrike;
import com.opengamma.strata.market.option.Strike;
import com.opengamma.strata.measure.fxopt.FxOptionVolatilitiesNode;
import com.opengamma.strata.measure.fxopt.FxOptionVolatilitiesSpecification;
import com.opengamma.strata.pricer.fxopt.BlackFxOptionSmileVolatilities;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilitiesName;
import com.opengamma.strata.pricer.fxopt.InterpolatedStrikeSmileDeltaTermStructure;
import com.opengamma.strata.pricer.fxopt.SmileDeltaParameters;
import com.opengamma.strata.pricer.fxopt.SmileDeltaTermStructure;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class BlackFxOptionSmileVolatilitiesSpecification
implements FxOptionVolatilitiesSpecification,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FxOptionVolatilitiesName name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final CurrencyPair currencyPair;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ImmutableList<FxOptionVolatilitiesNode> nodes;
    @PropertyDefinition(validate="notNull")
    private final CurveInterpolator timeInterpolator;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator timeExtrapolatorLeft;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator timeExtrapolatorRight;
    @PropertyDefinition(validate="notNull")
    private final CurveInterpolator strikeInterpolator;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator strikeExtrapolatorLeft;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator strikeExtrapolatorRight;
    private final transient ImmutableListMultimap<Tenor, FxOptionVolatilitiesNode> nodesByTenor;
    private final transient ImmutableList<Double> deltas;
    private static final long serialVersionUID = 1L;

    public BlackFxOptionSmileVolatilities volatilities(ZonedDateTime valuationDateTime, DoubleArray parameters, ReferenceData refData) {
        ArgChecker.notNull((Object)valuationDateTime, (String)"valuationDateTime");
        ArgChecker.isTrue((parameters.size() == this.getParameterCount() ? 1 : 0) != 0, (String)Messages.format((String)"Size of parameters must be {}, but found {}", (Object[])new Object[]{this.getParameterCount(), parameters.size()}));
        List<SmileDeltaParameters> volatilityTerm = this.createVolatilityTerm(valuationDateTime, parameters, refData);
        InterpolatedStrikeSmileDeltaTermStructure smiles = InterpolatedStrikeSmileDeltaTermStructure.of(volatilityTerm, (DayCount)this.dayCount, (CurveInterpolator)this.timeInterpolator, (CurveExtrapolator)this.timeExtrapolatorLeft, (CurveExtrapolator)this.timeExtrapolatorRight, (CurveInterpolator)this.strikeInterpolator, (CurveExtrapolator)this.strikeExtrapolatorLeft, (CurveExtrapolator)this.strikeExtrapolatorRight);
        return BlackFxOptionSmileVolatilities.of((FxOptionVolatilitiesName)this.name, (CurrencyPair)this.currencyPair, (ZonedDateTime)valuationDateTime, (SmileDeltaTermStructure)smiles);
    }

    private List<SmileDeltaParameters> createVolatilityTerm(ZonedDateTime valuationDateTime, DoubleArray parameters, ReferenceData refData) {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Tenor tenor2 : this.nodesByTenor.keys()) {
            ImmutableList nodesAndQuotes = (ImmutableList)this.nodesByTenor.get((Object)tenor2).stream().map(node -> Pair.of((Object)node, (Object)parameters.get(this.nodes.indexOf(node)))).collect(Guavate.toImmutableList());
            builder.putAll((Object)tenor2, (Iterable)nodesAndQuotes);
        }
        ImmutableListMultimap nodesAndQuotesByTenor = builder.build();
        DoubleArray deltasArray = DoubleArray.copyOf(this.deltas);
        return (List)this.nodesByTenor.keySet().stream().sorted().map(tenor -> BlackFxOptionSmileVolatilitiesSpecification.createDeltaParameters(valuationDateTime, tenor, deltasArray, (List<Pair<FxOptionVolatilitiesNode, Double>>)nodesAndQuotesByTenor.get(tenor), this.dayCount, refData)).collect(Guavate.toImmutableList());
    }

    private static SmileDeltaParameters createDeltaParameters(ZonedDateTime valuationDateTime, Tenor tenor, DoubleArray deltas, List<Pair<FxOptionVolatilitiesNode, Double>> nodesAndQuotes, DayCount dayCount, ReferenceData refData) {
        int nDeltas = deltas.size();
        double expiry = 0.0;
        double atm = 0.0;
        double[] rr = new double[nDeltas];
        double[] str = new double[nDeltas];
        for (Pair<FxOptionVolatilitiesNode, Double> entry : nodesAndQuotes) {
            int i;
            FxOptionVolatilitiesNode node = (FxOptionVolatilitiesNode)entry.getFirst();
            ValueType quoteValyeType = node.getQuoteValueType();
            if (quoteValyeType.equals((Object)ValueType.BLACK_VOLATILITY)) {
                atm = (Double)entry.getSecond();
                expiry = node.timeToExpiry(valuationDateTime, dayCount, refData);
                continue;
            }
            if (quoteValyeType.equals((Object)ValueType.RISK_REVERSAL)) {
                for (i = 0; i < nDeltas; ++i) {
                    if (node.getStrike().getValue() != deltas.get(i)) continue;
                    rr[i] = (Double)entry.getSecond();
                }
                continue;
            }
            if (quoteValyeType.equals((Object)ValueType.STRANGLE)) {
                for (i = 0; i < nDeltas; ++i) {
                    if (node.getStrike().getValue() != deltas.get(i)) continue;
                    str[i] = (Double)entry.getSecond();
                }
                continue;
            }
            throw new IllegalArgumentException("Unsupported value type");
        }
        return SmileDeltaParameters.of((double)expiry, (Tenor)tenor, (double)atm, (DoubleArray)deltas, (DoubleArray)DoubleArray.ofUnsafe((double[])rr), (DoubleArray)DoubleArray.ofUnsafe((double[])str));
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.strikeExtrapolatorLeft = CurveExtrapolators.FLAT;
        builder.strikeExtrapolatorRight = CurveExtrapolators.FLAT;
        builder.timeExtrapolatorLeft = CurveExtrapolators.FLAT;
        builder.timeExtrapolatorRight = CurveExtrapolators.FLAT;
    }

    @ImmutableConstructor
    private BlackFxOptionSmileVolatilitiesSpecification(FxOptionVolatilitiesName name, CurrencyPair currencyPair, DayCount dayCount, List<FxOptionVolatilitiesNode> nodes, CurveInterpolator timeInterpolator, CurveExtrapolator timeExtrapolatorLeft, CurveExtrapolator timeExtrapolatorRight, CurveInterpolator strikeInterpolator, CurveExtrapolator strikeExtrapolatorLeft, CurveExtrapolator strikeExtrapolatorRight) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull(nodes, (String)"nodes");
        JodaBeanUtils.notNull((Object)timeInterpolator, (String)"timeInterpolator");
        JodaBeanUtils.notNull((Object)timeExtrapolatorLeft, (String)"timeExtrapolatorLeft");
        JodaBeanUtils.notNull((Object)timeExtrapolatorRight, (String)"timeExtrapolatorRight");
        JodaBeanUtils.notNull((Object)strikeInterpolator, (String)"strikeInterpolator");
        JodaBeanUtils.notNull((Object)strikeExtrapolatorLeft, (String)"strikeExtrapolatorLeft");
        JodaBeanUtils.notNull((Object)strikeExtrapolatorRight, (String)"strikeExtrapolatorRight");
        this.name = name;
        this.currencyPair = currencyPair;
        this.dayCount = dayCount;
        this.nodes = ImmutableList.copyOf(nodes);
        this.timeInterpolator = timeInterpolator;
        this.timeExtrapolatorLeft = timeExtrapolatorLeft;
        this.timeExtrapolatorRight = timeExtrapolatorRight;
        this.strikeInterpolator = strikeInterpolator;
        this.strikeExtrapolatorLeft = strikeExtrapolatorLeft;
        this.strikeExtrapolatorRight = strikeExtrapolatorRight;
        this.nodesByTenor = (ImmutableListMultimap)nodes.stream().collect(Guavate.toImmutableListMultimap(FxOptionVolatilitiesNode::getTenor));
        ImmutableList fullDeltas = (ImmutableList)nodes.stream().map(FxOptionVolatilitiesNode::getStrike).distinct().map(Strike::getValue).sorted().collect(Guavate.toImmutableList());
        int nDeltas = fullDeltas.size() - 1;
        ArgChecker.isTrue(((Double)fullDeltas.get(nDeltas) == 0.5 ? 1 : 0) != 0, (String)"0 < delta <= 0.5");
        this.deltas = fullDeltas.subList(0, nDeltas);
        int nParams = nodes.size();
        for (int i = 0; i < nParams; ++i) {
            ArgChecker.isTrue((boolean)nodes.get(i).getCurrencyPair().equals((Object)currencyPair), (String)"currency pair must be the same");
            ArgChecker.isTrue((boolean)(nodes.get(i).getStrike() instanceof DeltaStrike), (String)"Strike must be DeltaStrike");
        }
        for (Tenor tenor : this.nodesByTenor.keys()) {
            ImmutableList nodesForTenor = this.nodesByTenor.get((Object)tenor);
            List atmDelta = nodesForTenor.stream().filter(node -> node.getQuoteValueType().equals((Object)ValueType.BLACK_VOLATILITY)).map(node -> node.getStrike().getValue()).sorted().collect(Collectors.toList());
            ArgChecker.isTrue((boolean)atmDelta.equals(fullDeltas.subList(nDeltas, nDeltas + 1)), (String)("The ATM delta set must be " + fullDeltas.subList(nDeltas, nDeltas + 1) + ", but found " + atmDelta + ", for " + tenor));
            List rrDelta = nodesForTenor.stream().filter(node -> node.getQuoteValueType().equals((Object)ValueType.RISK_REVERSAL)).map(node -> node.getStrike().getValue()).sorted().collect(Collectors.toList());
            ArgChecker.isTrue((boolean)rrDelta.equals(this.deltas), (String)("The delta set for risk reversal must be " + this.deltas + ", but found " + rrDelta + ", for " + tenor));
            List strDelta = nodesForTenor.stream().filter(node -> node.getQuoteValueType().equals((Object)ValueType.STRANGLE)).map(node -> node.getStrike().getValue()).sorted().collect(Collectors.toList());
            ArgChecker.isTrue((boolean)strDelta.equals(this.deltas), (String)("The delta set for strangle must be " + this.deltas + ", but found " + strDelta + ", for " + tenor));
            Set busAdj = nodesForTenor.stream().map(FxOptionVolatilitiesNode::getBusinessDayAdjustment).collect(Collectors.toSet());
            ArgChecker.isTrue((busAdj.size() == 1 ? 1 : 0) != 0, (String)"BusinessDayAdjustment must be common to all the nodes");
            Set offset = nodesForTenor.stream().map(FxOptionVolatilitiesNode::getSpotDateOffset).collect(Collectors.toSet());
            ArgChecker.isTrue((offset.size() == 1 ? 1 : 0) != 0, (String)"DaysAdjustment must be common to all the nodes");
        }
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public FxOptionVolatilitiesName getName() {
        return this.name;
    }

    @Override
    public CurrencyPair getCurrencyPair() {
        return this.currencyPair;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    @Override
    public ImmutableList<FxOptionVolatilitiesNode> getNodes() {
        return this.nodes;
    }

    public CurveInterpolator getTimeInterpolator() {
        return this.timeInterpolator;
    }

    public CurveExtrapolator getTimeExtrapolatorLeft() {
        return this.timeExtrapolatorLeft;
    }

    public CurveExtrapolator getTimeExtrapolatorRight() {
        return this.timeExtrapolatorRight;
    }

    public CurveInterpolator getStrikeInterpolator() {
        return this.strikeInterpolator;
    }

    public CurveExtrapolator getStrikeExtrapolatorLeft() {
        return this.strikeExtrapolatorLeft;
    }

    public CurveExtrapolator getStrikeExtrapolatorRight() {
        return this.strikeExtrapolatorRight;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BlackFxOptionSmileVolatilitiesSpecification other = (BlackFxOptionSmileVolatilitiesSpecification)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.currencyPair, (Object)other.currencyPair) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal(this.nodes, other.nodes) && JodaBeanUtils.equal((Object)this.timeInterpolator, (Object)other.timeInterpolator) && JodaBeanUtils.equal((Object)this.timeExtrapolatorLeft, (Object)other.timeExtrapolatorLeft) && JodaBeanUtils.equal((Object)this.timeExtrapolatorRight, (Object)other.timeExtrapolatorRight) && JodaBeanUtils.equal((Object)this.strikeInterpolator, (Object)other.strikeInterpolator) && JodaBeanUtils.equal((Object)this.strikeExtrapolatorLeft, (Object)other.strikeExtrapolatorLeft) && JodaBeanUtils.equal((Object)this.strikeExtrapolatorRight, (Object)other.strikeExtrapolatorRight);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currencyPair);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.nodes);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.timeInterpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.timeExtrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.timeExtrapolatorRight);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strikeInterpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strikeExtrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.strikeExtrapolatorRight);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("BlackFxOptionSmileVolatilitiesSpecification{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("nodes").append('=').append(JodaBeanUtils.toString(this.nodes)).append(',').append(' ');
        buf.append("timeInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.timeInterpolator)).append(',').append(' ');
        buf.append("timeExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.timeExtrapolatorLeft)).append(',').append(' ');
        buf.append("timeExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.timeExtrapolatorRight)).append(',').append(' ');
        buf.append("strikeInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.strikeInterpolator)).append(',').append(' ');
        buf.append("strikeExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.strikeExtrapolatorLeft)).append(',').append(' ');
        buf.append("strikeExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.strikeExtrapolatorRight));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<BlackFxOptionSmileVolatilitiesSpecification> {
        private FxOptionVolatilitiesName name;
        private CurrencyPair currencyPair;
        private DayCount dayCount;
        private List<FxOptionVolatilitiesNode> nodes = ImmutableList.of();
        private CurveInterpolator timeInterpolator;
        private CurveExtrapolator timeExtrapolatorLeft;
        private CurveExtrapolator timeExtrapolatorRight;
        private CurveInterpolator strikeInterpolator;
        private CurveExtrapolator strikeExtrapolatorLeft;
        private CurveExtrapolator strikeExtrapolatorRight;

        private Builder() {
            BlackFxOptionSmileVolatilitiesSpecification.applyDefaults(this);
        }

        private Builder(BlackFxOptionSmileVolatilitiesSpecification beanToCopy) {
            this.name = beanToCopy.getName();
            this.currencyPair = beanToCopy.getCurrencyPair();
            this.dayCount = beanToCopy.getDayCount();
            this.nodes = beanToCopy.getNodes();
            this.timeInterpolator = beanToCopy.getTimeInterpolator();
            this.timeExtrapolatorLeft = beanToCopy.getTimeExtrapolatorLeft();
            this.timeExtrapolatorRight = beanToCopy.getTimeExtrapolatorRight();
            this.strikeInterpolator = beanToCopy.getStrikeInterpolator();
            this.strikeExtrapolatorLeft = beanToCopy.getStrikeExtrapolatorLeft();
            this.strikeExtrapolatorRight = beanToCopy.getStrikeExtrapolatorRight();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 104993457: {
                    return this.nodes;
                }
                case -587914188: {
                    return this.timeInterpolator;
                }
                case -286652761: {
                    return this.timeExtrapolatorLeft;
                }
                case -290640004: {
                    return this.timeExtrapolatorRight;
                }
                case 815202713: {
                    return this.strikeInterpolator;
                }
                case -1176196724: {
                    return this.strikeExtrapolatorLeft;
                }
                case -2096699081: {
                    return this.strikeExtrapolatorRight;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (FxOptionVolatilitiesName)newValue;
                    break;
                }
                case 1005147787: {
                    this.currencyPair = (CurrencyPair)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 104993457: {
                    this.nodes = (List)newValue;
                    break;
                }
                case -587914188: {
                    this.timeInterpolator = (CurveInterpolator)newValue;
                    break;
                }
                case -286652761: {
                    this.timeExtrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case -290640004: {
                    this.timeExtrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                case 815202713: {
                    this.strikeInterpolator = (CurveInterpolator)newValue;
                    break;
                }
                case -1176196724: {
                    this.strikeExtrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case -2096699081: {
                    this.strikeExtrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public BlackFxOptionSmileVolatilitiesSpecification build() {
            return new BlackFxOptionSmileVolatilitiesSpecification(this.name, this.currencyPair, this.dayCount, this.nodes, this.timeInterpolator, this.timeExtrapolatorLeft, this.timeExtrapolatorRight, this.strikeInterpolator, this.strikeExtrapolatorLeft, this.strikeExtrapolatorRight);
        }

        public Builder name(FxOptionVolatilitiesName name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder currencyPair(CurrencyPair currencyPair) {
            JodaBeanUtils.notNull((Object)currencyPair, (String)"currencyPair");
            this.currencyPair = currencyPair;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder nodes(List<FxOptionVolatilitiesNode> nodes) {
            JodaBeanUtils.notNull(nodes, (String)"nodes");
            this.nodes = nodes;
            return this;
        }

        public Builder nodes(FxOptionVolatilitiesNode ... nodes) {
            return this.nodes((List<FxOptionVolatilitiesNode>)ImmutableList.copyOf((Object[])nodes));
        }

        public Builder timeInterpolator(CurveInterpolator timeInterpolator) {
            JodaBeanUtils.notNull((Object)timeInterpolator, (String)"timeInterpolator");
            this.timeInterpolator = timeInterpolator;
            return this;
        }

        public Builder timeExtrapolatorLeft(CurveExtrapolator timeExtrapolatorLeft) {
            JodaBeanUtils.notNull((Object)timeExtrapolatorLeft, (String)"timeExtrapolatorLeft");
            this.timeExtrapolatorLeft = timeExtrapolatorLeft;
            return this;
        }

        public Builder timeExtrapolatorRight(CurveExtrapolator timeExtrapolatorRight) {
            JodaBeanUtils.notNull((Object)timeExtrapolatorRight, (String)"timeExtrapolatorRight");
            this.timeExtrapolatorRight = timeExtrapolatorRight;
            return this;
        }

        public Builder strikeInterpolator(CurveInterpolator strikeInterpolator) {
            JodaBeanUtils.notNull((Object)strikeInterpolator, (String)"strikeInterpolator");
            this.strikeInterpolator = strikeInterpolator;
            return this;
        }

        public Builder strikeExtrapolatorLeft(CurveExtrapolator strikeExtrapolatorLeft) {
            JodaBeanUtils.notNull((Object)strikeExtrapolatorLeft, (String)"strikeExtrapolatorLeft");
            this.strikeExtrapolatorLeft = strikeExtrapolatorLeft;
            return this;
        }

        public Builder strikeExtrapolatorRight(CurveExtrapolator strikeExtrapolatorRight) {
            JodaBeanUtils.notNull((Object)strikeExtrapolatorRight, (String)"strikeExtrapolatorRight");
            this.strikeExtrapolatorRight = strikeExtrapolatorRight;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("BlackFxOptionSmileVolatilitiesSpecification.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("currencyPair").append('=').append(JodaBeanUtils.toString((Object)this.currencyPair)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("nodes").append('=').append(JodaBeanUtils.toString(this.nodes)).append(',').append(' ');
            buf.append("timeInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.timeInterpolator)).append(',').append(' ');
            buf.append("timeExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.timeExtrapolatorLeft)).append(',').append(' ');
            buf.append("timeExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.timeExtrapolatorRight)).append(',').append(' ');
            buf.append("strikeInterpolator").append('=').append(JodaBeanUtils.toString((Object)this.strikeInterpolator)).append(',').append(' ');
            buf.append("strikeExtrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.strikeExtrapolatorLeft)).append(',').append(' ');
            buf.append("strikeExtrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.strikeExtrapolatorRight));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<FxOptionVolatilitiesName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", BlackFxOptionSmileVolatilitiesSpecification.class, FxOptionVolatilitiesName.class);
        private final MetaProperty<CurrencyPair> currencyPair = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currencyPair", BlackFxOptionSmileVolatilitiesSpecification.class, CurrencyPair.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", BlackFxOptionSmileVolatilitiesSpecification.class, DayCount.class);
        private final MetaProperty<ImmutableList<FxOptionVolatilitiesNode>> nodes = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"nodes", BlackFxOptionSmileVolatilitiesSpecification.class, ImmutableList.class);
        private final MetaProperty<CurveInterpolator> timeInterpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeInterpolator", BlackFxOptionSmileVolatilitiesSpecification.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> timeExtrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeExtrapolatorLeft", BlackFxOptionSmileVolatilitiesSpecification.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> timeExtrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"timeExtrapolatorRight", BlackFxOptionSmileVolatilitiesSpecification.class, CurveExtrapolator.class);
        private final MetaProperty<CurveInterpolator> strikeInterpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikeInterpolator", BlackFxOptionSmileVolatilitiesSpecification.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> strikeExtrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikeExtrapolatorLeft", BlackFxOptionSmileVolatilitiesSpecification.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> strikeExtrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strikeExtrapolatorRight", BlackFxOptionSmileVolatilitiesSpecification.class, CurveExtrapolator.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "currencyPair", "dayCount", "nodes", "timeInterpolator", "timeExtrapolatorLeft", "timeExtrapolatorRight", "strikeInterpolator", "strikeExtrapolatorLeft", "strikeExtrapolatorRight"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1005147787: {
                    return this.currencyPair;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 104993457: {
                    return this.nodes;
                }
                case -587914188: {
                    return this.timeInterpolator;
                }
                case -286652761: {
                    return this.timeExtrapolatorLeft;
                }
                case -290640004: {
                    return this.timeExtrapolatorRight;
                }
                case 815202713: {
                    return this.strikeInterpolator;
                }
                case -1176196724: {
                    return this.strikeExtrapolatorLeft;
                }
                case -2096699081: {
                    return this.strikeExtrapolatorRight;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends BlackFxOptionSmileVolatilitiesSpecification> beanType() {
            return BlackFxOptionSmileVolatilitiesSpecification.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<FxOptionVolatilitiesName> name() {
            return this.name;
        }

        public MetaProperty<CurrencyPair> currencyPair() {
            return this.currencyPair;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<ImmutableList<FxOptionVolatilitiesNode>> nodes() {
            return this.nodes;
        }

        public MetaProperty<CurveInterpolator> timeInterpolator() {
            return this.timeInterpolator;
        }

        public MetaProperty<CurveExtrapolator> timeExtrapolatorLeft() {
            return this.timeExtrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> timeExtrapolatorRight() {
            return this.timeExtrapolatorRight;
        }

        public MetaProperty<CurveInterpolator> strikeInterpolator() {
            return this.strikeInterpolator;
        }

        public MetaProperty<CurveExtrapolator> strikeExtrapolatorLeft() {
            return this.strikeExtrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> strikeExtrapolatorRight() {
            return this.strikeExtrapolatorRight;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((BlackFxOptionSmileVolatilitiesSpecification)bean).getName();
                }
                case 1005147787: {
                    return ((BlackFxOptionSmileVolatilitiesSpecification)bean).getCurrencyPair();
                }
                case 1905311443: {
                    return ((BlackFxOptionSmileVolatilitiesSpecification)bean).getDayCount();
                }
                case 104993457: {
                    return ((BlackFxOptionSmileVolatilitiesSpecification)bean).getNodes();
                }
                case -587914188: {
                    return ((BlackFxOptionSmileVolatilitiesSpecification)bean).getTimeInterpolator();
                }
                case -286652761: {
                    return ((BlackFxOptionSmileVolatilitiesSpecification)bean).getTimeExtrapolatorLeft();
                }
                case -290640004: {
                    return ((BlackFxOptionSmileVolatilitiesSpecification)bean).getTimeExtrapolatorRight();
                }
                case 815202713: {
                    return ((BlackFxOptionSmileVolatilitiesSpecification)bean).getStrikeInterpolator();
                }
                case -1176196724: {
                    return ((BlackFxOptionSmileVolatilitiesSpecification)bean).getStrikeExtrapolatorLeft();
                }
                case -2096699081: {
                    return ((BlackFxOptionSmileVolatilitiesSpecification)bean).getStrikeExtrapolatorRight();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

