/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.MarketDataNotFoundException;
import com.opengamma.strata.measure.fxopt.FxOptionMarketDataLookup;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilities;
import com.opengamma.strata.pricer.fxopt.FxOptionVolatilitiesId;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultFxOptionMarketDataLookup
implements FxOptionMarketDataLookup,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<CurrencyPair, FxOptionVolatilitiesId> volatilityIds;
    private static final TypedMetaBean<DefaultFxOptionMarketDataLookup> META_BEAN = LightMetaBean.of(DefaultFxOptionMarketDataLookup.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"volatilityIds"}, (Object[])new Object[]{ImmutableMap.of()});
    private static final long serialVersionUID = 1L;

    public static DefaultFxOptionMarketDataLookup of(CurrencyPair currencyPair, FxOptionVolatilitiesId volatilityId) {
        return new DefaultFxOptionMarketDataLookup((Map<CurrencyPair, FxOptionVolatilitiesId>)ImmutableMap.of((Object)currencyPair, (Object)volatilityId));
    }

    public static DefaultFxOptionMarketDataLookup of(Map<CurrencyPair, FxOptionVolatilitiesId> volatilityIds) {
        return new DefaultFxOptionMarketDataLookup(volatilityIds);
    }

    @Override
    public ImmutableSet<CurrencyPair> getVolatilityCurrencyPairs() {
        return this.volatilityIds.keySet();
    }

    @Override
    public ImmutableSet<MarketDataId<?>> getVolatilityIds(CurrencyPair currencyPair) {
        FxOptionVolatilitiesId id = (FxOptionVolatilitiesId)this.volatilityIds.get((Object)currencyPair);
        if (id == null) {
            throw new IllegalArgumentException(this.msgPairNotFound(currencyPair));
        }
        return ImmutableSet.of((Object)id);
    }

    @Override
    public FunctionRequirements requirements(Set<CurrencyPair> currencyPairs) {
        for (CurrencyPair currencyPair : currencyPairs) {
            if (this.volatilityIds.keySet().contains((Object)currencyPair)) continue;
            throw new IllegalArgumentException(this.msgPairNotFound(currencyPair));
        }
        return FunctionRequirements.builder().valueRequirements((Set)ImmutableSet.copyOf((Collection)this.volatilityIds.values())).build();
    }

    @Override
    public FxOptionVolatilities volatilities(CurrencyPair currencyPair, MarketData marketData) {
        FxOptionVolatilitiesId volatilityId = (FxOptionVolatilitiesId)this.volatilityIds.get((Object)currencyPair);
        if (volatilityId == null) {
            throw new MarketDataNotFoundException(this.msgPairNotFound(currencyPair));
        }
        return (FxOptionVolatilities)marketData.getValue((MarketDataId)volatilityId);
    }

    private String msgPairNotFound(CurrencyPair currencyPair) {
        return Messages.format((String)"FxOption lookup has no volatilities defined for currency pair '{}'", (Object)currencyPair);
    }

    public static TypedMetaBean<DefaultFxOptionMarketDataLookup> meta() {
        return META_BEAN;
    }

    private DefaultFxOptionMarketDataLookup(Map<CurrencyPair, FxOptionVolatilitiesId> volatilityIds) {
        JodaBeanUtils.notNull(volatilityIds, (String)"volatilityIds");
        this.volatilityIds = ImmutableMap.copyOf(volatilityIds);
    }

    public TypedMetaBean<DefaultFxOptionMarketDataLookup> metaBean() {
        return META_BEAN;
    }

    public ImmutableMap<CurrencyPair, FxOptionVolatilitiesId> getVolatilityIds() {
        return this.volatilityIds;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultFxOptionMarketDataLookup other = (DefaultFxOptionMarketDataLookup)obj;
            return JodaBeanUtils.equal(this.volatilityIds, other.volatilityIds);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.volatilityIds);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append("DefaultFxOptionMarketDataLookup{");
        buf.append("volatilityIds").append('=').append(JodaBeanUtils.toString(this.volatilityIds));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

