/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.fxopt;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.fxopt.FxOptionMarketData;
import com.opengamma.strata.measure.fxopt.FxOptionMarketDataLookup;
import com.opengamma.strata.measure.fxopt.FxOptionScenarioMarketData;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.light.LightMetaBean;

@BeanDefinition(style="light")
final class DefaultFxOptionScenarioMarketData
implements FxOptionScenarioMarketData,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FxOptionMarketDataLookup lookup;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ScenarioMarketData marketData;
    private final transient AtomicReferenceArray<FxOptionMarketData> cache;
    private static final TypedMetaBean<DefaultFxOptionScenarioMarketData> META_BEAN = LightMetaBean.of(DefaultFxOptionScenarioMarketData.class, (MethodHandles.Lookup)MethodHandles.lookup(), (String[])new String[]{"lookup", "marketData"}, (Object[])new Object[0]);
    private static final long serialVersionUID = 1L;

    public static DefaultFxOptionScenarioMarketData of(FxOptionMarketDataLookup lookup, ScenarioMarketData marketData) {
        return new DefaultFxOptionScenarioMarketData(lookup, marketData);
    }

    @ImmutableConstructor
    private DefaultFxOptionScenarioMarketData(FxOptionMarketDataLookup lookup, ScenarioMarketData marketData) {
        this.lookup = (FxOptionMarketDataLookup)ArgChecker.notNull((Object)lookup, (String)"lookup");
        this.marketData = (ScenarioMarketData)ArgChecker.notNull((Object)marketData, (String)"marketData");
        this.cache = new AtomicReferenceArray(marketData.getScenarioCount());
    }

    private Object readResolve() {
        return new DefaultFxOptionScenarioMarketData(this.lookup, this.marketData);
    }

    @Override
    public FxOptionScenarioMarketData withMarketData(ScenarioMarketData marketData) {
        return DefaultFxOptionScenarioMarketData.of(this.lookup, marketData);
    }

    @Override
    public int getScenarioCount() {
        return this.marketData.getScenarioCount();
    }

    @Override
    public FxOptionMarketData scenario(int scenarioIndex) {
        FxOptionMarketData current = this.cache.get(scenarioIndex);
        if (current != null) {
            return current;
        }
        return this.cache.updateAndGet(scenarioIndex, v -> v != null ? v : this.lookup.marketDataView(this.marketData.scenario(scenarioIndex)));
    }

    public static TypedMetaBean<DefaultFxOptionScenarioMarketData> meta() {
        return META_BEAN;
    }

    public TypedMetaBean<DefaultFxOptionScenarioMarketData> metaBean() {
        return META_BEAN;
    }

    @Override
    public FxOptionMarketDataLookup getLookup() {
        return this.lookup;
    }

    @Override
    public ScenarioMarketData getMarketData() {
        return this.marketData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DefaultFxOptionScenarioMarketData other = (DefaultFxOptionScenarioMarketData)obj;
            return JodaBeanUtils.equal((Object)this.lookup, (Object)other.lookup) && JodaBeanUtils.equal((Object)this.marketData, (Object)other.marketData);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lookup);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.marketData);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("DefaultFxOptionScenarioMarketData{");
        buf.append("lookup").append('=').append(JodaBeanUtils.toString((Object)this.lookup)).append(',').append(' ');
        buf.append("marketData").append('=').append(JodaBeanUtils.toString((Object)this.marketData));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }
}

