/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.swap;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.data.scenario.DoubleScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.amount.CashFlows;
import com.opengamma.strata.market.amount.LegAmounts;
import com.opengamma.strata.market.amount.SwapLegAmount;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveId;
import com.opengamma.strata.market.explain.ExplainMap;
import com.opengamma.strata.market.param.CrossGammaParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.rate.RatesMarketData;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.CurveGammaCalculator;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.pricer.swap.DiscountingSwapTradePricer;
import com.opengamma.strata.product.swap.NotionalPaymentPeriod;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.ResolvedSwapTrade;
import com.opengamma.strata.product.swap.SwapPaymentPeriod;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

final class SwapMeasureCalculations {
    public static final SwapMeasureCalculations DEFAULT = new SwapMeasureCalculations(DiscountingSwapTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final CurveGammaCalculator CROSS_GAMMA = CurveGammaCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private static CurrencyAmount NOT_FOUND = CurrencyAmount.zero((Currency)Currency.XXX);
    private final DiscountingSwapTradePricer tradePricer;

    SwapMeasureCalculations(DiscountingSwapTradePricer tradePricer) {
        this.tradePricer = (DiscountingSwapTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
    }

    MultiCurrencyScenarioArray presentValue(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.presentValue(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount presentValue(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.presentValue(trade, ratesProvider);
    }

    ScenarioArray<ExplainMap> explainPresentValue(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.explainPresentValue(trade, marketData.scenario(i).ratesProvider()));
    }

    ExplainMap explainPresentValue(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.explainPresentValue(trade, ratesProvider);
    }

    MultiCurrencyScenarioArray pv01CalibratedSum(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedSum(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount pv01CalibratedSum(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        return ratesProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01CalibratedBucketed(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01CalibratedBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyParameterSensitivities pv01CalibratedBucketed(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        return ratesProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01MarketQuoteSum(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteSum(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount pv01MarketQuoteSum(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01MarketQuoteBucketed(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01MarketQuoteBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    CurrencyParameterSensitivities pv01MarketQuoteBucketed(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        PointSensitivities pointSensitivity = this.tradePricer.presentValueSensitivity(trade, ratesProvider);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01SemiParallelGammaBucketed(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01SemiParallelGammaBucketed(trade, marketData.scenario(i)));
    }

    private CurrencyParameterSensitivities pv01SemiParallelGammaBucketed(ResolvedSwapTrade trade, RatesMarketData marketData) {
        ImmutableSet forwardIds;
        ResolvedSwap product = trade.getProduct();
        if (product.isCrossCurrency()) {
            throw new IllegalArgumentException("Implementation only supports a single curve, but swap is cross-currency");
        }
        Currency currency = ((ResolvedSwapLeg)product.getLegs().get(0)).getCurrency();
        ImmutableSet indices = product.allIndices();
        ImmutableSet<MarketDataId<?>> discountIds = marketData.getLookup().getDiscountMarketDataIds(currency);
        Sets.SetView allIds = Sets.union(discountIds, (Set)(forwardIds = (ImmutableSet)indices.stream().flatMap(idx -> marketData.getLookup().getForwardMarketDataIds((Index)idx).stream()).collect(Guavate.toImmutableSet())));
        if (allIds.size() != 1) {
            throw new IllegalArgumentException(Messages.format((String)"Implementation only supports a single curve, but lookup refers to more than one: {}", (Object)allIds));
        }
        MarketDataId singleId = (MarketDataId)allIds.iterator().next();
        if (!(singleId instanceof CurveId)) {
            throw new IllegalArgumentException(Messages.format((String)"Implementation only supports a single curve, but lookup does not refer to a curve: {} {}", (Object[])new Object[]{singleId.getClass().getName(), singleId}));
        }
        CurveId curveId = (CurveId)singleId;
        Curve curve = (Curve)marketData.getMarketData().getValue((MarketDataId)curveId);
        CurrencyParameterSensitivity gamma = CurveGammaCalculator.DEFAULT.calculateSemiParallelGamma(curve, currency, c -> this.calculateCurveSensitivity(trade, marketData, curveId, (Curve)c));
        return CurrencyParameterSensitivities.of((CurrencyParameterSensitivity)gamma).multipliedBy(1.0E-8);
    }

    private CurrencyParameterSensitivity calculateCurveSensitivity(ResolvedSwapTrade trade, RatesMarketData marketData, CurveId curveId, Curve bumpedCurve) {
        MarketData bumpedMarketData = marketData.getMarketData().withValue((MarketDataId)curveId, (Object)bumpedCurve);
        RatesProvider bumpedRatesProvider = marketData.withMarketData(bumpedMarketData).ratesProvider();
        PointSensitivities pointSensitivities = this.tradePricer.presentValueSensitivity(trade, bumpedRatesProvider);
        CurrencyParameterSensitivities paramSensitivities = bumpedRatesProvider.parameterSensitivity(pointSensitivities);
        return (CurrencyParameterSensitivity)Iterables.getOnlyElement((Iterable)paramSensitivities.getSensitivities());
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01SingleNodeGammaBucketed(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.pv01SingleNodeGammaBucketed(trade, marketData.scenario(i).ratesProvider()));
    }

    private CurrencyParameterSensitivities pv01SingleNodeGammaBucketed(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        CrossGammaParameterSensitivities crossGamma = CROSS_GAMMA.calculateCrossGammaIntraCurve(ratesProvider, p -> p.parameterSensitivity(this.tradePricer.presentValueSensitivity(trade, (RatesProvider)p)));
        return crossGamma.diagonal().multipliedBy(1.0E-8);
    }

    DoubleScenarioArray parRate(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return DoubleScenarioArray.of((int)marketData.getScenarioCount(), i -> this.parRate(trade, marketData.scenario(i).ratesProvider()));
    }

    double parRate(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.parRate(trade, ratesProvider);
    }

    DoubleScenarioArray parSpread(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return DoubleScenarioArray.of((int)marketData.getScenarioCount(), i -> this.parSpread(trade, marketData.scenario(i).ratesProvider()));
    }

    double parSpread(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.parSpread(trade, ratesProvider);
    }

    ScenarioArray<CashFlows> cashFlows(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.cashFlows(trade, marketData.scenario(i).ratesProvider()));
    }

    CashFlows cashFlows(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.cashFlows(trade, ratesProvider);
    }

    MultiCurrencyScenarioArray accruedInterest(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.accruedInterest(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount accruedInterest(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.accruedInterest(trade, ratesProvider);
    }

    ScenarioArray<LegAmounts> legInitialNotional(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        LegAmounts legInitialNotional = this.legInitialNotional(trade);
        return ScenarioArray.ofSingleValue((int)marketData.getScenarioCount(), (Object)legInitialNotional);
    }

    LegAmounts legInitialNotional(ResolvedSwapTrade trade) {
        List notionals = trade.getProduct().getLegs().stream().map(leg -> Pair.of((Object)leg, (Object)this.buildLegNotional((ResolvedSwapLeg)leg))).collect(Collectors.toList());
        CurrencyAmount firstNotional = notionals.stream().filter(pair -> pair.getSecond() != NOT_FOUND).map(pair -> (CurrencyAmount)pair.getSecond()).findFirst().orElseThrow(() -> new IllegalArgumentException("No notional found on any swap leg"));
        notionals = notionals.stream().map(pair -> pair.getSecond() != NOT_FOUND ? pair : Pair.of((Object)pair.getFirst(), (Object)firstNotional)).collect(Collectors.toList());
        ImmutableList legAmounts = (ImmutableList)notionals.stream().map(pair -> SwapLegAmount.of((ResolvedSwapLeg)((ResolvedSwapLeg)pair.getFirst()), (CurrencyAmount)((CurrencyAmount)pair.getSecond()))).collect(Guavate.toImmutableList());
        return LegAmounts.of((List)legAmounts);
    }

    private CurrencyAmount buildLegNotional(ResolvedSwapLeg leg) {
        SwapPaymentPeriod firstPaymentPeriod = (SwapPaymentPeriod)leg.getPaymentPeriods().get(0);
        if (firstPaymentPeriod instanceof NotionalPaymentPeriod) {
            NotionalPaymentPeriod pp = (NotionalPaymentPeriod)firstPaymentPeriod;
            return pp.getNotionalAmount().positive();
        }
        return NOT_FOUND;
    }

    ScenarioArray<LegAmounts> legPresentValue(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return ScenarioArray.of((int)marketData.getScenarioCount(), i -> this.legPresentValue(trade, marketData.scenario(i).ratesProvider()));
    }

    LegAmounts legPresentValue(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        List legAmounts = trade.getProduct().getLegs().stream().map(leg -> this.legAmount((ResolvedSwapLeg)leg, ratesProvider)).collect(Collectors.toList());
        return LegAmounts.of(legAmounts);
    }

    private SwapLegAmount legAmount(ResolvedSwapLeg leg, RatesProvider provider) {
        CurrencyAmount amount = this.tradePricer.getProductPricer().getLegPricer().presentValue(leg, provider);
        return SwapLegAmount.of((ResolvedSwapLeg)leg, (CurrencyAmount)amount);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currencyExposure(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount currencyExposure(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.currencyExposure(trade, ratesProvider);
    }

    MultiCurrencyScenarioArray currentCash(ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        return MultiCurrencyScenarioArray.of((int)marketData.getScenarioCount(), i -> this.currentCash(trade, marketData.scenario(i).ratesProvider()));
    }

    MultiCurrencyAmount currentCash(ResolvedSwapTrade trade, RatesProvider ratesProvider) {
        return this.tradePricer.currentCash(trade, ratesProvider);
    }
}

