/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.swap;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.calc.Measure;
import com.opengamma.strata.calc.runner.CalculationFunction;
import com.opengamma.strata.calc.runner.CalculationParameters;
import com.opengamma.strata.calc.runner.FunctionRequirements;
import com.opengamma.strata.collect.result.FailureReason;
import com.opengamma.strata.collect.result.Result;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.measure.AdvancedMeasures;
import com.opengamma.strata.measure.Measures;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.measure.swap.SwapMeasureCalculations;
import com.opengamma.strata.product.swap.ResolvedSwapTrade;
import com.opengamma.strata.product.swap.Swap;
import com.opengamma.strata.product.swap.SwapLeg;
import com.opengamma.strata.product.swap.SwapTrade;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SwapTradeCalculationFunction
implements CalculationFunction<SwapTrade> {
    private static final ImmutableMap<Measure, SingleMeasureCalculation> CALCULATORS = ImmutableMap.builder().put((Object)Measures.PRESENT_VALUE, SwapMeasureCalculations.DEFAULT::presentValue).put((Object)Measures.EXPLAIN_PRESENT_VALUE, SwapMeasureCalculations.DEFAULT::explainPresentValue).put((Object)Measures.PV01_CALIBRATED_SUM, SwapMeasureCalculations.DEFAULT::pv01CalibratedSum).put((Object)Measures.PV01_CALIBRATED_BUCKETED, SwapMeasureCalculations.DEFAULT::pv01CalibratedBucketed).put((Object)Measures.PV01_MARKET_QUOTE_SUM, SwapMeasureCalculations.DEFAULT::pv01MarketQuoteSum).put((Object)Measures.PV01_MARKET_QUOTE_BUCKETED, SwapMeasureCalculations.DEFAULT::pv01MarketQuoteBucketed).put((Object)Measures.PAR_RATE, SwapMeasureCalculations.DEFAULT::parRate).put((Object)Measures.PAR_SPREAD, SwapMeasureCalculations.DEFAULT::parSpread).put((Object)Measures.CASH_FLOWS, SwapMeasureCalculations.DEFAULT::cashFlows).put((Object)Measures.ACCRUED_INTEREST, SwapMeasureCalculations.DEFAULT::accruedInterest).put((Object)Measures.LEG_INITIAL_NOTIONAL, SwapMeasureCalculations.DEFAULT::legInitialNotional).put((Object)Measures.LEG_PRESENT_VALUE, SwapMeasureCalculations.DEFAULT::legPresentValue).put((Object)Measures.CURRENCY_EXPOSURE, SwapMeasureCalculations.DEFAULT::currencyExposure).put((Object)Measures.CURRENT_CASH, SwapMeasureCalculations.DEFAULT::currentCash).put((Object)Measures.RESOLVED_TARGET, (rt, smd) -> rt).put((Object)AdvancedMeasures.PV01_SEMI_PARALLEL_GAMMA_BUCKETED, SwapMeasureCalculations.DEFAULT::pv01SemiParallelGammaBucketed).put((Object)AdvancedMeasures.PV01_SINGLE_NODE_GAMMA_BUCKETED, SwapMeasureCalculations.DEFAULT::pv01SingleNodeGammaBucketed).build();
    private static final ImmutableSet<Measure> MEASURES = CALCULATORS.keySet();

    public Class<SwapTrade> targetType() {
        return SwapTrade.class;
    }

    public Set<Measure> supportedMeasures() {
        return MEASURES;
    }

    public Optional<String> identifier(SwapTrade target) {
        return target.getInfo().getId().map(id -> id.toString());
    }

    public Currency naturalCurrency(SwapTrade trade, ReferenceData refData) {
        return ((SwapLeg)trade.getProduct().getLegs().get(0)).getCurrency();
    }

    public FunctionRequirements requirements(SwapTrade trade, Set<Measure> measures, CalculationParameters parameters, ReferenceData refData) {
        Swap product = trade.getProduct();
        ImmutableSet currencies = product.allPaymentCurrencies();
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        return ratesLookup.requirements((Set<Currency>)currencies, (Set<? extends Index>)product.allIndices());
    }

    public Map<Measure, Result<?>> calculate(SwapTrade trade, Set<Measure> measures, CalculationParameters parameters, ScenarioMarketData scenarioMarketData, ReferenceData refData) {
        ResolvedSwapTrade resolved = trade.resolve(refData);
        RatesMarketDataLookup ratesLookup = (RatesMarketDataLookup)parameters.getParameter(RatesMarketDataLookup.class);
        RatesScenarioMarketData marketData = ratesLookup.marketDataView(scenarioMarketData);
        HashMap results = new HashMap();
        for (Measure measure : measures) {
            results.put(measure, this.calculate(measure, resolved, marketData));
        }
        return results;
    }

    private Result<?> calculate(Measure measure, ResolvedSwapTrade trade, RatesScenarioMarketData marketData) {
        SingleMeasureCalculation calculator = (SingleMeasureCalculation)CALCULATORS.get((Object)measure);
        if (calculator == null) {
            return Result.failure((FailureReason)FailureReason.UNSUPPORTED, (String)"Unsupported measure for SwapTrade: {}", (Object[])new Object[]{measure});
        }
        return Result.of(() -> calculator.calculate(trade, marketData));
    }

    @FunctionalInterface
    static interface SingleMeasureCalculation {
        public Object calculate(ResolvedSwapTrade var1, RatesScenarioMarketData var2);
    }
}

