/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.swaption;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.measure.rate.RatesScenarioMarketData;
import com.opengamma.strata.measure.swaption.SwaptionScenarioMarketData;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.pricer.swaption.SabrSwaptionTradePricer;
import com.opengamma.strata.pricer.swaption.SabrSwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.VolatilitySwaptionTradePricer;
import com.opengamma.strata.product.swaption.ResolvedSwaptionTrade;
import java.time.LocalDate;

final class SwaptionMeasureCalculations {
    public static final SwaptionMeasureCalculations DEFAULT = new SwaptionMeasureCalculations(VolatilitySwaptionTradePricer.DEFAULT, SabrSwaptionTradePricer.DEFAULT);
    private static final MarketQuoteSensitivityCalculator MARKET_QUOTE_SENS = MarketQuoteSensitivityCalculator.DEFAULT;
    private static final double ONE_BASIS_POINT = 1.0E-4;
    private final VolatilitySwaptionTradePricer tradePricer;
    private final SabrSwaptionTradePricer sabrTradePricer;

    SwaptionMeasureCalculations(VolatilitySwaptionTradePricer tradePricer, SabrSwaptionTradePricer sabrTradePricer) {
        this.tradePricer = (VolatilitySwaptionTradePricer)ArgChecker.notNull((Object)tradePricer, (String)"tradePricer");
        this.sabrTradePricer = (SabrSwaptionTradePricer)ArgChecker.notNull((Object)sabrTradePricer, (String)"sabrTradePricer");
    }

    CurrencyScenarioArray presentValue(ResolvedSwaptionTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = trade.getProduct().getIndex();
        return CurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.presentValue(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    CurrencyAmount presentValue(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.tradePricer.presentValue(trade, ratesProvider, volatilities);
    }

    MultiCurrencyScenarioArray pv01RatesCalibratedSum(ResolvedSwaptionTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = trade.getProduct().getIndex();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesCalibratedSum(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount pv01RatesCalibratedSum(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        PointSensitivities pointSensitivity = this.pointSensitivity(trade, ratesProvider, volatilities);
        return ratesProvider.parameterSensitivity(pointSensitivity).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01RatesCalibratedBucketed(ResolvedSwaptionTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = trade.getProduct().getIndex();
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesCalibratedBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    CurrencyParameterSensitivities pv01RatesCalibratedBucketed(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        PointSensitivities pointSensitivity = this.pointSensitivity(trade, ratesProvider, volatilities);
        return ratesProvider.parameterSensitivity(pointSensitivity).multipliedBy(1.0E-4);
    }

    MultiCurrencyScenarioArray pv01RatesMarketQuoteSum(ResolvedSwaptionTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = trade.getProduct().getIndex();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesMarketQuoteSum(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount pv01RatesMarketQuoteSum(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        PointSensitivities pointSensitivity = this.pointSensitivity(trade, ratesProvider, volatilities);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).total().multipliedBy(1.0E-4);
    }

    ScenarioArray<CurrencyParameterSensitivities> pv01RatesMarketQuoteBucketed(ResolvedSwaptionTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = trade.getProduct().getIndex();
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.pv01RatesMarketQuoteBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    CurrencyParameterSensitivities pv01RatesMarketQuoteBucketed(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        PointSensitivities pointSensitivity = this.pointSensitivity(trade, ratesProvider, volatilities);
        CurrencyParameterSensitivities parameterSensitivity = ratesProvider.parameterSensitivity(pointSensitivity);
        return MARKET_QUOTE_SENS.sensitivity(parameterSensitivity, ratesProvider).multipliedBy(1.0E-4);
    }

    private PointSensitivities pointSensitivity(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        if (volatilities instanceof SabrSwaptionVolatilities) {
            return this.sabrTradePricer.presentValueSensitivityRatesStickyModel(trade, ratesProvider, (SabrSwaptionVolatilities)volatilities);
        }
        return this.tradePricer.presentValueSensitivityRatesStickyStrike(trade, ratesProvider, volatilities);
    }

    ScenarioArray<CurrencyParameterSensitivities> vegaMarketQuoteBucketed(ResolvedSwaptionTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = trade.getProduct().getIndex();
        return ScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.vegaMarketQuoteBucketed(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    CurrencyParameterSensitivities vegaMarketQuoteBucketed(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        if (!volatilities.getVolatilityType().equals((Object)ValueType.NORMAL_VOLATILITY)) {
            throw new IllegalArgumentException("Vega calculation requires normal volatilities");
        }
        PointSensitivities pointSensitivity = this.pointSensitivityVega(trade, ratesProvider, volatilities);
        return volatilities.parameterSensitivity(pointSensitivity);
    }

    private PointSensitivities pointSensitivityVega(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.tradePricer.presentValueSensitivityModelParamsVolatility(trade, ratesProvider, volatilities);
    }

    MultiCurrencyScenarioArray currencyExposure(ResolvedSwaptionTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        RateIndex index = trade.getProduct().getIndex();
        return MultiCurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.currencyExposure(trade, ratesMarketData.scenario(i).ratesProvider(), swaptionMarketData.scenario(i).volatilities(index)));
    }

    MultiCurrencyAmount currencyExposure(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.tradePricer.currencyExposure(trade, ratesProvider, volatilities);
    }

    CurrencyScenarioArray currentCash(ResolvedSwaptionTrade trade, RatesScenarioMarketData ratesMarketData, SwaptionScenarioMarketData swaptionMarketData) {
        return CurrencyScenarioArray.of((int)ratesMarketData.getScenarioCount(), i -> this.currentCash(trade, ratesMarketData.scenario(i).getValuationDate()));
    }

    CurrencyAmount currentCash(ResolvedSwaptionTrade trade, LocalDate valuationDate) {
        return this.tradePricer.currentCash(trade, valuationDate);
    }
}

