/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.measure.swaption;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.data.scenario.CurrencyScenarioArray;
import com.opengamma.strata.data.scenario.MultiCurrencyScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioArray;
import com.opengamma.strata.data.scenario.ScenarioMarketData;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.measure.rate.RatesMarketDataLookup;
import com.opengamma.strata.measure.swaption.SwaptionMarketDataLookup;
import com.opengamma.strata.measure.swaption.SwaptionMeasureCalculations;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swaption.SabrSwaptionTradePricer;
import com.opengamma.strata.pricer.swaption.SwaptionVolatilities;
import com.opengamma.strata.pricer.swaption.VolatilitySwaptionTradePricer;
import com.opengamma.strata.product.swaption.ResolvedSwaptionTrade;

public class SwaptionTradeCalculations {
    public static final SwaptionTradeCalculations DEFAULT = new SwaptionTradeCalculations(VolatilitySwaptionTradePricer.DEFAULT, SabrSwaptionTradePricer.DEFAULT);
    private final SwaptionMeasureCalculations calc;

    public SwaptionTradeCalculations(VolatilitySwaptionTradePricer tradePricer, SabrSwaptionTradePricer sabrTradePricer) {
        this.calc = new SwaptionMeasureCalculations(tradePricer, sabrTradePricer);
    }

    public CurrencyScenarioArray presentValue(ResolvedSwaptionTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.presentValue(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public CurrencyAmount presentValue(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.presentValue(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray pv01RatesCalibratedSum(ResolvedSwaptionTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.pv01RatesCalibratedSum(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01RatesCalibratedSum(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.pv01RatesCalibratedSum(trade, ratesProvider, volatilities);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01RatesCalibratedBucketed(ResolvedSwaptionTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.pv01RatesCalibratedBucketed(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01RatesCalibratedBucketed(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.pv01RatesCalibratedBucketed(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray pv01RatesMarketQuoteSum(ResolvedSwaptionTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.pv01RatesMarketQuoteSum(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount pv01RatesMarketQuoteSum(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.pv01RatesMarketQuoteSum(trade, ratesProvider, volatilities);
    }

    public ScenarioArray<CurrencyParameterSensitivities> pv01RatesMarketQuoteBucketed(ResolvedSwaptionTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.pv01RatesMarketQuoteBucketed(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities pv01RatesMarketQuoteBucketed(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.pv01RatesMarketQuoteBucketed(trade, ratesProvider, volatilities);
    }

    public ScenarioArray<CurrencyParameterSensitivities> vegaMarketQuoteBucketed(ResolvedSwaptionTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.vegaMarketQuoteBucketed(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public CurrencyParameterSensitivities vegaMarketQuoteBucketed(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.vegaMarketQuoteBucketed(trade, ratesProvider, volatilities);
    }

    public MultiCurrencyScenarioArray currencyExposure(ResolvedSwaptionTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.currencyExposure(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public MultiCurrencyAmount currencyExposure(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.currencyExposure(trade, ratesProvider, volatilities);
    }

    public CurrencyScenarioArray currentCash(ResolvedSwaptionTrade trade, RatesMarketDataLookup ratesLookup, SwaptionMarketDataLookup swaptionLookup, ScenarioMarketData marketData) {
        return this.calc.currentCash(trade, ratesLookup.marketDataView(marketData), swaptionLookup.marketDataView(marketData));
    }

    public CurrencyAmount currentCash(ResolvedSwaptionTrade trade, RatesProvider ratesProvider, SwaptionVolatilities volatilities) {
        return this.calc.currentCash(trade, ratesProvider.getValuationDate());
    }
}

