/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.MarketDataView;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.pricer.CompoundedRateType;
import com.opengamma.strata.pricer.SimpleDiscountFactors;
import com.opengamma.strata.pricer.ZeroRateDiscountFactors;
import com.opengamma.strata.pricer.ZeroRatePeriodicDiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import java.time.LocalDate;
import java.util.Optional;

public interface DiscountFactors
extends MarketDataView,
ParameterizedData {
    public static DiscountFactors of(Currency currency, LocalDate valuationDate, Curve curve) {
        if (curve.getMetadata().getYValueType().equals((Object)ValueType.DISCOUNT_FACTOR)) {
            return SimpleDiscountFactors.of(currency, valuationDate, curve);
        }
        if (curve.getMetadata().getYValueType().equals((Object)ValueType.ZERO_RATE)) {
            Optional frequencyOpt = curve.getMetadata().findInfo(CurveInfoType.COMPOUNDING_PER_YEAR);
            if (frequencyOpt.isPresent()) {
                return ZeroRatePeriodicDiscountFactors.of(currency, valuationDate, curve);
            }
            return ZeroRateDiscountFactors.of(currency, valuationDate, curve);
        }
        throw new IllegalArgumentException(Messages.format((String)"Unknown value type in discount curve, must be 'DiscountFactor' or 'ZeroRate' but was '{}'", (Object)curve.getMetadata().getYValueType()));
    }

    public Currency getCurrency();

    public DiscountFactors withParameter(int var1, double var2);

    public DiscountFactors withPerturbation(ParameterPerturbation var1);

    public double relativeYearFraction(LocalDate var1);

    default public double discountFactor(LocalDate date) {
        double yearFraction = this.relativeYearFraction(date);
        return this.discountFactor(yearFraction);
    }

    public double discountFactor(double var1);

    public double discountFactorTimeDerivative(double var1);

    default public double discountFactorWithSpread(LocalDate date, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        double yearFraction = this.relativeYearFraction(date);
        return this.discountFactorWithSpread(yearFraction, zSpread, compoundedRateType, periodsPerYear);
    }

    default public double discountFactorWithSpread(double yearFraction, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        if (yearFraction < 1.0E-10) {
            return 1.0;
        }
        double df = this.discountFactor(yearFraction);
        if (compoundedRateType.equals((Object)CompoundedRateType.PERIODIC)) {
            ArgChecker.notNegativeOrZero((int)periodsPerYear, (String)"periodPerYear");
            double ratePeriodicAnnualPlusOne = Math.pow(df, -1.0 / (double)periodsPerYear / yearFraction) + zSpread / (double)periodsPerYear;
            return Math.pow(ratePeriodicAnnualPlusOne, (double)(-periodsPerYear) * yearFraction);
        }
        return df * Math.exp(-zSpread * yearFraction);
    }

    default public double zeroRate(LocalDate date) {
        double yearFraction = this.relativeYearFraction(date);
        return this.zeroRate(yearFraction);
    }

    public double zeroRate(double var1);

    default public ZeroRateSensitivity zeroRatePointSensitivity(LocalDate date) {
        double yearFraction = this.relativeYearFraction(date);
        return this.zeroRatePointSensitivity(yearFraction);
    }

    default public ZeroRateSensitivity zeroRatePointSensitivity(double yearFraction) {
        return this.zeroRatePointSensitivity(yearFraction, this.getCurrency());
    }

    default public ZeroRateSensitivity zeroRatePointSensitivity(LocalDate date, Currency sensitivityCurrency) {
        double yearFraction = this.relativeYearFraction(date);
        return this.zeroRatePointSensitivity(yearFraction, sensitivityCurrency);
    }

    public ZeroRateSensitivity zeroRatePointSensitivity(double var1, Currency var3);

    default public ZeroRateSensitivity zeroRatePointSensitivityWithSpread(LocalDate date, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        double yearFraction = this.relativeYearFraction(date);
        return this.zeroRatePointSensitivityWithSpread(yearFraction, zSpread, compoundedRateType, periodsPerYear);
    }

    default public ZeroRateSensitivity zeroRatePointSensitivityWithSpread(double yearFraction, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        return this.zeroRatePointSensitivityWithSpread(yearFraction, this.getCurrency(), zSpread, compoundedRateType, periodsPerYear);
    }

    default public ZeroRateSensitivity zeroRatePointSensitivityWithSpread(LocalDate date, Currency sensitivityCurrency, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        double yearFraction = this.relativeYearFraction(date);
        return this.zeroRatePointSensitivityWithSpread(yearFraction, sensitivityCurrency, zSpread, compoundedRateType, periodsPerYear);
    }

    default public ZeroRateSensitivity zeroRatePointSensitivityWithSpread(double yearFraction, Currency sensitivityCurrency, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        double factor;
        if (yearFraction <= 1.0E-10) {
            return ZeroRateSensitivity.of(this.getCurrency(), yearFraction, sensitivityCurrency, 0.0);
        }
        ZeroRateSensitivity sensi = this.zeroRatePointSensitivity(yearFraction, sensitivityCurrency);
        if (compoundedRateType.equals((Object)CompoundedRateType.PERIODIC)) {
            double df = this.discountFactor(yearFraction);
            double dfRoot = Math.pow(df, -1.0 / (double)periodsPerYear / yearFraction);
            factor = dfRoot / df / Math.pow(dfRoot + zSpread / (double)periodsPerYear, (double)periodsPerYear * yearFraction + 1.0);
        } else {
            factor = Math.exp(-zSpread * yearFraction);
        }
        return sensi.multipliedBy(factor);
    }

    public CurrencyParameterSensitivities parameterSensitivity(ZeroRateSensitivity var1);

    public CurrencyParameterSensitivities createParameterSensitivity(Currency var1, DoubleArray var2);
}

