/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class SimpleDiscountFactors
implements DiscountFactors,
ImmutableBean,
Serializable {
    static final double EFFECTIVE_ZERO = 1.0E-10;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate valuationDate;
    @PropertyDefinition(validate="notNull")
    private final Curve curve;
    private final transient DayCount dayCount;
    private static final long serialVersionUID = 1L;

    public static SimpleDiscountFactors of(Currency currency, LocalDate valuationDate, Curve underlyingCurve) {
        return new SimpleDiscountFactors(currency, valuationDate, underlyingCurve);
    }

    @ImmutableConstructor
    private SimpleDiscountFactors(Currency currency, LocalDate valuationDate, Curve curve) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        ArgChecker.notNull((Object)curve, (String)"curve");
        curve.getMetadata().getXValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect x-value type for discount curve");
        curve.getMetadata().getYValueType().checkEquals(ValueType.DISCOUNT_FACTOR, "Incorrect y-value type for discount curve");
        DayCount dayCount = (DayCount)curve.getMetadata().findInfo(CurveInfoType.DAY_COUNT).orElseThrow(() -> new IllegalArgumentException("Incorrect curve metadata, missing DayCount"));
        this.currency = currency;
        this.valuationDate = valuationDate;
        this.curve = curve;
        this.dayCount = dayCount;
    }

    private Object readResolve() {
        return new SimpleDiscountFactors(this.currency, this.valuationDate, this.curve);
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.curve.getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.curve));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.curve.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.curve.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.curve.getParameterMetadata(parameterIndex);
    }

    public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.curve.findParameterIndex(metadata);
    }

    @Override
    public SimpleDiscountFactors withParameter(int parameterIndex, double newValue) {
        return this.withCurve(this.curve.withParameter(parameterIndex, newValue));
    }

    @Override
    public SimpleDiscountFactors withPerturbation(ParameterPerturbation perturbation) {
        return this.withCurve(this.curve.withPerturbation(perturbation));
    }

    @Override
    public double relativeYearFraction(LocalDate date) {
        return this.dayCount.relativeYearFraction(this.valuationDate, date);
    }

    @Override
    public double discountFactor(double yearFraction) {
        if (yearFraction <= 1.0E-10) {
            return 1.0;
        }
        return this.curve.yValue(yearFraction);
    }

    @Override
    public double discountFactorTimeDerivative(double yearFraction) {
        if (yearFraction <= 1.0E-10) {
            return 0.0;
        }
        return this.curve.firstDerivative(yearFraction);
    }

    @Override
    public double zeroRate(double yearFraction) {
        double yearFractionMod = Math.max(1.0E-10, yearFraction);
        double discountFactor = this.discountFactor(yearFractionMod);
        return -Math.log(discountFactor) / yearFractionMod;
    }

    @Override
    public ZeroRateSensitivity zeroRatePointSensitivity(double yearFraction, Currency sensitivityCurrency) {
        double discountFactor = this.discountFactor(yearFraction);
        if (yearFraction <= 1.0E-10) {
            return ZeroRateSensitivity.of(this.currency, yearFraction, sensitivityCurrency, 0.0);
        }
        return ZeroRateSensitivity.of(this.currency, yearFraction, sensitivityCurrency, -discountFactor * yearFraction);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(ZeroRateSensitivity pointSens) {
        double yearFraction = pointSens.getYearFraction();
        if (yearFraction <= 1.0E-10) {
            return CurrencyParameterSensitivities.empty();
        }
        double discountFactor = this.discountFactor(yearFraction);
        UnitParameterSensitivity unitSens = this.curve.yValueParameterSensitivity(yearFraction);
        CurrencyParameterSensitivity curSens = unitSens.multipliedBy(-1.0 / (yearFraction * discountFactor)).multipliedBy(pointSens.getCurrency(), pointSens.getSensitivity());
        return CurrencyParameterSensitivities.of((CurrencyParameterSensitivity)curSens);
    }

    @Override
    public CurrencyParameterSensitivities createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        return CurrencyParameterSensitivities.of((CurrencyParameterSensitivity)this.curve.createParameterSensitivity(currency, sensitivities));
    }

    public SimpleDiscountFactors withCurve(Curve curve) {
        return new SimpleDiscountFactors(this.currency, this.valuationDate, curve);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SimpleDiscountFactors other = (SimpleDiscountFactors)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.valuationDate, (Object)other.valuationDate) && JodaBeanUtils.equal((Object)this.curve, (Object)other.curve);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curve);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("SimpleDiscountFactors{");
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
        buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SimpleDiscountFactors> {
        private Currency currency;
        private LocalDate valuationDate;
        private Curve curve;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case 95027439: {
                    return this.curve;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 113107279: {
                    this.valuationDate = (LocalDate)newValue;
                    break;
                }
                case 95027439: {
                    this.curve = (Curve)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SimpleDiscountFactors build() {
            return new SimpleDiscountFactors(this.currency, this.valuationDate, this.curve);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("SimpleDiscountFactors.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
            buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", SimpleDiscountFactors.class, Currency.class);
        private final MetaProperty<LocalDate> valuationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDate", SimpleDiscountFactors.class, LocalDate.class);
        private final MetaProperty<Curve> curve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curve", SimpleDiscountFactors.class, Curve.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "valuationDate", "curve"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case 95027439: {
                    return this.curve;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SimpleDiscountFactors> builder() {
            return new Builder();
        }

        public Class<? extends SimpleDiscountFactors> beanType() {
            return SimpleDiscountFactors.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<LocalDate> valuationDate() {
            return this.valuationDate;
        }

        public MetaProperty<Curve> curve() {
            return this.curve;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((SimpleDiscountFactors)bean).getCurrency();
                }
                case 113107279: {
                    return ((SimpleDiscountFactors)bean).getValuationDate();
                }
                case 95027439: {
                    return ((SimpleDiscountFactors)bean).getCurve();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

