/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.bond.BlackBondFutureVolatilities;
import com.opengamma.strata.pricer.bond.BondFutureOptionSensitivity;
import com.opengamma.strata.pricer.bond.BondFutureVolatilities;
import com.opengamma.strata.pricer.bond.DiscountingBondFutureProductPricer;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.product.bond.ResolvedBondFuture;
import com.opengamma.strata.product.bond.ResolvedBondFutureOption;
import com.opengamma.strata.product.option.FutureOptionPremiumStyle;

public final class BlackBondFutureOptionMarginedProductPricer {
    public static final BlackBondFutureOptionMarginedProductPricer DEFAULT = new BlackBondFutureOptionMarginedProductPricer(DiscountingBondFutureProductPricer.DEFAULT);
    private final DiscountingBondFutureProductPricer futurePricer;

    public BlackBondFutureOptionMarginedProductPricer(DiscountingBondFutureProductPricer futurePricer) {
        this.futurePricer = (DiscountingBondFutureProductPricer)ArgChecker.notNull((Object)futurePricer, (String)"futurePricer");
    }

    DiscountingBondFutureProductPricer getFuturePricer() {
        return this.futurePricer;
    }

    double marginIndex(ResolvedBondFutureOption option, double price) {
        double notional = option.getUnderlyingFuture().getNotional();
        return price * notional;
    }

    PointSensitivities marginIndexSensitivity(ResolvedBondFutureOption option, PointSensitivities priceSensitivity) {
        double notional = option.getUnderlyingFuture().getNotional();
        return priceSensitivity.multipliedBy(notional);
    }

    public double price(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities) {
        double futurePrice = this.futurePrice(futureOption, discountingProvider);
        return this.price(futureOption, discountingProvider, volatilities, futurePrice);
    }

    public double price(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities, double futurePrice) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        double strike = futureOption.getStrikePrice();
        ResolvedBondFuture future = futureOption.getUnderlyingFuture();
        double volatility = volatilities.volatility(futureOption.getExpiry(), future.getLastTradeDate(), strike, futurePrice);
        double timeToExpiry = volatilities.relativeTime(futureOption.getExpiry());
        double price = BlackFormulaRepository.price(futurePrice, strike, timeToExpiry, volatility, futureOption.getPutCall().isCall());
        return price;
    }

    double price(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        ArgChecker.isTrue((boolean)(volatilities instanceof BlackBondFutureVolatilities), (String)"Provider must be of type BlackVolatilityBondFutureProvider");
        return this.price(futureOption, discountingProvider, (BlackBondFutureVolatilities)volatilities);
    }

    public double deltaStickyStrike(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities) {
        double futurePrice = this.futurePrice(futureOption, discountingProvider);
        return this.deltaStickyStrike(futureOption, discountingProvider, volatilities, futurePrice);
    }

    public double deltaStickyStrike(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities, double futurePrice) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        double strike = futureOption.getStrikePrice();
        ResolvedBondFuture future = futureOption.getUnderlyingFuture();
        double volatility = volatilities.volatility(futureOption.getExpiry(), future.getLastTradeDate(), strike, futurePrice);
        double timeToExpiry = volatilities.relativeTime(futureOption.getExpiry());
        double delta = BlackFormulaRepository.delta(futurePrice, strike, timeToExpiry, volatility, futureOption.getPutCall().isCall());
        return delta;
    }

    public double gammaStickyStrike(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities) {
        double futurePrice = this.futurePrice(futureOption, discountingProvider);
        return this.gammaStickyStrike(futureOption, discountingProvider, volatilities, futurePrice);
    }

    public double gammaStickyStrike(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities, double futurePrice) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        double strike = futureOption.getStrikePrice();
        ResolvedBondFuture future = futureOption.getUnderlyingFuture();
        double volatility = volatilities.volatility(futureOption.getExpiry(), future.getLastTradeDate(), strike, futurePrice);
        double timeToExpiry = volatilities.relativeTime(futureOption.getExpiry());
        double gamma = BlackFormulaRepository.gamma(futurePrice, strike, timeToExpiry, volatility);
        return gamma;
    }

    public double theta(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities) {
        double futurePrice = this.futurePrice(futureOption, discountingProvider);
        return this.theta(futureOption, discountingProvider, volatilities, futurePrice);
    }

    public double theta(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities, double futurePrice) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        double strike = futureOption.getStrikePrice();
        ResolvedBondFuture future = futureOption.getUnderlyingFuture();
        double volatility = volatilities.volatility(futureOption.getExpiry(), future.getLastTradeDate(), strike, futurePrice);
        double timeToExpiry = volatilities.relativeTime(futureOption.getExpiry());
        double theta = BlackFormulaRepository.driftlessTheta(futurePrice, strike, timeToExpiry, volatility);
        return theta;
    }

    public PointSensitivities priceSensitivityRatesStickyStrike(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        double futurePrice = this.futurePrice(futureOption, discountingProvider);
        return this.priceSensitivityRatesStickyStrike(futureOption, discountingProvider, volatilities, futurePrice);
    }

    public PointSensitivities priceSensitivityRatesStickyStrike(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities, double futurePrice) {
        double delta = this.deltaStickyStrike(futureOption, discountingProvider, volatilities, futurePrice);
        PointSensitivities futurePriceSensitivity = this.futurePricer.priceSensitivity(futureOption.getUnderlyingFuture(), discountingProvider);
        return futurePriceSensitivity.multipliedBy(delta);
    }

    PointSensitivities priceSensitivity(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BondFutureVolatilities volatilities) {
        ArgChecker.isTrue((boolean)(volatilities instanceof BlackBondFutureVolatilities), (String)"Provider must be of type BlackVolatilityBondFutureProvider");
        return this.priceSensitivityRatesStickyStrike(futureOption, discountingProvider, (BlackBondFutureVolatilities)volatilities);
    }

    public BondFutureOptionSensitivity priceSensitivityModelParamsVolatility(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities) {
        double futurePrice = this.futurePrice(futureOption, discountingProvider);
        return this.priceSensitivityModelParamsVolatility(futureOption, discountingProvider, volatilities, futurePrice);
    }

    public BondFutureOptionSensitivity priceSensitivityModelParamsVolatility(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider, BlackBondFutureVolatilities volatilities, double futurePrice) {
        ArgChecker.isTrue((boolean)futureOption.getPremiumStyle().equals((Object)FutureOptionPremiumStyle.DAILY_MARGIN), (String)"Premium style should be DAILY_MARGIN");
        double strike = futureOption.getStrikePrice();
        ResolvedBondFuture future = futureOption.getUnderlyingFuture();
        double volatility = volatilities.volatility(futureOption.getExpiry(), future.getLastTradeDate(), strike, futurePrice);
        double timeToExpiry = volatilities.relativeTime(futureOption.getExpiry());
        double vega = BlackFormulaRepository.vega(futurePrice, strike, timeToExpiry, volatility);
        return BondFutureOptionSensitivity.of(volatilities.getName(), timeToExpiry, future.getLastTradeDate(), strike, futurePrice, future.getCurrency(), vega);
    }

    private double futurePrice(ResolvedBondFutureOption futureOption, LegalEntityDiscountingProvider discountingProvider) {
        ResolvedBondFuture future = futureOption.getUnderlyingFuture();
        return this.futurePricer.price(future, discountingProvider);
    }
}

