/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.bond.BondVolatilitiesName;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class BondYieldSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final BondVolatilitiesName volatilitiesName;
    @PropertyDefinition(validate="notNull")
    private final double expiry;
    @PropertyDefinition
    private final double duration;
    @PropertyDefinition
    private final double strike;
    @PropertyDefinition
    private final double forward;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static BondYieldSensitivity of(BondVolatilitiesName volatilitiesName, double expiry, double duration, double strike, double forward, Currency sensitivityCurrency, double sensitivity) {
        return new BondYieldSensitivity(volatilitiesName, expiry, duration, strike, forward, sensitivityCurrency, sensitivity);
    }

    public BondYieldSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new BondYieldSensitivity(this.volatilitiesName, this.expiry, this.duration, this.strike, this.forward, currency, this.sensitivity);
    }

    public BondYieldSensitivity withSensitivity(double value) {
        return new BondYieldSensitivity(this.volatilitiesName, this.expiry, this.duration, this.strike, this.forward, this.currency, value);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof BondYieldSensitivity) {
            BondYieldSensitivity otherSwpt = (BondYieldSensitivity)other;
            return ComparisonChain.start().compare((Comparable)((Object)this.volatilitiesName), (Comparable)((Object)otherSwpt.volatilitiesName)).compare((Comparable)this.currency, (Comparable)otherSwpt.currency).compare(this.expiry, otherSwpt.expiry).compare(this.duration, otherSwpt.duration).compare(this.strike, otherSwpt.strike).compare(this.forward, otherSwpt.forward).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public BondYieldSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (BondYieldSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public BondYieldSensitivity multipliedBy(double factor) {
        return new BondYieldSensitivity(this.volatilitiesName, this.expiry, this.duration, this.strike, this.forward, this.currency, this.sensitivity * factor);
    }

    public BondYieldSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new BondYieldSensitivity(this.volatilitiesName, this.expiry, this.duration, this.strike, this.forward, this.currency, operator.applyAsDouble(this.sensitivity));
    }

    public BondYieldSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public BondYieldSensitivity cloned() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private BondYieldSensitivity(BondVolatilitiesName volatilitiesName, double expiry, double duration, double strike, double forward, Currency currency, double sensitivity) {
        JodaBeanUtils.notNull((Object)volatilitiesName, (String)"volatilitiesName");
        JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        this.volatilitiesName = volatilitiesName;
        this.expiry = expiry;
        this.duration = duration;
        this.strike = strike;
        this.forward = forward;
        this.currency = currency;
        this.sensitivity = sensitivity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public BondVolatilitiesName getVolatilitiesName() {
        return this.volatilitiesName;
    }

    public double getExpiry() {
        return this.expiry;
    }

    public double getDuration() {
        return this.duration;
    }

    public double getStrike() {
        return this.strike;
    }

    public double getForward() {
        return this.forward;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BondYieldSensitivity other = (BondYieldSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.volatilitiesName, (Object)other.volatilitiesName) && JodaBeanUtils.equal((double)this.expiry, (double)other.expiry) && JodaBeanUtils.equal((double)this.duration, (double)other.duration) && JodaBeanUtils.equal((double)this.strike, (double)other.strike) && JodaBeanUtils.equal((double)this.forward, (double)other.forward) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.volatilitiesName);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.duration);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.strike);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.forward);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("BondYieldSensitivity{");
        buf.append("volatilitiesName").append('=').append(JodaBeanUtils.toString((Object)this.volatilitiesName)).append(',').append(' ');
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("duration").append('=').append(JodaBeanUtils.toString((Object)this.duration)).append(',').append(' ');
        buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
        buf.append("forward").append('=').append(JodaBeanUtils.toString((Object)this.forward)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<BondYieldSensitivity> {
        private BondVolatilitiesName volatilitiesName;
        private double expiry;
        private double duration;
        private double strike;
        private double forward;
        private Currency currency;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return this.volatilitiesName;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case -1992012396: {
                    return this.duration;
                }
                case -891985998: {
                    return this.strike;
                }
                case -677145915: {
                    return this.forward;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    this.volatilitiesName = (BondVolatilitiesName)newValue;
                    break;
                }
                case -1289159373: {
                    this.expiry = (Double)newValue;
                    break;
                }
                case -1992012396: {
                    this.duration = (Double)newValue;
                    break;
                }
                case -891985998: {
                    this.strike = (Double)newValue;
                    break;
                }
                case -677145915: {
                    this.forward = (Double)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public BondYieldSensitivity build() {
            return new BondYieldSensitivity(this.volatilitiesName, this.expiry, this.duration, this.strike, this.forward, this.currency, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("BondYieldSensitivity.Builder{");
            buf.append("volatilitiesName").append('=').append(JodaBeanUtils.toString((Object)this.volatilitiesName)).append(',').append(' ');
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("duration").append('=').append(JodaBeanUtils.toString((Object)this.duration)).append(',').append(' ');
            buf.append("strike").append('=').append(JodaBeanUtils.toString((Object)this.strike)).append(',').append(' ');
            buf.append("forward").append('=').append(JodaBeanUtils.toString((Object)this.forward)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<BondVolatilitiesName> volatilitiesName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"volatilitiesName", BondYieldSensitivity.class, BondVolatilitiesName.class);
        private final MetaProperty<Double> expiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiry", BondYieldSensitivity.class, Double.TYPE);
        private final MetaProperty<Double> duration = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"duration", BondYieldSensitivity.class, Double.TYPE);
        private final MetaProperty<Double> strike = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"strike", BondYieldSensitivity.class, Double.TYPE);
        private final MetaProperty<Double> forward = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"forward", BondYieldSensitivity.class, Double.TYPE);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", BondYieldSensitivity.class, Currency.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", BondYieldSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"volatilitiesName", "expiry", "duration", "strike", "forward", "currency", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return this.volatilitiesName;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case -1992012396: {
                    return this.duration;
                }
                case -891985998: {
                    return this.strike;
                }
                case -677145915: {
                    return this.forward;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends BondYieldSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends BondYieldSensitivity> beanType() {
            return BondYieldSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<BondVolatilitiesName> volatilitiesName() {
            return this.volatilitiesName;
        }

        public MetaProperty<Double> expiry() {
            return this.expiry;
        }

        public MetaProperty<Double> duration() {
            return this.duration;
        }

        public MetaProperty<Double> strike() {
            return this.strike;
        }

        public MetaProperty<Double> forward() {
            return this.forward;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return ((BondYieldSensitivity)bean).getVolatilitiesName();
                }
                case -1289159373: {
                    return ((BondYieldSensitivity)bean).getExpiry();
                }
                case -1992012396: {
                    return ((BondYieldSensitivity)bean).getDuration();
                }
                case -891985998: {
                    return ((BondYieldSensitivity)bean).getStrike();
                }
                case -677145915: {
                    return ((BondYieldSensitivity)bean).getForward();
                }
                case 575402001: {
                    return ((BondYieldSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((BondYieldSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

