/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.MarketDataView;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.pricer.bond.BondVolatilitiesName;
import java.time.LocalDate;
import java.time.ZonedDateTime;

public interface BondYieldVolatilities
extends MarketDataView,
ParameterizedData {
    public Currency getCurrency();

    public BondVolatilitiesName getName();

    public ValueType getVolatilityType();

    public ZonedDateTime getValuationDateTime();

    default public LocalDate getValuationDate() {
        return this.getValuationDateTime().toLocalDate();
    }

    public BondYieldVolatilities withParameter(int var1, double var2);

    public BondYieldVolatilities withPerturbation(ParameterPerturbation var1);

    public double volatility(double var1, double var3, double var5, double var7);

    default public double volatility(ZonedDateTime expiryDateTime, double duration, double strike, double forward) {
        return this.volatility(this.relativeTime(expiryDateTime), duration, strike, forward);
    }

    default public double priceVolatilityEquivalent(double expiry, double duration, double strike, double forward) {
        double yieldVolatility = this.volatility(expiry, duration, strike, forward);
        return this.priceVolatilityEquivalent(duration, yieldVolatility);
    }

    default public ValueDerivatives priceVolatilityEquivalentAd(double expiry, double duration, double strike, double forward) {
        double yieldVolatility = this.volatility(expiry, duration, strike, forward);
        return this.priceVolatilityEquivalentAd(duration, yieldVolatility);
    }

    default public double priceVolatilityEquivalent(ZonedDateTime expiryDateTime, double duration, double strike, double forward) {
        double yieldVolatility = this.volatility(expiryDateTime, duration, strike, forward);
        return this.priceVolatilityEquivalent(duration, yieldVolatility);
    }

    default public ValueDerivatives priceVolatilityEquivalentAd(ZonedDateTime expiryDateTime, double duration, double strike, double forward) {
        double yieldVolatility = this.volatility(expiryDateTime, duration, strike, forward);
        return this.priceVolatilityEquivalentAd(duration, yieldVolatility);
    }

    default public double priceVolatilityEquivalent(double duration, double yieldVolatility) {
        return duration * yieldVolatility;
    }

    default public ValueDerivatives priceVolatilityEquivalentAd(double duration, double yieldVolatility) {
        double value = duration * yieldVolatility;
        return ValueDerivatives.of((double)value, (DoubleArray)DoubleArray.of((double)yieldVolatility, (double)duration));
    }

    default public CurrencyParameterSensitivities parameterSensitivity(PointSensitivity ... pointSensitivities) {
        return this.parameterSensitivity(PointSensitivities.of((PointSensitivity[])pointSensitivities));
    }

    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities var1);

    public double relativeTime(ZonedDateTime var1);
}

