/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.CompoundedRateType;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.bond.IssuerCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.IssuerCurveZeroRateSensitivity;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.bond.RepoCurveDiscountFactors;
import com.opengamma.strata.product.bond.ResolvedBill;
import java.time.LocalDate;

public class DiscountingBillProductPricer {
    public static final DiscountingBillProductPricer DEFAULT = new DiscountingBillProductPricer();

    public CurrencyAmount presentValue(ResolvedBill bill, LegalEntityDiscountingProvider provider) {
        if (provider.getValuationDate().isAfter(bill.getNotional().getDate())) {
            return CurrencyAmount.of((Currency)bill.getCurrency(), (double)0.0);
        }
        IssuerCurveDiscountFactors issuerDf = DiscountingBillProductPricer.issuerCurveDf(bill, provider);
        double dfMaturity = issuerDf.discountFactor(bill.getNotional().getDate());
        return bill.getNotional().getValue().multipliedBy(dfMaturity);
    }

    public CurrencyAmount presentValueWithZSpread(ResolvedBill bill, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        if (provider.getValuationDate().isAfter(bill.getNotional().getDate())) {
            return CurrencyAmount.of((Currency)bill.getCurrency(), (double)0.0);
        }
        IssuerCurveDiscountFactors issuerDf = DiscountingBillProductPricer.issuerCurveDf(bill, provider);
        double dfMaturity = issuerDf.getDiscountFactors().discountFactorWithSpread(bill.getNotional().getDate(), zSpread, compoundedRateType, periodsPerYear);
        return bill.getNotional().getValue().multipliedBy(dfMaturity);
    }

    public PointSensitivities presentValueSensitivity(ResolvedBill bill, LegalEntityDiscountingProvider provider) {
        if (provider.getValuationDate().isAfter(bill.getNotional().getDate())) {
            return PointSensitivities.empty();
        }
        IssuerCurveDiscountFactors issuerDf = DiscountingBillProductPricer.issuerCurveDf(bill, provider);
        double dfEndBar = bill.getNotional().getAmount();
        IssuerCurveZeroRateSensitivity sensMaturity = issuerDf.zeroRatePointSensitivity(bill.getNotional().getDate()).multipliedBy(dfEndBar);
        return sensMaturity.build();
    }

    public PointSensitivities presentValueSensitivityWithZSpread(ResolvedBill bill, LegalEntityDiscountingProvider provider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        if (provider.getValuationDate().isAfter(bill.getNotional().getDate())) {
            return PointSensitivities.empty();
        }
        IssuerCurveDiscountFactors issuerDf = DiscountingBillProductPricer.issuerCurveDf(bill, provider);
        double dfEndBar = bill.getNotional().getAmount();
        ZeroRateSensitivity zeroSensMaturity = issuerDf.getDiscountFactors().zeroRatePointSensitivityWithSpread(bill.getNotional().getDate(), zSpread, compoundedRateType, periodsPerYear);
        IssuerCurveZeroRateSensitivity dscSensMaturity = IssuerCurveZeroRateSensitivity.of(zeroSensMaturity, issuerDf.getLegalEntityGroup()).multipliedBy(dfEndBar);
        return dscSensMaturity.build();
    }

    public double priceFromCurves(ResolvedBill bill, LegalEntityDiscountingProvider provider, LocalDate settlementDate) {
        ArgChecker.inOrderNotEqual((Comparable)settlementDate, (Object)bill.getNotional().getDate(), (String)"settlementDate", (String)"endDate");
        ArgChecker.inOrderOrEqual((Comparable)provider.getValuationDate(), (Object)settlementDate, (String)"valuationDate", (String)"settlementDate");
        IssuerCurveDiscountFactors issuerDf = DiscountingBillProductPricer.issuerCurveDf(bill, provider);
        double dfMaturity = issuerDf.discountFactor(bill.getNotional().getDate());
        RepoCurveDiscountFactors repoDf = DiscountingBillProductPricer.repoCurveDf(bill, provider);
        double dfRepoSettle = repoDf.discountFactor(settlementDate);
        return dfMaturity / dfRepoSettle;
    }

    public double priceFromCurvesWithZSpread(ResolvedBill bill, LegalEntityDiscountingProvider provider, LocalDate settlementDate, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        ArgChecker.inOrderNotEqual((Comparable)settlementDate, (Object)bill.getNotional().getDate(), (String)"settlementDate", (String)"endDate");
        ArgChecker.inOrderOrEqual((Comparable)provider.getValuationDate(), (Object)settlementDate, (String)"valuationDate", (String)"settlementDate");
        IssuerCurveDiscountFactors issuerDf = DiscountingBillProductPricer.issuerCurveDf(bill, provider);
        double dfMaturity = issuerDf.getDiscountFactors().discountFactorWithSpread(bill.getNotional().getDate(), zSpread, compoundedRateType, periodsPerYear);
        RepoCurveDiscountFactors repoDf = DiscountingBillProductPricer.repoCurveDf(bill, provider);
        double dfRepoSettle = repoDf.discountFactor(settlementDate);
        return dfMaturity / dfRepoSettle;
    }

    public double yieldFromCurves(ResolvedBill bill, LegalEntityDiscountingProvider provider, LocalDate settlementDate) {
        double price = this.priceFromCurves(bill, provider, settlementDate);
        return bill.yieldFromPrice(price, settlementDate);
    }

    public double yieldFromCurvesWithZSpread(ResolvedBill bill, LegalEntityDiscountingProvider provider, LocalDate settlementDate, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        double price = this.priceFromCurvesWithZSpread(bill, provider, settlementDate, zSpread, compoundedRateType, periodsPerYear);
        return bill.yieldFromPrice(price, settlementDate);
    }

    static RepoCurveDiscountFactors repoCurveDf(ResolvedBill bill, LegalEntityDiscountingProvider provider) {
        return provider.repoCurveDiscountFactors(bill.getSecurityId(), bill.getLegalEntityId(), bill.getCurrency());
    }

    static IssuerCurveDiscountFactors issuerCurveDf(ResolvedBill bill, LegalEntityDiscountingProvider provider) {
        return provider.issuerCurveDiscountFactors(bill.getLegalEntityId(), bill.getCurrency());
    }
}

