/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Doubles;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.CompoundedRateType;
import com.opengamma.strata.pricer.bond.DiscountingFixedCouponBondProductPricer;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.product.bond.ResolvedBondFuture;
import com.opengamma.strata.product.bond.ResolvedFixedCouponBond;

public final class DiscountingBondFutureProductPricer {
    public static final DiscountingBondFutureProductPricer DEFAULT = new DiscountingBondFutureProductPricer(DiscountingFixedCouponBondProductPricer.DEFAULT);
    private final DiscountingFixedCouponBondProductPricer bondPricer;

    public DiscountingBondFutureProductPricer(DiscountingFixedCouponBondProductPricer bondPricer) {
        this.bondPricer = (DiscountingFixedCouponBondProductPricer)ArgChecker.notNull((Object)bondPricer, (String)"bondPricer");
    }

    double marginIndex(ResolvedBondFuture future, double price) {
        return price * future.getNotional();
    }

    PointSensitivities marginIndexSensitivity(ResolvedBondFuture future, PointSensitivities priceSensitivity) {
        return priceSensitivity.multipliedBy(future.getNotional());
    }

    public double price(ResolvedBondFuture future, LegalEntityDiscountingProvider discountingProvider) {
        ImmutableList basket = future.getDeliveryBasket();
        int size = basket.size();
        double[] priceBonds = new double[size];
        for (int i = 0; i < size; ++i) {
            ResolvedFixedCouponBond bond = (ResolvedFixedCouponBond)basket.get(i);
            double dirtyPrice = this.bondPricer.dirtyPriceFromCurves(bond, discountingProvider, future.getLastDeliveryDate());
            priceBonds[i] = this.bondPricer.cleanPriceFromDirtyPrice(bond, future.getLastDeliveryDate(), dirtyPrice) / (Double)future.getConversionFactors().get(i);
        }
        return Doubles.min((double[])priceBonds);
    }

    public double priceWithZSpread(ResolvedBondFuture future, LegalEntityDiscountingProvider discountingProvider, double zSpread, CompoundedRateType compoundedRateType, int periodPerYear) {
        ImmutableList basket = future.getDeliveryBasket();
        int size = basket.size();
        double[] priceBonds = new double[size];
        for (int i = 0; i < size; ++i) {
            ResolvedFixedCouponBond bond = (ResolvedFixedCouponBond)basket.get(i);
            double dirtyPrice = this.bondPricer.dirtyPriceFromCurvesWithZSpread(bond, discountingProvider, zSpread, compoundedRateType, periodPerYear, future.getLastDeliveryDate());
            priceBonds[i] = this.bondPricer.cleanPriceFromDirtyPrice(bond, future.getLastDeliveryDate(), dirtyPrice) / (Double)future.getConversionFactors().get(i);
        }
        return Doubles.min((double[])priceBonds);
    }

    public PointSensitivities priceSensitivity(ResolvedBondFuture future, LegalEntityDiscountingProvider discountingProvider) {
        ImmutableList basket = future.getDeliveryBasket();
        int size = basket.size();
        double[] priceBonds = new double[size];
        int indexCTD = 0;
        double priceMin = 2.0;
        for (int i = 0; i < size; ++i) {
            ResolvedFixedCouponBond bond = (ResolvedFixedCouponBond)basket.get(i);
            double dirtyPrice = this.bondPricer.dirtyPriceFromCurves(bond, discountingProvider, future.getLastDeliveryDate());
            priceBonds[i] = this.bondPricer.cleanPriceFromDirtyPrice(bond, future.getLastDeliveryDate(), dirtyPrice) / (Double)future.getConversionFactors().get(i);
            if (!(priceBonds[i] < priceMin)) continue;
            priceMin = priceBonds[i];
            indexCTD = i;
        }
        ResolvedFixedCouponBond bond = (ResolvedFixedCouponBond)basket.get(indexCTD);
        PointSensitivityBuilder pointSensi = this.bondPricer.dirtyPriceSensitivity(bond, discountingProvider, future.getLastDeliveryDate());
        return pointSensi.multipliedBy(1.0 / (Double)future.getConversionFactors().get(indexCTD)).build();
    }

    public PointSensitivities priceSensitivityWithZSpread(ResolvedBondFuture future, LegalEntityDiscountingProvider discountingProvider, double zSpread, CompoundedRateType compoundedRateType, int periodPerYear) {
        ImmutableList basket = future.getDeliveryBasket();
        int size = basket.size();
        double[] priceBonds = new double[size];
        int indexCTD = 0;
        double priceMin = 2.0;
        for (int i = 0; i < size; ++i) {
            ResolvedFixedCouponBond bond = (ResolvedFixedCouponBond)basket.get(i);
            double dirtyPrice = this.bondPricer.dirtyPriceFromCurvesWithZSpread(bond, discountingProvider, zSpread, compoundedRateType, periodPerYear, future.getLastDeliveryDate());
            priceBonds[i] = this.bondPricer.cleanPriceFromDirtyPrice(bond, future.getLastDeliveryDate(), dirtyPrice) / (Double)future.getConversionFactors().get(i);
            if (!(priceBonds[i] < priceMin)) continue;
            priceMin = priceBonds[i];
            indexCTD = i;
        }
        ResolvedFixedCouponBond bond = (ResolvedFixedCouponBond)basket.get(indexCTD);
        PointSensitivityBuilder pointSensi = this.bondPricer.dirtyPriceSensitivityWithZspread(bond, discountingProvider, zSpread, compoundedRateType, periodPerYear, future.getLastDeliveryDate());
        return pointSensi.multipliedBy(1.0 / (Double)future.getConversionFactors().get(indexCTD)).build();
    }
}

