/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.CompoundedRateType;
import com.opengamma.strata.pricer.bond.DiscountingCapitalIndexedBondProductPricer;
import com.opengamma.strata.pricer.bond.IssuerCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.LegalEntityDiscountingProvider;
import com.opengamma.strata.pricer.bond.RepoCurveDiscountFactors;
import com.opengamma.strata.pricer.bond.RepoCurveZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.bond.BondPaymentPeriod;
import com.opengamma.strata.product.bond.CapitalIndexedBondPaymentPeriod;
import com.opengamma.strata.product.bond.CapitalIndexedBondYieldConvention;
import com.opengamma.strata.product.bond.KnownAmountBondPaymentPeriod;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBond;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBondSettlement;
import com.opengamma.strata.product.bond.ResolvedCapitalIndexedBondTrade;
import java.time.LocalDate;

public class DiscountingCapitalIndexedBondTradePricer {
    public static final DiscountingCapitalIndexedBondTradePricer DEFAULT = new DiscountingCapitalIndexedBondTradePricer(DiscountingCapitalIndexedBondProductPricer.DEFAULT);
    private final DiscountingCapitalIndexedBondProductPricer productPricer;

    public DiscountingCapitalIndexedBondTradePricer(DiscountingCapitalIndexedBondProductPricer productPricer) {
        this.productPricer = (DiscountingCapitalIndexedBondProductPricer)ArgChecker.notNull((Object)productPricer, (String)"productPricer");
    }

    public CurrencyAmount presentValue(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate settlementDate = this.settlementDate(trade, ratesProvider.getValuationDate());
        CurrencyAmount pvProduct = this.productPricer.presentValue(trade.getProduct(), ratesProvider, discountingProvider, settlementDate);
        return this.presentValueFromProductPresentValue(trade, ratesProvider, discountingProvider, pvProduct);
    }

    public CurrencyAmount presentValueWithZSpread(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate settlementDate = this.settlementDate(trade, ratesProvider.getValuationDate());
        CurrencyAmount pvProduct = this.productPricer.presentValueWithZSpread(trade.getProduct(), ratesProvider, discountingProvider, settlementDate, zSpread, compoundedRateType, periodsPerYear);
        return this.presentValueFromProductPresentValue(trade, ratesProvider, discountingProvider, pvProduct);
    }

    public PointSensitivities presentValueSensitivity(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate settlementDate = this.settlementDate(trade, ratesProvider.getValuationDate());
        PointSensitivityBuilder productSensi = this.productPricer.presentValueSensitivity(trade.getProduct(), ratesProvider, discountingProvider, settlementDate);
        return this.presentValueSensitivityFromProductPresentValueSensitivity(trade, ratesProvider, discountingProvider, productSensi).build();
    }

    public PointSensitivities presentValueSensitivityWithZSpread(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate settlementDate = this.settlementDate(trade, ratesProvider.getValuationDate());
        PointSensitivityBuilder productSensi = this.productPricer.presentValueSensitivityWithZSpread(trade.getProduct(), ratesProvider, discountingProvider, settlementDate, zSpread, compoundedRateType, periodsPerYear);
        return this.presentValueSensitivityFromProductPresentValueSensitivity(trade, ratesProvider, discountingProvider, productSensi).build();
    }

    public CurrencyAmount presentValueFromCleanPrice(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, ReferenceData refData, double cleanRealPrice) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate valuationDate = ratesProvider.getValuationDate();
        ResolvedCapitalIndexedBond bond = trade.getProduct();
        LocalDate standardSettlementDate = bond.calculateSettlementDateFromValuation(valuationDate, refData);
        LocalDate tradeSettlementDate = this.settlementDate(trade, valuationDate);
        RepoCurveDiscountFactors repoDf = DiscountingCapitalIndexedBondProductPricer.repoCurveDf(bond, discountingProvider);
        double df = repoDf.discountFactor(standardSettlementDate);
        CurrencyAmount pvStandard = this.forecastValueStandardFromCleanPrice(bond, ratesProvider, standardSettlementDate, cleanRealPrice).multipliedBy(df);
        if (standardSettlementDate.isEqual(tradeSettlementDate)) {
            return this.presentValueFromProductPresentValue(trade, ratesProvider, discountingProvider, pvStandard);
        }
        IssuerCurveDiscountFactors issuerDf = DiscountingCapitalIndexedBondProductPricer.issuerCurveDf(bond, discountingProvider);
        double pvDiff = 0.0;
        pvDiff = standardSettlementDate.isAfter(tradeSettlementDate) ? -this.productPricer.presentValueCoupon(bond, ratesProvider, issuerDf, tradeSettlementDate, standardSettlementDate) : this.productPricer.presentValueCoupon(bond, ratesProvider, issuerDf, standardSettlementDate, tradeSettlementDate);
        return this.presentValueFromProductPresentValue(trade, ratesProvider, discountingProvider, pvStandard.plus(pvDiff));
    }

    public CurrencyAmount presentValueFromCleanPriceWithZSpread(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, ReferenceData refData, double cleanRealPrice, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate valuationDate = ratesProvider.getValuationDate();
        ResolvedCapitalIndexedBond bond = trade.getProduct();
        LocalDate standardSettlementDate = bond.calculateSettlementDateFromValuation(valuationDate, refData);
        LocalDate tradeSettlementDate = this.settlementDate(trade, valuationDate);
        RepoCurveDiscountFactors repoDf = DiscountingCapitalIndexedBondProductPricer.repoCurveDf(bond, discountingProvider);
        double df = repoDf.discountFactor(standardSettlementDate);
        CurrencyAmount pvStandard = this.forecastValueStandardFromCleanPrice(bond, ratesProvider, standardSettlementDate, cleanRealPrice).multipliedBy(df);
        if (standardSettlementDate.isEqual(tradeSettlementDate)) {
            return this.presentValueFromProductPresentValue(trade, ratesProvider, discountingProvider, pvStandard);
        }
        IssuerCurveDiscountFactors issuerDf = DiscountingCapitalIndexedBondProductPricer.issuerCurveDf(bond, discountingProvider);
        double pvDiff = 0.0;
        pvDiff = standardSettlementDate.isAfter(tradeSettlementDate) ? -this.productPricer.presentValueCouponWithZSpread(bond, ratesProvider, issuerDf, tradeSettlementDate, standardSettlementDate, zSpread, compoundedRateType, periodsPerYear) : this.productPricer.presentValueCouponWithZSpread(bond, ratesProvider, issuerDf, standardSettlementDate, tradeSettlementDate, zSpread, compoundedRateType, periodsPerYear);
        return this.presentValueFromProductPresentValue(trade, ratesProvider, discountingProvider, pvStandard.plus(pvDiff));
    }

    public PointSensitivities presentValueSensitivityFromCleanPrice(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, ReferenceData refData, double cleanRealPrice) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate valuationDate = ratesProvider.getValuationDate();
        ResolvedCapitalIndexedBond bond = trade.getProduct();
        LocalDate standardSettlementDate = bond.calculateSettlementDateFromValuation(valuationDate, refData);
        LocalDate tradeSettlementDate = this.settlementDate(trade, valuationDate);
        RepoCurveDiscountFactors repoDf = DiscountingCapitalIndexedBondProductPricer.repoCurveDf(bond, discountingProvider);
        double df = repoDf.discountFactor(standardSettlementDate);
        RepoCurveZeroRateSensitivity dfSensi = repoDf.zeroRatePointSensitivity(standardSettlementDate);
        PointSensitivityBuilder pvSensiStandard = this.forecastValueSensitivityStandardFromCleanPrice(bond, ratesProvider, standardSettlementDate, cleanRealPrice).multipliedBy(df).combinedWith(dfSensi.multipliedBy(this.forecastValueStandardFromCleanPrice(bond, ratesProvider, standardSettlementDate, cleanRealPrice).getAmount()));
        if (standardSettlementDate.isEqual(tradeSettlementDate)) {
            return this.presentValueSensitivityFromProductPresentValueSensitivity(trade, ratesProvider, discountingProvider, pvSensiStandard).build();
        }
        IssuerCurveDiscountFactors issuerDf = DiscountingCapitalIndexedBondProductPricer.issuerCurveDf(bond, discountingProvider);
        PointSensitivityBuilder pvSensiDiff = PointSensitivityBuilder.none();
        pvSensiDiff = standardSettlementDate.isAfter(tradeSettlementDate) ? pvSensiDiff.combinedWith(this.productPricer.presentValueSensitivityCoupon(bond, ratesProvider, issuerDf, tradeSettlementDate, standardSettlementDate).multipliedBy(-1.0)) : pvSensiDiff.combinedWith(this.productPricer.presentValueSensitivityCoupon(bond, ratesProvider, issuerDf, standardSettlementDate, tradeSettlementDate));
        return this.presentValueSensitivityFromProductPresentValueSensitivity(trade, ratesProvider, discountingProvider, pvSensiStandard.combinedWith(pvSensiDiff)).build();
    }

    public PointSensitivities presentValueSensitivityFromCleanPriceWithZSpread(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, ReferenceData refData, double cleanRealPrice, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        this.validate(ratesProvider, discountingProvider);
        LocalDate valuationDate = ratesProvider.getValuationDate();
        ResolvedCapitalIndexedBond bond = trade.getProduct();
        LocalDate standardSettlementDate = bond.calculateSettlementDateFromValuation(valuationDate, refData);
        LocalDate tradeSettlementDate = this.settlementDate(trade, valuationDate);
        RepoCurveDiscountFactors repoDf = DiscountingCapitalIndexedBondProductPricer.repoCurveDf(bond, discountingProvider);
        double df = repoDf.discountFactor(standardSettlementDate);
        RepoCurveZeroRateSensitivity dfSensi = repoDf.zeroRatePointSensitivity(standardSettlementDate);
        PointSensitivityBuilder pvSensiStandard = this.forecastValueSensitivityStandardFromCleanPrice(bond, ratesProvider, standardSettlementDate, cleanRealPrice).multipliedBy(df).combinedWith(dfSensi.multipliedBy(this.forecastValueStandardFromCleanPrice(bond, ratesProvider, standardSettlementDate, cleanRealPrice).getAmount()));
        if (standardSettlementDate.isEqual(tradeSettlementDate)) {
            return this.presentValueSensitivityFromProductPresentValueSensitivity(trade, ratesProvider, discountingProvider, pvSensiStandard).build();
        }
        IssuerCurveDiscountFactors issuerDf = DiscountingCapitalIndexedBondProductPricer.issuerCurveDf(bond, discountingProvider);
        PointSensitivityBuilder pvSensiDiff = PointSensitivityBuilder.none();
        pvSensiDiff = standardSettlementDate.isAfter(tradeSettlementDate) ? pvSensiDiff.combinedWith(this.productPricer.presentValueSensitivityCouponWithZSpread(bond, ratesProvider, issuerDf, tradeSettlementDate, standardSettlementDate, zSpread, compoundedRateType, periodsPerYear).multipliedBy(-1.0)) : pvSensiDiff.combinedWith(this.productPricer.presentValueSensitivityCouponWithZSpread(bond, ratesProvider, issuerDf, standardSettlementDate, tradeSettlementDate, zSpread, compoundedRateType, periodsPerYear));
        return this.presentValueSensitivityFromProductPresentValueSensitivity(trade, ratesProvider, discountingProvider, pvSensiStandard.combinedWith(pvSensiDiff)).build();
    }

    public MultiCurrencyAmount currencyExposureFromCleanPrice(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, ReferenceData refData, double cleanRealPrice) {
        CurrencyAmount pv = this.presentValueFromCleanPrice(trade, ratesProvider, discountingProvider, refData, cleanRealPrice);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pv});
    }

    public MultiCurrencyAmount currencyExposure(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        CurrencyAmount pv = this.presentValue(trade, ratesProvider, discountingProvider);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pv});
    }

    public MultiCurrencyAmount currencyExposureFromCleanPriceWithZSpread(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, ReferenceData refData, double cleanRealPrice, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        CurrencyAmount pv = this.presentValueFromCleanPriceWithZSpread(trade, ratesProvider, discountingProvider, refData, cleanRealPrice, zSpread, compoundedRateType, periodsPerYear);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pv});
    }

    public MultiCurrencyAmount currencyExposureWithZSpread(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, double zSpread, CompoundedRateType compoundedRateType, int periodsPerYear) {
        CurrencyAmount pv = this.presentValueWithZSpread(trade, ratesProvider, discountingProvider, zSpread, compoundedRateType, periodsPerYear);
        return MultiCurrencyAmount.of((CurrencyAmount[])new CurrencyAmount[]{pv});
    }

    public CurrencyAmount currentCash(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider) {
        LocalDate valuationDate = ratesProvider.getValuationDate();
        LocalDate settlementDate = this.settlementDate(trade, valuationDate);
        CurrencyAmount cashProduct = this.productPricer.currentCash(trade.getProduct(), ratesProvider, settlementDate);
        if (!trade.getSettlement().isPresent()) {
            return cashProduct;
        }
        BondPaymentPeriod settlePeriod = ((ResolvedCapitalIndexedBondSettlement)trade.getSettlement().get()).getPayment();
        double cashSettle = settlePeriod.getPaymentDate().isEqual(valuationDate) ? this.netAmount(trade, ratesProvider).getAmount() : 0.0;
        return cashProduct.plus(cashSettle);
    }

    public CurrencyAmount netAmount(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider) {
        if (!trade.getSettlement().isPresent()) {
            return CurrencyAmount.zero((Currency)trade.getProduct().getCurrency());
        }
        BondPaymentPeriod settlePeriod = ((ResolvedCapitalIndexedBondSettlement)trade.getSettlement().get()).getPayment();
        if (settlePeriod instanceof KnownAmountBondPaymentPeriod) {
            Payment payment = ((KnownAmountBondPaymentPeriod)settlePeriod).getPayment();
            return payment.getValue();
        }
        if (settlePeriod instanceof CapitalIndexedBondPaymentPeriod) {
            CapitalIndexedBondPaymentPeriod casted = (CapitalIndexedBondPaymentPeriod)settlePeriod;
            double netAmount = this.productPricer.getPeriodPricer().forecastValue(casted, ratesProvider);
            return CurrencyAmount.of((Currency)casted.getCurrency(), (double)netAmount);
        }
        throw new UnsupportedOperationException("unsupported settlement type");
    }

    private CurrencyAmount presentValueSettlement(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        if (!trade.getSettlement().isPresent()) {
            return CurrencyAmount.zero((Currency)trade.getProduct().getCurrency());
        }
        BondPaymentPeriod settlePeriod = ((ResolvedCapitalIndexedBondSettlement)trade.getSettlement().get()).getPayment();
        ResolvedCapitalIndexedBond product = trade.getProduct();
        CurrencyAmount netAmount = this.netAmount(trade, ratesProvider);
        RepoCurveDiscountFactors repoDf = DiscountingCapitalIndexedBondProductPricer.repoCurveDf(product, discountingProvider);
        return netAmount.multipliedBy(repoDf.discountFactor(settlePeriod.getPaymentDate()));
    }

    private CurrencyAmount presentValueFromProductPresentValue(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, CurrencyAmount productPresentValue) {
        CurrencyAmount pvProduct = productPresentValue.multipliedBy(trade.getQuantity());
        CurrencyAmount pvPayment = this.presentValueSettlement(trade, ratesProvider, discountingProvider);
        return pvProduct.plus(pvPayment);
    }

    CurrencyAmount forecastValueStandardFromCleanPrice(ResolvedCapitalIndexedBond product, RatesProvider ratesProvider, LocalDate standardSettlementDate, double realCleanPrice) {
        double notional = product.getNotional();
        double netAmountReal = realCleanPrice * notional + product.accruedInterest(standardSettlementDate);
        double indexRatio = product.getYieldConvention().equals((Object)CapitalIndexedBondYieldConvention.GB_IL_FLOAT) ? 1.0 : this.productPricer.indexRatio(product, ratesProvider, standardSettlementDate);
        return CurrencyAmount.of((Currency)product.getCurrency(), (double)(indexRatio * netAmountReal));
    }

    private PointSensitivityBuilder presentValueSensitivityFromProductPresentValueSensitivity(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider, PointSensitivityBuilder productPresnetValueSensitivity) {
        PointSensitivityBuilder sensiProduct = productPresnetValueSensitivity.multipliedBy(trade.getQuantity());
        PointSensitivityBuilder sensiPayment = this.presentValueSensitivitySettlement(trade, ratesProvider, discountingProvider);
        return sensiProduct.combinedWith(sensiPayment);
    }

    private PointSensitivityBuilder presentValueSensitivitySettlement(ResolvedCapitalIndexedBondTrade trade, RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        if (!trade.getSettlement().isPresent()) {
            return PointSensitivityBuilder.none();
        }
        ResolvedCapitalIndexedBondSettlement settlement = (ResolvedCapitalIndexedBondSettlement)trade.getSettlement().get();
        BondPaymentPeriod settlePeriod = settlement.getPayment();
        ResolvedCapitalIndexedBond product = trade.getProduct();
        RepoCurveDiscountFactors repoDf = DiscountingCapitalIndexedBondProductPricer.repoCurveDf(product, discountingProvider);
        double df = repoDf.discountFactor(settlePeriod.getPaymentDate());
        double netAmount = this.netAmount(trade, ratesProvider).getAmount();
        RepoCurveZeroRateSensitivity dfSensi = repoDf.zeroRatePointSensitivity(settlePeriod.getPaymentDate()).multipliedBy(netAmount);
        PointSensitivityBuilder naSensi = this.netAmountSensitivity(settlement, ratesProvider).multipliedBy(df);
        return dfSensi.combinedWith(naSensi);
    }

    private PointSensitivityBuilder netAmountSensitivity(ResolvedCapitalIndexedBondSettlement settlement, RatesProvider ratesProvider) {
        BondPaymentPeriod settlePeriod = settlement.getPayment();
        if (settlePeriod instanceof KnownAmountBondPaymentPeriod) {
            return PointSensitivityBuilder.none();
        }
        if (settlePeriod instanceof CapitalIndexedBondPaymentPeriod) {
            CapitalIndexedBondPaymentPeriod casted = (CapitalIndexedBondPaymentPeriod)settlePeriod;
            return this.productPricer.getPeriodPricer().forecastValueSensitivity(casted, ratesProvider);
        }
        throw new UnsupportedOperationException("unsupported settlement type");
    }

    PointSensitivityBuilder forecastValueSensitivityStandardFromCleanPrice(ResolvedCapitalIndexedBond product, RatesProvider ratesProvider, LocalDate standardSettlementDate, double realCleanPrice) {
        if (product.getYieldConvention().equals((Object)CapitalIndexedBondYieldConvention.GB_IL_FLOAT)) {
            return PointSensitivityBuilder.none();
        }
        double notional = product.getNotional();
        double netAmountReal = realCleanPrice * notional + product.accruedInterest(standardSettlementDate);
        PointSensitivityBuilder indexRatioSensi = this.productPricer.indexRatioSensitivity(product, ratesProvider, standardSettlementDate);
        return indexRatioSensi.multipliedBy(netAmountReal);
    }

    private LocalDate settlementDate(ResolvedCapitalIndexedBondTrade trade, LocalDate valuationDate) {
        return trade.getSettlement().map(settle -> settle.getSettlementDate()).orElse(valuationDate);
    }

    private void validate(RatesProvider ratesProvider, LegalEntityDiscountingProvider discountingProvider) {
        ArgChecker.isTrue((boolean)ratesProvider.getValuationDate().isEqual(discountingProvider.getValuationDate()), (String)"the rates providers should be for the same date");
    }
}

