/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.bond;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.market.curve.LegalEntityGroup;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class IssuerCurveZeroRateSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Currency curveCurrency;
    @PropertyDefinition
    private final double yearFraction;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(validate="notNull")
    private final LegalEntityGroup legalEntityGroup;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static IssuerCurveZeroRateSensitivity of(Currency currency, double yearFraction, LegalEntityGroup legalEntityGroup, double sensitivity) {
        return IssuerCurveZeroRateSensitivity.of(currency, yearFraction, currency, legalEntityGroup, sensitivity);
    }

    public static IssuerCurveZeroRateSensitivity of(ZeroRateSensitivity zeroRateSensitivity, LegalEntityGroup legalEntityGroup) {
        return IssuerCurveZeroRateSensitivity.of(zeroRateSensitivity.getCurveCurrency(), zeroRateSensitivity.getYearFraction(), zeroRateSensitivity.getCurrency(), legalEntityGroup, zeroRateSensitivity.getSensitivity());
    }

    public static IssuerCurveZeroRateSensitivity of(Currency curveCurrency, double yearFraction, Currency sensitivityCurrency, LegalEntityGroup legalEntityGroup, double sensitivity) {
        return new IssuerCurveZeroRateSensitivity(curveCurrency, yearFraction, sensitivityCurrency, legalEntityGroup, sensitivity);
    }

    public IssuerCurveZeroRateSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new IssuerCurveZeroRateSensitivity(this.curveCurrency, this.yearFraction, currency, this.legalEntityGroup, this.sensitivity);
    }

    public IssuerCurveZeroRateSensitivity withSensitivity(double sensitivity) {
        return new IssuerCurveZeroRateSensitivity(this.curveCurrency, this.yearFraction, this.currency, this.legalEntityGroup, sensitivity);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof IssuerCurveZeroRateSensitivity) {
            IssuerCurveZeroRateSensitivity otherZero = (IssuerCurveZeroRateSensitivity)other;
            return ComparisonChain.start().compare((Comparable)this.curveCurrency, (Comparable)otherZero.curveCurrency).compare((Comparable)this.currency, (Comparable)otherZero.currency).compare(this.yearFraction, otherZero.yearFraction).compare((Comparable)this.legalEntityGroup, (Comparable)otherZero.legalEntityGroup).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public IssuerCurveZeroRateSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (IssuerCurveZeroRateSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public IssuerCurveZeroRateSensitivity multipliedBy(double factor) {
        return new IssuerCurveZeroRateSensitivity(this.curveCurrency, this.yearFraction, this.currency, this.legalEntityGroup, this.sensitivity * factor);
    }

    public IssuerCurveZeroRateSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new IssuerCurveZeroRateSensitivity(this.curveCurrency, this.yearFraction, this.currency, this.legalEntityGroup, operator.applyAsDouble(this.sensitivity));
    }

    public IssuerCurveZeroRateSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public IssuerCurveZeroRateSensitivity cloned() {
        return this;
    }

    public ZeroRateSensitivity createZeroRateSensitivity() {
        return ZeroRateSensitivity.of(this.curveCurrency, this.yearFraction, this.currency, this.sensitivity);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private IssuerCurveZeroRateSensitivity(Currency curveCurrency, double yearFraction, Currency currency, LegalEntityGroup legalEntityGroup, double sensitivity) {
        JodaBeanUtils.notNull((Object)curveCurrency, (String)"curveCurrency");
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)legalEntityGroup, (String)"legalEntityGroup");
        this.curveCurrency = curveCurrency;
        this.yearFraction = yearFraction;
        this.currency = currency;
        this.legalEntityGroup = legalEntityGroup;
        this.sensitivity = sensitivity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Currency getCurveCurrency() {
        return this.curveCurrency;
    }

    public double getYearFraction() {
        return this.yearFraction;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public LegalEntityGroup getLegalEntityGroup() {
        return this.legalEntityGroup;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IssuerCurveZeroRateSensitivity other = (IssuerCurveZeroRateSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.curveCurrency, (Object)other.curveCurrency) && JodaBeanUtils.equal((double)this.yearFraction, (double)other.yearFraction) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.legalEntityGroup, (Object)other.legalEntityGroup) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curveCurrency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.yearFraction);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.legalEntityGroup);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("IssuerCurveZeroRateSensitivity{");
        buf.append("curveCurrency").append('=').append(JodaBeanUtils.toString((Object)this.curveCurrency)).append(',').append(' ');
        buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("legalEntityGroup").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityGroup)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<IssuerCurveZeroRateSensitivity> {
        private Currency curveCurrency;
        private double yearFraction;
        private Currency currency;
        private LegalEntityGroup legalEntityGroup;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1303639584: {
                    return this.curveCurrency;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case 575402001: {
                    return this.currency;
                }
                case -899047453: {
                    return this.legalEntityGroup;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 1303639584: {
                    this.curveCurrency = (Currency)newValue;
                    break;
                }
                case -1731780257: {
                    this.yearFraction = (Double)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case -899047453: {
                    this.legalEntityGroup = (LegalEntityGroup)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public IssuerCurveZeroRateSensitivity build() {
            return new IssuerCurveZeroRateSensitivity(this.curveCurrency, this.yearFraction, this.currency, this.legalEntityGroup, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("IssuerCurveZeroRateSensitivity.Builder{");
            buf.append("curveCurrency").append('=').append(JodaBeanUtils.toString((Object)this.curveCurrency)).append(',').append(' ');
            buf.append("yearFraction").append('=').append(JodaBeanUtils.toString((Object)this.yearFraction)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("legalEntityGroup").append('=').append(JodaBeanUtils.toString((Object)this.legalEntityGroup)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> curveCurrency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curveCurrency", IssuerCurveZeroRateSensitivity.class, Currency.class);
        private final MetaProperty<Double> yearFraction = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"yearFraction", IssuerCurveZeroRateSensitivity.class, Double.TYPE);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", IssuerCurveZeroRateSensitivity.class, Currency.class);
        private final MetaProperty<LegalEntityGroup> legalEntityGroup = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"legalEntityGroup", IssuerCurveZeroRateSensitivity.class, LegalEntityGroup.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", IssuerCurveZeroRateSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"curveCurrency", "yearFraction", "currency", "legalEntityGroup", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 1303639584: {
                    return this.curveCurrency;
                }
                case -1731780257: {
                    return this.yearFraction;
                }
                case 575402001: {
                    return this.currency;
                }
                case -899047453: {
                    return this.legalEntityGroup;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends IssuerCurveZeroRateSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends IssuerCurveZeroRateSensitivity> beanType() {
            return IssuerCurveZeroRateSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> curveCurrency() {
            return this.curveCurrency;
        }

        public MetaProperty<Double> yearFraction() {
            return this.yearFraction;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<LegalEntityGroup> legalEntityGroup() {
            return this.legalEntityGroup;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 1303639584: {
                    return ((IssuerCurveZeroRateSensitivity)bean).getCurveCurrency();
                }
                case -1731780257: {
                    return ((IssuerCurveZeroRateSensitivity)bean).getYearFraction();
                }
                case 575402001: {
                    return ((IssuerCurveZeroRateSensitivity)bean).getCurrency();
                }
                case -899047453: {
                    return ((IssuerCurveZeroRateSensitivity)bean).getLegalEntityGroup();
                }
                case 564403871: {
                    return ((IssuerCurveZeroRateSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

