/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.pricer.capfloor.BlackIborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletSensitivity;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import com.opengamma.strata.pricer.impl.option.BlackFormulaRepository;
import com.opengamma.strata.product.common.PutCall;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class BlackIborCapletFloorletExpiryFlatVolatilities
implements BlackIborCapletFloorletVolatilities,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final ZonedDateTime valuationDateTime;
    @PropertyDefinition(validate="notNull")
    private final Curve curve;
    private final transient DayCount dayCount;
    private static final long serialVersionUID = 1L;

    public static BlackIborCapletFloorletExpiryFlatVolatilities of(IborIndex index, ZonedDateTime valuationDateTime, Curve curve) {
        return new BlackIborCapletFloorletExpiryFlatVolatilities(index, valuationDateTime, curve);
    }

    @ImmutableConstructor
    private BlackIborCapletFloorletExpiryFlatVolatilities(IborIndex index, ZonedDateTime valuationDateTime, Curve curve) {
        ArgChecker.notNull((Object)index, (String)"index");
        ArgChecker.notNull((Object)valuationDateTime, (String)"valuationDateTime");
        ArgChecker.notNull((Object)curve, (String)"curve");
        curve.getMetadata().getXValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect x-value type for year fractions");
        curve.getMetadata().getYValueType().checkEquals(ValueType.BLACK_VOLATILITY, "Incorrect y-value type for Black volatilities");
        DayCount dayCount = (DayCount)curve.getMetadata().findInfo(CurveInfoType.DAY_COUNT).orElseThrow(() -> new IllegalArgumentException("Incorrect curve metadata, missing DayCount"));
        this.index = index;
        this.valuationDateTime = valuationDateTime;
        this.curve = curve;
        this.dayCount = dayCount;
    }

    private Object readResolve() {
        return new BlackIborCapletFloorletExpiryFlatVolatilities(this.index, this.valuationDateTime, this.curve);
    }

    @Override
    public IborCapletFloorletVolatilitiesName getName() {
        return IborCapletFloorletVolatilitiesName.of(this.curve.getName().getName());
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.curve.getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.curve));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.curve.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.curve.getParameter(parameterIndex);
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.curve.getParameterMetadata(parameterIndex);
    }

    public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.curve.findParameterIndex(metadata);
    }

    @Override
    public BlackIborCapletFloorletExpiryFlatVolatilities withParameter(int parameterIndex, double newValue) {
        return new BlackIborCapletFloorletExpiryFlatVolatilities(this.index, this.valuationDateTime, this.curve.withParameter(parameterIndex, newValue));
    }

    @Override
    public BlackIborCapletFloorletExpiryFlatVolatilities withPerturbation(ParameterPerturbation perturbation) {
        return new BlackIborCapletFloorletExpiryFlatVolatilities(this.index, this.valuationDateTime, this.curve.withPerturbation(perturbation));
    }

    @Override
    public double volatility(double expiry, double strike, double forward) {
        return this.curve.yValue(expiry);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities pointSensitivities) {
        CurrencyParameterSensitivities sens = CurrencyParameterSensitivities.empty();
        for (PointSensitivity point : pointSensitivities.getSensitivities()) {
            IborCapletFloorletSensitivity pt;
            if (!(point instanceof IborCapletFloorletSensitivity) || !(pt = (IborCapletFloorletSensitivity)point).getVolatilitiesName().equals(this.getName())) continue;
            sens = sens.combinedWith(this.parameterSensitivity(pt));
        }
        return sens;
    }

    private CurrencyParameterSensitivity parameterSensitivity(IborCapletFloorletSensitivity point) {
        double expiry = point.getExpiry();
        UnitParameterSensitivity unitSens = this.curve.yValueParameterSensitivity(expiry);
        return unitSens.multipliedBy(point.getCurrency(), point.getSensitivity());
    }

    @Override
    public double price(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return BlackFormulaRepository.price(forward, strike, expiry, volatility, putCall.isCall());
    }

    @Override
    public double priceDelta(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return BlackFormulaRepository.delta(forward, strike, expiry, volatility, putCall.isCall());
    }

    @Override
    public double priceGamma(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return BlackFormulaRepository.gamma(forward, strike, expiry, volatility);
    }

    @Override
    public double priceTheta(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return BlackFormulaRepository.driftlessTheta(forward, strike, expiry, volatility);
    }

    @Override
    public double priceVega(double expiry, PutCall putCall, double strike, double forward, double volatility) {
        return BlackFormulaRepository.vega(forward, strike, expiry, volatility);
    }

    @Override
    public double relativeTime(ZonedDateTime dateTime) {
        ArgChecker.notNull((Object)dateTime, (String)"dateTime");
        LocalDate valuationDate = this.valuationDateTime.toLocalDate();
        LocalDate date = dateTime.toLocalDate();
        return this.dayCount.relativeYearFraction(valuationDate, date);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    @Override
    public ZonedDateTime getValuationDateTime() {
        return this.valuationDateTime;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            BlackIborCapletFloorletExpiryFlatVolatilities other = (BlackIborCapletFloorletExpiryFlatVolatilities)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.valuationDateTime, (Object)other.valuationDateTime) && JodaBeanUtils.equal((Object)this.curve, (Object)other.curve);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDateTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curve);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("BlackIborCapletFloorletExpiryFlatVolatilities{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
        buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<BlackIborCapletFloorletExpiryFlatVolatilities> {
        private IborIndex index;
        private ZonedDateTime valuationDateTime;
        private Curve curve;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case 95027439: {
                    return this.curve;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case -949589828: {
                    this.valuationDateTime = (ZonedDateTime)newValue;
                    break;
                }
                case 95027439: {
                    this.curve = (Curve)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public BlackIborCapletFloorletExpiryFlatVolatilities build() {
            return new BlackIborCapletFloorletExpiryFlatVolatilities(this.index, this.valuationDateTime, this.curve);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("BlackIborCapletFloorletExpiryFlatVolatilities.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("valuationDateTime").append('=').append(JodaBeanUtils.toString((Object)this.valuationDateTime)).append(',').append(' ');
            buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", BlackIborCapletFloorletExpiryFlatVolatilities.class, IborIndex.class);
        private final MetaProperty<ZonedDateTime> valuationDateTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDateTime", BlackIborCapletFloorletExpiryFlatVolatilities.class, ZonedDateTime.class);
        private final MetaProperty<Curve> curve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curve", BlackIborCapletFloorletExpiryFlatVolatilities.class, Curve.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "valuationDateTime", "curve"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case -949589828: {
                    return this.valuationDateTime;
                }
                case 95027439: {
                    return this.curve;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends BlackIborCapletFloorletExpiryFlatVolatilities> builder() {
            return new Builder();
        }

        public Class<? extends BlackIborCapletFloorletExpiryFlatVolatilities> beanType() {
            return BlackIborCapletFloorletExpiryFlatVolatilities.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<ZonedDateTime> valuationDateTime() {
            return this.valuationDateTime;
        }

        public MetaProperty<Curve> curve() {
            return this.curve;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((BlackIborCapletFloorletExpiryFlatVolatilities)bean).getIndex();
                }
                case -949589828: {
                    return ((BlackIborCapletFloorletExpiryFlatVolatilities)bean).getValuationDateTime();
                }
                case 95027439: {
                    return ((BlackIborCapletFloorletExpiryFlatVolatilities)bean).getCurve();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

