/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.Curves;
import com.opengamma.strata.market.curve.DefaultCurveMetadata;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.math.impl.interpolation.PenaltyMatrixGenerator;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilityDefinition;
import com.opengamma.strata.pricer.option.RawOptionData;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class DirectIborCapletFloorletFlatVolatilityDefinition
implements IborCapletFloorletVolatilityDefinition,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborCapletFloorletVolatilitiesName name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount dayCount;
    @PropertyDefinition(validate="ArgChecker.notNegative")
    private final double lambda;
    @PropertyDefinition(validate="notNull")
    private final CurveInterpolator interpolator;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator extrapolatorLeft;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator extrapolatorRight;
    private static final long serialVersionUID = 1L;

    public static DirectIborCapletFloorletFlatVolatilityDefinition of(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double lambda, CurveInterpolator interpolator) {
        return DirectIborCapletFloorletFlatVolatilityDefinition.of(name, index, dayCount, lambda, interpolator, CurveExtrapolators.FLAT, CurveExtrapolators.FLAT);
    }

    public static DirectIborCapletFloorletFlatVolatilityDefinition of(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double lambda, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight) {
        return new DirectIborCapletFloorletFlatVolatilityDefinition(name, index, dayCount, lambda, interpolator, extrapolatorLeft, extrapolatorRight);
    }

    @Override
    public SurfaceMetadata createMetadata(RawOptionData capFloorData) {
        throw new IllegalArgumentException("Surface metadata is not defined for this definition. Use createCurveMetadata.");
    }

    public CurveMetadata createCurveMetadata(RawOptionData capFloorData) {
        CurveMetadata metadata;
        if (capFloorData.getDataType().equals((Object)ValueType.BLACK_VOLATILITY)) {
            metadata = Curves.blackVolatilityByExpiry((String)this.name.getName(), (DayCount)this.dayCount);
        } else if (capFloorData.getDataType().equals((Object)ValueType.NORMAL_VOLATILITY)) {
            metadata = DefaultCurveMetadata.builder().curveName(this.name.getName()).xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.NORMAL_VOLATILITY).dayCount(this.dayCount).build();
        } else {
            throw new IllegalArgumentException("Data type not supported");
        }
        return metadata;
    }

    public DoubleMatrix computePenaltyMatrix(DoubleArray expiries) {
        ArgChecker.isTrue((expiries.size() > 2 ? 1 : 0) != 0, (String)"Need at least 3 points for a curvature estimate");
        DoubleMatrix penalty = PenaltyMatrixGenerator.getPenaltyMatrix((double[])expiries.toArray(), (int)2);
        return penalty.multipliedBy(this.lambda);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private DirectIborCapletFloorletFlatVolatilityDefinition(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double lambda, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        ArgChecker.notNegative((double)lambda, (String)"lambda");
        JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
        JodaBeanUtils.notNull((Object)extrapolatorLeft, (String)"extrapolatorLeft");
        JodaBeanUtils.notNull((Object)extrapolatorRight, (String)"extrapolatorRight");
        this.name = name;
        this.index = index;
        this.dayCount = dayCount;
        this.lambda = lambda;
        this.interpolator = interpolator;
        this.extrapolatorLeft = extrapolatorLeft;
        this.extrapolatorRight = extrapolatorRight;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborCapletFloorletVolatilitiesName getName() {
        return this.name;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount;
    }

    public double getLambda() {
        return this.lambda;
    }

    public CurveInterpolator getInterpolator() {
        return this.interpolator;
    }

    public CurveExtrapolator getExtrapolatorLeft() {
        return this.extrapolatorLeft;
    }

    public CurveExtrapolator getExtrapolatorRight() {
        return this.extrapolatorRight;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            DirectIborCapletFloorletFlatVolatilityDefinition other = (DirectIborCapletFloorletFlatVolatilityDefinition)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((double)this.lambda, (double)other.lambda) && JodaBeanUtils.equal((Object)this.interpolator, (Object)other.interpolator) && JodaBeanUtils.equal((Object)this.extrapolatorLeft, (Object)other.extrapolatorLeft) && JodaBeanUtils.equal((Object)this.extrapolatorRight, (Object)other.extrapolatorRight);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.lambda);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.interpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.extrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.extrapolatorRight);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("DirectIborCapletFloorletFlatVolatilityDefinition{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("lambda").append('=').append(JodaBeanUtils.toString((Object)this.lambda)).append(',').append(' ');
        buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
        buf.append("extrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorLeft)).append(',').append(' ');
        buf.append("extrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorRight));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<DirectIborCapletFloorletFlatVolatilityDefinition> {
        private IborCapletFloorletVolatilitiesName name;
        private IborIndex index;
        private DayCount dayCount;
        private double lambda;
        private CurveInterpolator interpolator;
        private CurveExtrapolator extrapolatorLeft;
        private CurveExtrapolator extrapolatorRight;

        private Builder() {
        }

        private Builder(DirectIborCapletFloorletFlatVolatilityDefinition beanToCopy) {
            this.name = beanToCopy.getName();
            this.index = beanToCopy.getIndex();
            this.dayCount = beanToCopy.getDayCount();
            this.lambda = beanToCopy.getLambda();
            this.interpolator = beanToCopy.getInterpolator();
            this.extrapolatorLeft = beanToCopy.getExtrapolatorLeft();
            this.extrapolatorRight = beanToCopy.getExtrapolatorRight();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1110092857: {
                    return this.lambda;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1271703994: {
                    return this.extrapolatorLeft;
                }
                case 773779145: {
                    return this.extrapolatorRight;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (IborCapletFloorletVolatilitiesName)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case -1110092857: {
                    this.lambda = (Double)newValue;
                    break;
                }
                case 2096253127: {
                    this.interpolator = (CurveInterpolator)newValue;
                    break;
                }
                case 1271703994: {
                    this.extrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case 773779145: {
                    this.extrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public DirectIborCapletFloorletFlatVolatilityDefinition build() {
            return new DirectIborCapletFloorletFlatVolatilityDefinition(this.name, this.index, this.dayCount, this.lambda, this.interpolator, this.extrapolatorLeft, this.extrapolatorRight);
        }

        public Builder name(IborCapletFloorletVolatilitiesName name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder lambda(double lambda) {
            ArgChecker.notNegative((double)lambda, (String)"lambda");
            this.lambda = lambda;
            return this;
        }

        public Builder interpolator(CurveInterpolator interpolator) {
            JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
            this.interpolator = interpolator;
            return this;
        }

        public Builder extrapolatorLeft(CurveExtrapolator extrapolatorLeft) {
            JodaBeanUtils.notNull((Object)extrapolatorLeft, (String)"extrapolatorLeft");
            this.extrapolatorLeft = extrapolatorLeft;
            return this;
        }

        public Builder extrapolatorRight(CurveExtrapolator extrapolatorRight) {
            JodaBeanUtils.notNull((Object)extrapolatorRight, (String)"extrapolatorRight");
            this.extrapolatorRight = extrapolatorRight;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("DirectIborCapletFloorletFlatVolatilityDefinition.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("lambda").append('=').append(JodaBeanUtils.toString((Object)this.lambda)).append(',').append(' ');
            buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
            buf.append("extrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorLeft)).append(',').append(' ');
            buf.append("extrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorRight));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborCapletFloorletVolatilitiesName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", DirectIborCapletFloorletFlatVolatilityDefinition.class, IborCapletFloorletVolatilitiesName.class);
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", DirectIborCapletFloorletFlatVolatilityDefinition.class, IborIndex.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", DirectIborCapletFloorletFlatVolatilityDefinition.class, DayCount.class);
        private final MetaProperty<Double> lambda = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lambda", DirectIborCapletFloorletFlatVolatilityDefinition.class, Double.TYPE);
        private final MetaProperty<CurveInterpolator> interpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"interpolator", DirectIborCapletFloorletFlatVolatilityDefinition.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> extrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"extrapolatorLeft", DirectIborCapletFloorletFlatVolatilityDefinition.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> extrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"extrapolatorRight", DirectIborCapletFloorletFlatVolatilityDefinition.class, CurveExtrapolator.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "index", "dayCount", "lambda", "interpolator", "extrapolatorLeft", "extrapolatorRight"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case -1110092857: {
                    return this.lambda;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1271703994: {
                    return this.extrapolatorLeft;
                }
                case 773779145: {
                    return this.extrapolatorRight;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends DirectIborCapletFloorletFlatVolatilityDefinition> beanType() {
            return DirectIborCapletFloorletFlatVolatilityDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborCapletFloorletVolatilitiesName> name() {
            return this.name;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<Double> lambda() {
            return this.lambda;
        }

        public MetaProperty<CurveInterpolator> interpolator() {
            return this.interpolator;
        }

        public MetaProperty<CurveExtrapolator> extrapolatorLeft() {
            return this.extrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> extrapolatorRight() {
            return this.extrapolatorRight;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((DirectIborCapletFloorletFlatVolatilityDefinition)bean).getName();
                }
                case 100346066: {
                    return ((DirectIborCapletFloorletFlatVolatilityDefinition)bean).getIndex();
                }
                case 1905311443: {
                    return ((DirectIborCapletFloorletFlatVolatilityDefinition)bean).getDayCount();
                }
                case -1110092857: {
                    return ((DirectIborCapletFloorletFlatVolatilityDefinition)bean).getLambda();
                }
                case 2096253127: {
                    return ((DirectIborCapletFloorletFlatVolatilityDefinition)bean).getInterpolator();
                }
                case 1271703994: {
                    return ((DirectIborCapletFloorletFlatVolatilityDefinition)bean).getExtrapolatorLeft();
                }
                case 773779145: {
                    return ((DirectIborCapletFloorletFlatVolatilityDefinition)bean).getExtrapolatorRight();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

