/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.google.common.collect.ComparisonChain;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.market.model.SabrParameterType;
import com.opengamma.strata.market.sensitivity.MutablePointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleUnaryOperator;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class IborCapletFloorletSabrSensitivity
implements PointSensitivity,
PointSensitivityBuilder,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final IborCapletFloorletVolatilitiesName volatilitiesName;
    @PropertyDefinition(validate="notNull")
    private final double expiry;
    @PropertyDefinition
    private final SabrParameterType sensitivityType;
    @PropertyDefinition(overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(overrideGet=true)
    private final double sensitivity;
    private static final long serialVersionUID = 1L;

    public static IborCapletFloorletSabrSensitivity of(IborCapletFloorletVolatilitiesName volatilitiesName, double expiry, SabrParameterType sensitivityType, Currency sensitivityCurrency, double sensitivity) {
        return new IborCapletFloorletSabrSensitivity(volatilitiesName, expiry, sensitivityType, sensitivityCurrency, sensitivity);
    }

    public IborCapletFloorletSabrSensitivity withCurrency(Currency currency) {
        if (this.currency.equals((Object)currency)) {
            return this;
        }
        return new IborCapletFloorletSabrSensitivity(this.volatilitiesName, this.expiry, this.sensitivityType, currency, this.sensitivity);
    }

    public IborCapletFloorletSabrSensitivity withSensitivity(double sensitivity) {
        return new IborCapletFloorletSabrSensitivity(this.volatilitiesName, this.expiry, this.sensitivityType, this.currency, sensitivity);
    }

    public int compareKey(PointSensitivity other) {
        if (other instanceof IborCapletFloorletSabrSensitivity) {
            IborCapletFloorletSabrSensitivity otherSwpt = (IborCapletFloorletSabrSensitivity)other;
            return ComparisonChain.start().compare((Comparable)((Object)this.volatilitiesName), (Comparable)((Object)otherSwpt.volatilitiesName)).compare((Comparable)this.currency, (Comparable)otherSwpt.currency).compare(this.expiry, otherSwpt.expiry).compare((Comparable)this.sensitivityType, (Comparable)otherSwpt.sensitivityType).result();
        }
        return this.getClass().getSimpleName().compareTo(other.getClass().getSimpleName());
    }

    public IborCapletFloorletSabrSensitivity convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        return (IborCapletFloorletSabrSensitivity)super.convertedTo(resultCurrency, rateProvider);
    }

    public IborCapletFloorletSabrSensitivity multipliedBy(double factor) {
        return new IborCapletFloorletSabrSensitivity(this.volatilitiesName, this.expiry, this.sensitivityType, this.currency, this.sensitivity * factor);
    }

    public IborCapletFloorletSabrSensitivity mapSensitivity(DoubleUnaryOperator operator) {
        return new IborCapletFloorletSabrSensitivity(this.volatilitiesName, this.expiry, this.sensitivityType, this.currency, operator.applyAsDouble(this.sensitivity));
    }

    public IborCapletFloorletSabrSensitivity normalize() {
        return this;
    }

    public MutablePointSensitivities buildInto(MutablePointSensitivities combination) {
        return combination.add((PointSensitivity)this);
    }

    public IborCapletFloorletSabrSensitivity cloned() {
        return this;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private IborCapletFloorletSabrSensitivity(IborCapletFloorletVolatilitiesName volatilitiesName, double expiry, SabrParameterType sensitivityType, Currency currency, double sensitivity) {
        JodaBeanUtils.notNull((Object)volatilitiesName, (String)"volatilitiesName");
        JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
        this.volatilitiesName = volatilitiesName;
        this.expiry = expiry;
        this.sensitivityType = sensitivityType;
        this.currency = currency;
        this.sensitivity = sensitivity;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public IborCapletFloorletVolatilitiesName getVolatilitiesName() {
        return this.volatilitiesName;
    }

    public double getExpiry() {
        return this.expiry;
    }

    public SabrParameterType getSensitivityType() {
        return this.sensitivityType;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborCapletFloorletSabrSensitivity other = (IborCapletFloorletSabrSensitivity)obj;
            return JodaBeanUtils.equal((Object)this.volatilitiesName, (Object)other.volatilitiesName) && JodaBeanUtils.equal((double)this.expiry, (double)other.expiry) && JodaBeanUtils.equal((Object)this.sensitivityType, (Object)other.sensitivityType) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((double)this.sensitivity, (double)other.sensitivity);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.volatilitiesName);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.sensitivityType);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((double)this.sensitivity);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("IborCapletFloorletSabrSensitivity{");
        buf.append("volatilitiesName").append('=').append(JodaBeanUtils.toString((Object)this.volatilitiesName)).append(',').append(' ');
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("sensitivityType").append('=').append(JodaBeanUtils.toString((Object)this.sensitivityType)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<IborCapletFloorletSabrSensitivity> {
        private IborCapletFloorletVolatilitiesName volatilitiesName;
        private double expiry;
        private SabrParameterType sensitivityType;
        private Currency currency;
        private double sensitivity;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return this.volatilitiesName;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case 1598929529: {
                    return this.sensitivityType;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    this.volatilitiesName = (IborCapletFloorletVolatilitiesName)newValue;
                    break;
                }
                case -1289159373: {
                    this.expiry = (Double)newValue;
                    break;
                }
                case 1598929529: {
                    this.sensitivityType = (SabrParameterType)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 564403871: {
                    this.sensitivity = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public IborCapletFloorletSabrSensitivity build() {
            return new IborCapletFloorletSabrSensitivity(this.volatilitiesName, this.expiry, this.sensitivityType, this.currency, this.sensitivity);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("IborCapletFloorletSabrSensitivity.Builder{");
            buf.append("volatilitiesName").append('=').append(JodaBeanUtils.toString((Object)this.volatilitiesName)).append(',').append(' ');
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("sensitivityType").append('=').append(JodaBeanUtils.toString((Object)this.sensitivityType)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("sensitivity").append('=').append(JodaBeanUtils.toString((Object)this.sensitivity));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborCapletFloorletVolatilitiesName> volatilitiesName = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"volatilitiesName", IborCapletFloorletSabrSensitivity.class, IborCapletFloorletVolatilitiesName.class);
        private final MetaProperty<Double> expiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiry", IborCapletFloorletSabrSensitivity.class, Double.TYPE);
        private final MetaProperty<SabrParameterType> sensitivityType = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivityType", IborCapletFloorletSabrSensitivity.class, SabrParameterType.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", IborCapletFloorletSabrSensitivity.class, Currency.class);
        private final MetaProperty<Double> sensitivity = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sensitivity", IborCapletFloorletSabrSensitivity.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"volatilitiesName", "expiry", "sensitivityType", "currency", "sensitivity"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return this.volatilitiesName;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case 1598929529: {
                    return this.sensitivityType;
                }
                case 575402001: {
                    return this.currency;
                }
                case 564403871: {
                    return this.sensitivity;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends IborCapletFloorletSabrSensitivity> builder() {
            return new Builder();
        }

        public Class<? extends IborCapletFloorletSabrSensitivity> beanType() {
            return IborCapletFloorletSabrSensitivity.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborCapletFloorletVolatilitiesName> volatilitiesName() {
            return this.volatilitiesName;
        }

        public MetaProperty<Double> expiry() {
            return this.expiry;
        }

        public MetaProperty<SabrParameterType> sensitivityType() {
            return this.sensitivityType;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<Double> sensitivity() {
            return this.sensitivity;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 2100884654: {
                    return ((IborCapletFloorletSabrSensitivity)bean).getVolatilitiesName();
                }
                case -1289159373: {
                    return ((IborCapletFloorletSabrSensitivity)bean).getExpiry();
                }
                case 1598929529: {
                    return ((IborCapletFloorletSabrSensitivity)bean).getSensitivityType();
                }
                case 575402001: {
                    return ((IborCapletFloorletSabrSensitivity)bean).getCurrency();
                }
                case 564403871: {
                    return ((IborCapletFloorletSabrSensitivity)bean).getSensitivity();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

