/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.surface.ConstantSurface;
import com.opengamma.strata.market.surface.Surface;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.pricer.capfloor.BlackIborCapletFloorletExpiryStrikeVolatilities;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilityCalibrationResult;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilityDefinition;
import com.opengamma.strata.pricer.capfloor.NormalIborCapletFloorletExpiryStrikeVolatilities;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapFloorLegPricer;
import com.opengamma.strata.pricer.option.RawOptionData;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloorLeg;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.function.Function;

abstract class IborCapletFloorletVolatilityCalibrator {
    private final VolatilityIborCapFloorLegPricer pricer;
    private final ReferenceData referenceData;

    public IborCapletFloorletVolatilityCalibrator(VolatilityIborCapFloorLegPricer pricer, ReferenceData referenceData) {
        this.pricer = (VolatilityIborCapFloorLegPricer)ArgChecker.notNull((Object)pricer, (String)"pricer");
        this.referenceData = (ReferenceData)ArgChecker.notNull((Object)referenceData, (String)"referenceData");
    }

    public abstract IborCapletFloorletVolatilityCalibrationResult calibrate(IborCapletFloorletVolatilityDefinition var1, ZonedDateTime var2, RawOptionData var3, RatesProvider var4);

    protected ReferenceData getReferenceData() {
        return this.referenceData;
    }

    protected VolatilityIborCapFloorLegPricer getLegPricer() {
        return this.pricer;
    }

    protected void reduceRawData(IborCapletFloorletVolatilityDefinition definition, RatesProvider ratesProvider, DoubleArray strikes, DoubleArray volatilityData, DoubleArray errors, LocalDate startDate, LocalDate endDate, SurfaceMetadata metadata, Function<Surface, IborCapletFloorletVolatilities> volatilityFunction, List<Double> timeList, List<Double> strikeList, List<Double> volList, List<ResolvedIborCapFloorLeg> capList, List<Double> priceList, List<Double> errorList) {
        int nStrikes = strikes.size();
        for (int i = 0; i < nStrikes; ++i) {
            if (!Double.isFinite(volatilityData.get(i))) continue;
            ResolvedIborCapFloorLeg capFloor = definition.createCap(startDate, endDate, strikes.get(i)).resolve(this.referenceData);
            capList.add(capFloor);
            strikeList.add(strikes.get(i));
            volList.add(volatilityData.get(i));
            ConstantSurface constVolSurface = ConstantSurface.of((SurfaceMetadata)metadata, (double)volatilityData.get(i));
            IborCapletFloorletVolatilities vols = volatilityFunction.apply((Surface)constVolSurface);
            timeList.add(vols.relativeTime(capFloor.getFinalFixingDateTime()));
            priceList.add(this.pricer.presentValue(capFloor, ratesProvider, vols).getAmount());
            errorList.add(errors.get(i));
        }
    }

    protected Function<Surface, IborCapletFloorletVolatilities> volatilitiesFunction(IborCapletFloorletVolatilityDefinition definition, ZonedDateTime calibrationDateTime, RawOptionData capFloorData) {
        IborIndex index = definition.getIndex();
        if (capFloorData.getStrikeType().equals((Object)ValueType.STRIKE)) {
            if (capFloorData.getDataType().equals((Object)ValueType.BLACK_VOLATILITY)) {
                return this.blackVolatilitiesFunction(index, calibrationDateTime);
            }
            if (capFloorData.getDataType().equals((Object)ValueType.NORMAL_VOLATILITY)) {
                return this.normalVolatilitiesFunction(index, calibrationDateTime);
            }
            throw new IllegalArgumentException("Data type not supported");
        }
        throw new IllegalArgumentException("strike type must be ValueType.STRIKE");
    }

    private Function<Surface, IborCapletFloorletVolatilities> blackVolatilitiesFunction(final IborIndex index, final ZonedDateTime calibrationDateTime) {
        Function<Surface, IborCapletFloorletVolatilities> func = new Function<Surface, IborCapletFloorletVolatilities>(){

            @Override
            public IborCapletFloorletVolatilities apply(Surface s) {
                return BlackIborCapletFloorletExpiryStrikeVolatilities.of(index, calibrationDateTime, s);
            }
        };
        return func;
    }

    private Function<Surface, IborCapletFloorletVolatilities> normalVolatilitiesFunction(final IborIndex index, final ZonedDateTime calibrationDateTime) {
        Function<Surface, IborCapletFloorletVolatilities> func = new Function<Surface, IborCapletFloorletVolatilities>(){

            @Override
            public IborCapletFloorletVolatilities apply(Surface s) {
                return NormalIborCapletFloorletExpiryStrikeVolatilities.of(index, calibrationDateTime, s);
            }
        };
        return func;
    }
}

