/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import com.opengamma.strata.pricer.option.RawOptionData;
import com.opengamma.strata.product.capfloor.IborCapFloorLeg;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.IborRateCalculation;
import java.time.LocalDate;
import java.time.Period;

public interface IborCapletFloorletVolatilityDefinition {
    public IborCapletFloorletVolatilitiesName getName();

    public IborIndex getIndex();

    public DayCount getDayCount();

    public SurfaceMetadata createMetadata(RawOptionData var1);

    default public IborCapFloorLeg createCap(LocalDate startDate, LocalDate endDate, double strike) {
        IborIndex index = this.getIndex();
        return IborCapFloorLeg.builder().calculation(IborRateCalculation.of((IborIndex)index)).capSchedule(ValueSchedule.of((double)strike)).currency(index.getCurrency()).notional(ValueSchedule.ALWAYS_1).paymentSchedule(PeriodicSchedule.of((LocalDate)startDate, (LocalDate)endDate, (Frequency)Frequency.of((Period)index.getTenor().getPeriod()), (BusinessDayAdjustment)BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)index.getFixingCalendar()), (StubConvention)StubConvention.NONE, (RollConvention)RollConventions.NONE)).payReceive(PayReceive.RECEIVE).build();
    }
}

