/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.capfloor.SabrIborCapFloorLegPricer;
import com.opengamma.strata.pricer.capfloor.SabrIborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapFloorProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapLegPricer;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloor;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;

public class SabrIborCapFloorProductPricer
extends VolatilityIborCapFloorProductPricer {
    public static final SabrIborCapFloorProductPricer DEFAULT = new SabrIborCapFloorProductPricer(SabrIborCapFloorLegPricer.DEFAULT, DiscountingSwapLegPricer.DEFAULT);
    private final SabrIborCapFloorLegPricer capFloorLegPricer;

    public SabrIborCapFloorProductPricer(SabrIborCapFloorLegPricer capFloorLegPricer, DiscountingSwapLegPricer payLegPricer) {
        super(capFloorLegPricer, payLegPricer);
        this.capFloorLegPricer = capFloorLegPricer;
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyModel(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider, SabrIborCapletFloorletVolatilities volatilities) {
        PointSensitivityBuilder pvSensiCapFloorLeg = this.capFloorLegPricer.presentValueSensitivityRatesStickyModel(capFloor.getCapFloorLeg(), ratesProvider, volatilities);
        if (!capFloor.getPayLeg().isPresent()) {
            return pvSensiCapFloorLeg;
        }
        PointSensitivityBuilder pvSensiPayLeg = this.getPayLegPricer().presentValueSensitivity((ResolvedSwapLeg)capFloor.getPayLeg().get(), ratesProvider);
        return pvSensiCapFloorLeg.combinedWith(pvSensiPayLeg);
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsSabr(ResolvedIborCapFloor capFloor, RatesProvider ratesProvider, SabrIborCapletFloorletVolatilities volatilities) {
        return this.capFloorLegPricer.presentValueSensitivityModelParamsSabr(capFloor.getCapFloorLeg(), ratesProvider, volatilities);
    }
}

