/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.capfloor.SabrIborCapFloorProductPricer;
import com.opengamma.strata.pricer.capfloor.SabrIborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapFloorTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.ResolvedIborCapFloorTrade;

public class SabrIborCapFloorTradePricer
extends VolatilityIborCapFloorTradePricer {
    public static final SabrIborCapFloorTradePricer DEFAULT = new SabrIborCapFloorTradePricer(SabrIborCapFloorProductPricer.DEFAULT, DiscountingPaymentPricer.DEFAULT);
    private final SabrIborCapFloorProductPricer productPricer;

    public SabrIborCapFloorTradePricer(SabrIborCapFloorProductPricer productPricer, DiscountingPaymentPricer paymentPricer) {
        super(productPricer, paymentPricer);
        this.productPricer = productPricer;
    }

    public PointSensitivities presentValueSensitivityRatesStickyModel(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, SabrIborCapletFloorletVolatilities volatilities) {
        PointSensitivityBuilder pvSensiProduct = this.productPricer.presentValueSensitivityRatesStickyModel(trade.getProduct(), ratesProvider, volatilities);
        if (!trade.getPremium().isPresent()) {
            return pvSensiProduct.build();
        }
        PointSensitivityBuilder pvSensiPremium = this.getPaymentPricer().presentValueSensitivity((Payment)trade.getPremium().get(), ratesProvider);
        return pvSensiProduct.combinedWith(pvSensiPremium).build();
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsSabr(ResolvedIborCapFloorTrade trade, RatesProvider ratesProvider, SabrIborCapletFloorletVolatilities volatilities) {
        return this.productPricer.presentValueSensitivityModelParamsSabr(trade.getProduct(), ratesProvider, volatilities);
    }
}

