/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.value.ValueDerivatives;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.model.SabrParameterType;
import com.opengamma.strata.market.sensitivity.PointSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletSabrSensitivity;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import com.opengamma.strata.pricer.capfloor.SabrIborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapletFloorletPeriodPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.IborCapletFloorletPeriod;
import com.opengamma.strata.product.common.PutCall;

public class SabrIborCapletFloorletPeriodPricer
extends VolatilityIborCapletFloorletPeriodPricer {
    public static final SabrIborCapletFloorletPeriodPricer DEFAULT = new SabrIborCapletFloorletPeriodPricer();

    @Override
    protected void validate(IborCapletFloorletVolatilities volatilities) {
        ArgChecker.isTrue((boolean)(volatilities instanceof SabrIborCapletFloorletVolatilities), (String)"volatilities must be SABR volatilities");
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyModel(IborCapletFloorletPeriod period, RatesProvider ratesProvider, SabrIborCapletFloorletVolatilities volatilities) {
        Currency currency = period.getCurrency();
        if (ratesProvider.getValuationDate().isAfter(period.getPaymentDate())) {
            return PointSensitivityBuilder.none();
        }
        double expiry = volatilities.relativeTime(period.getFixingDateTime());
        PutCall putCall = period.getPutCall();
        double strike = period.getStrike();
        double indexRate = ratesProvider.iborIndexRates(period.getIndex()).rate(period.getIborRate().getObservation());
        ZeroRateSensitivity dfSensi = ratesProvider.discountFactors(currency).zeroRatePointSensitivity(period.getPaymentDate());
        double factor = period.getNotional() * period.getYearFraction();
        if (expiry < 0.0) {
            double sign = putCall.isCall() ? 1.0 : -1.0;
            double payoff = Math.max(sign * (indexRate - strike), 0.0);
            return dfSensi.multipliedBy(payoff * factor);
        }
        ValueDerivatives volatilityAdj = volatilities.volatilityAdjoint(expiry, strike, indexRate);
        PointSensitivityBuilder indexRateSensiSensi = ratesProvider.iborIndexRates(period.getIndex()).ratePointSensitivity(period.getIborRate().getObservation());
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        double fwdPv = factor * volatilities.price(expiry, putCall, strike, indexRate, volatilityAdj.getValue());
        double fwdDelta = factor * volatilities.priceDelta(expiry, putCall, strike, indexRate, volatilityAdj.getValue());
        double fwdVega = factor * volatilities.priceVega(expiry, putCall, strike, indexRate, volatilityAdj.getValue());
        return dfSensi.multipliedBy(fwdPv).combinedWith(indexRateSensiSensi.multipliedBy(fwdDelta * df + fwdVega * volatilityAdj.getDerivative(0) * df));
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsSabr(IborCapletFloorletPeriod period, RatesProvider ratesProvider, SabrIborCapletFloorletVolatilities volatilities) {
        double expiry = volatilities.relativeTime(period.getFixingDateTime());
        if (expiry < 0.0) {
            return PointSensitivityBuilder.none();
        }
        Currency currency = period.getCurrency();
        PutCall putCall = period.getPutCall();
        double strike = period.getStrike();
        double indexRate = ratesProvider.iborIndexRates(period.getIndex()).rate(period.getIborRate().getObservation());
        double factor = period.getNotional() * period.getYearFraction();
        ValueDerivatives volatilityAdj = volatilities.volatilityAdjoint(expiry, strike, indexRate);
        DoubleArray derivative = volatilityAdj.getDerivatives();
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        double vega = df * factor * volatilities.priceVega(expiry, putCall, strike, indexRate, volatilityAdj.getValue());
        IborCapletFloorletVolatilitiesName name = volatilities.getName();
        return PointSensitivityBuilder.of((PointSensitivity[])new PointSensitivity[]{IborCapletFloorletSabrSensitivity.of(name, expiry, SabrParameterType.ALPHA, currency, vega * derivative.get(2)), IborCapletFloorletSabrSensitivity.of(name, expiry, SabrParameterType.BETA, currency, vega * derivative.get(3)), IborCapletFloorletSabrSensitivity.of(name, expiry, SabrParameterType.RHO, currency, vega * derivative.get(4)), IborCapletFloorletSabrSensitivity.of(name, expiry, SabrParameterType.NU, currency, vega * derivative.get(5))});
    }
}

