/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.ConstantCurve;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.Curves;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolators;
import com.opengamma.strata.market.surface.SurfaceMetadata;
import com.opengamma.strata.market.surface.Surfaces;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilitiesName;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilityDefinition;
import com.opengamma.strata.pricer.model.SabrVolatilityFormula;
import com.opengamma.strata.pricer.option.RawOptionData;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class SabrIborCapletFloorletVolatilityBootstrapDefinition
implements IborCapletFloorletVolatilityDefinition,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborCapletFloorletVolatilitiesName name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DayCount dayCount;
    @PropertyDefinition(get="optional")
    private final Curve betaCurve;
    @PropertyDefinition(get="optional")
    private final Curve rhoCurve;
    @PropertyDefinition(validate="notNull")
    private final Curve shiftCurve;
    @PropertyDefinition(validate="notNull")
    private final CurveInterpolator interpolator;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator extrapolatorLeft;
    @PropertyDefinition(validate="notNull")
    private final CurveExtrapolator extrapolatorRight;
    @PropertyDefinition(validate="notNull")
    private final SabrVolatilityFormula sabrVolatilityFormula;
    private static final long serialVersionUID = 1L;

    public static SabrIborCapletFloorletVolatilityBootstrapDefinition ofFixedBeta(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double beta, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        ConstantCurve shiftCurve = ConstantCurve.of((String)"Zero shift", (double)0.0);
        ConstantCurve betaCurve = ConstantCurve.of((CurveMetadata)Curves.sabrParameterByExpiry((String)(name.getName() + "-Beta"), (DayCount)dayCount, (ValueType)ValueType.SABR_BETA), (double)beta);
        return new SabrIborCapletFloorletVolatilityBootstrapDefinition(name, index, dayCount, (Curve)betaCurve, null, (Curve)shiftCurve, interpolator, extrapolatorLeft, extrapolatorRight, sabrVolatilityFormula);
    }

    public static SabrIborCapletFloorletVolatilityBootstrapDefinition ofFixedBeta(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double beta, double shift, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        ConstantCurve shiftCurve = ConstantCurve.of((String)"Shift curve", (double)shift);
        ConstantCurve betaCurve = ConstantCurve.of((CurveMetadata)Curves.sabrParameterByExpiry((String)(name.getName() + "-Beta"), (DayCount)dayCount, (ValueType)ValueType.SABR_BETA), (double)beta);
        return new SabrIborCapletFloorletVolatilityBootstrapDefinition(name, index, dayCount, (Curve)betaCurve, null, (Curve)shiftCurve, interpolator, extrapolatorLeft, extrapolatorRight, sabrVolatilityFormula);
    }

    public static SabrIborCapletFloorletVolatilityBootstrapDefinition ofFixedRho(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double rho, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        ConstantCurve shiftCurve = ConstantCurve.of((String)"Zero shift", (double)0.0);
        ConstantCurve rhoCurve = ConstantCurve.of((CurveMetadata)Curves.sabrParameterByExpiry((String)(name.getName() + "-Rho"), (DayCount)dayCount, (ValueType)ValueType.SABR_RHO), (double)rho);
        return new SabrIborCapletFloorletVolatilityBootstrapDefinition(name, index, dayCount, null, (Curve)rhoCurve, (Curve)shiftCurve, interpolator, extrapolatorLeft, extrapolatorRight, sabrVolatilityFormula);
    }

    public static SabrIborCapletFloorletVolatilityBootstrapDefinition ofFixedRho(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, double rho, double shift, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        ConstantCurve shiftCurve = ConstantCurve.of((String)"Shift curve", (double)shift);
        ConstantCurve rhoCurve = ConstantCurve.of((CurveMetadata)Curves.sabrParameterByExpiry((String)(name.getName() + "-Rho"), (DayCount)dayCount, (ValueType)ValueType.SABR_RHO), (double)rho);
        return new SabrIborCapletFloorletVolatilityBootstrapDefinition(name, index, dayCount, null, (Curve)rhoCurve, (Curve)shiftCurve, interpolator, extrapolatorLeft, extrapolatorRight, sabrVolatilityFormula);
    }

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.shiftCurve == null) {
            builder.shiftCurve = (Curve)ConstantCurve.of((String)"Zero shift", (double)0.0);
        }
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((boolean)this.extrapolatorLeft.equals(CurveExtrapolators.FLAT), (String)"extrapolator left must be flat extrapolator");
        ArgChecker.isTrue((this.interpolator.equals(CurveInterpolators.LINEAR) || this.interpolator.equals(CurveInterpolators.STEP_UPPER) ? 1 : 0) != 0, (String)"interpolator must be local interpolator");
        ArgChecker.isFalse((this.betaCurve != null && this.rhoCurve != null ? 1 : 0) != 0, (String)"Only betaCurve or rhoCurve must be set, not both");
        ArgChecker.isFalse((this.betaCurve == null && this.rhoCurve == null ? 1 : 0) != 0, (String)"Either betaCurve or rhoCurve must be set");
    }

    @Override
    public SurfaceMetadata createMetadata(RawOptionData capFloorData) {
        SurfaceMetadata metadata;
        if (capFloorData.getDataType().equals((Object)ValueType.BLACK_VOLATILITY)) {
            metadata = Surfaces.blackVolatilityByExpiryStrike((String)this.name.getName(), (DayCount)this.dayCount);
        } else if (capFloorData.getDataType().equals((Object)ValueType.NORMAL_VOLATILITY)) {
            metadata = Surfaces.normalVolatilityByExpiryStrike((String)this.name.getName(), (DayCount)this.dayCount);
        } else {
            throw new IllegalArgumentException("Data type not supported");
        }
        return metadata;
    }

    public ImmutableList<CurveMetadata> createSabrParameterMetadata() {
        CurveMetadata alphaMetadata = Curves.sabrParameterByExpiry((String)(this.name.getName() + "-Alpha"), (DayCount)this.dayCount, (ValueType)ValueType.SABR_ALPHA);
        CurveMetadata betaMetadata = Curves.sabrParameterByExpiry((String)(this.name.getName() + "-Beta"), (DayCount)this.dayCount, (ValueType)ValueType.SABR_BETA);
        CurveMetadata rhoMetadata = Curves.sabrParameterByExpiry((String)(this.name.getName() + "-Rho"), (DayCount)this.dayCount, (ValueType)ValueType.SABR_RHO);
        CurveMetadata nuMetadata = Curves.sabrParameterByExpiry((String)(this.name.getName() + "-Nu"), (DayCount)this.dayCount, (ValueType)ValueType.SABR_NU);
        return ImmutableList.of((Object)alphaMetadata, (Object)betaMetadata, (Object)rhoMetadata, (Object)nuMetadata);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private SabrIborCapletFloorletVolatilityBootstrapDefinition(IborCapletFloorletVolatilitiesName name, IborIndex index, DayCount dayCount, Curve betaCurve, Curve rhoCurve, Curve shiftCurve, CurveInterpolator interpolator, CurveExtrapolator extrapolatorLeft, CurveExtrapolator extrapolatorRight, SabrVolatilityFormula sabrVolatilityFormula) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)shiftCurve, (String)"shiftCurve");
        JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
        JodaBeanUtils.notNull((Object)extrapolatorLeft, (String)"extrapolatorLeft");
        JodaBeanUtils.notNull((Object)extrapolatorRight, (String)"extrapolatorRight");
        JodaBeanUtils.notNull((Object)sabrVolatilityFormula, (String)"sabrVolatilityFormula");
        this.name = name;
        this.index = index;
        this.dayCount = dayCount;
        this.betaCurve = betaCurve;
        this.rhoCurve = rhoCurve;
        this.shiftCurve = shiftCurve;
        this.interpolator = interpolator;
        this.extrapolatorLeft = extrapolatorLeft;
        this.extrapolatorRight = extrapolatorRight;
        this.sabrVolatilityFormula = sabrVolatilityFormula;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public IborCapletFloorletVolatilitiesName getName() {
        return this.name;
    }

    @Override
    public IborIndex getIndex() {
        return this.index;
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount;
    }

    public Optional<Curve> getBetaCurve() {
        return Optional.ofNullable(this.betaCurve);
    }

    public Optional<Curve> getRhoCurve() {
        return Optional.ofNullable(this.rhoCurve);
    }

    public Curve getShiftCurve() {
        return this.shiftCurve;
    }

    public CurveInterpolator getInterpolator() {
        return this.interpolator;
    }

    public CurveExtrapolator getExtrapolatorLeft() {
        return this.extrapolatorLeft;
    }

    public CurveExtrapolator getExtrapolatorRight() {
        return this.extrapolatorRight;
    }

    public SabrVolatilityFormula getSabrVolatilityFormula() {
        return this.sabrVolatilityFormula;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SabrIborCapletFloorletVolatilityBootstrapDefinition other = (SabrIborCapletFloorletVolatilityBootstrapDefinition)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.betaCurve, (Object)other.betaCurve) && JodaBeanUtils.equal((Object)this.rhoCurve, (Object)other.rhoCurve) && JodaBeanUtils.equal((Object)this.shiftCurve, (Object)other.shiftCurve) && JodaBeanUtils.equal((Object)this.interpolator, (Object)other.interpolator) && JodaBeanUtils.equal((Object)this.extrapolatorLeft, (Object)other.extrapolatorLeft) && JodaBeanUtils.equal((Object)this.extrapolatorRight, (Object)other.extrapolatorRight) && JodaBeanUtils.equal((Object)this.sabrVolatilityFormula, (Object)other.sabrVolatilityFormula);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.betaCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rhoCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.shiftCurve);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.interpolator);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.extrapolatorLeft);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.extrapolatorRight);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.sabrVolatilityFormula);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(352);
        buf.append("SabrIborCapletFloorletVolatilityBootstrapDefinition{");
        buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("betaCurve").append('=').append(JodaBeanUtils.toString((Object)this.betaCurve)).append(',').append(' ');
        buf.append("rhoCurve").append('=').append(JodaBeanUtils.toString((Object)this.rhoCurve)).append(',').append(' ');
        buf.append("shiftCurve").append('=').append(JodaBeanUtils.toString((Object)this.shiftCurve)).append(',').append(' ');
        buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
        buf.append("extrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorLeft)).append(',').append(' ');
        buf.append("extrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorRight)).append(',').append(' ');
        buf.append("sabrVolatilityFormula").append('=').append(JodaBeanUtils.toString((Object)this.sabrVolatilityFormula));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<SabrIborCapletFloorletVolatilityBootstrapDefinition> {
        private IborCapletFloorletVolatilitiesName name;
        private IborIndex index;
        private DayCount dayCount;
        private Curve betaCurve;
        private Curve rhoCurve;
        private Curve shiftCurve;
        private CurveInterpolator interpolator;
        private CurveExtrapolator extrapolatorLeft;
        private CurveExtrapolator extrapolatorRight;
        private SabrVolatilityFormula sabrVolatilityFormula;

        private Builder() {
        }

        private Builder(SabrIborCapletFloorletVolatilityBootstrapDefinition beanToCopy) {
            this.name = beanToCopy.getName();
            this.index = beanToCopy.getIndex();
            this.dayCount = beanToCopy.getDayCount();
            this.betaCurve = beanToCopy.betaCurve;
            this.rhoCurve = beanToCopy.rhoCurve;
            this.shiftCurve = beanToCopy.getShiftCurve();
            this.interpolator = beanToCopy.getInterpolator();
            this.extrapolatorLeft = beanToCopy.getExtrapolatorLeft();
            this.extrapolatorRight = beanToCopy.getExtrapolatorRight();
            this.sabrVolatilityFormula = beanToCopy.getSabrVolatilityFormula();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 1607020767: {
                    return this.betaCurve;
                }
                case -2128671882: {
                    return this.rhoCurve;
                }
                case 1908090253: {
                    return this.shiftCurve;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1271703994: {
                    return this.extrapolatorLeft;
                }
                case 773779145: {
                    return this.extrapolatorRight;
                }
                case -683564541: {
                    return this.sabrVolatilityFormula;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (IborCapletFloorletVolatilitiesName)newValue;
                    break;
                }
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 1607020767: {
                    this.betaCurve = (Curve)newValue;
                    break;
                }
                case -2128671882: {
                    this.rhoCurve = (Curve)newValue;
                    break;
                }
                case 1908090253: {
                    this.shiftCurve = (Curve)newValue;
                    break;
                }
                case 2096253127: {
                    this.interpolator = (CurveInterpolator)newValue;
                    break;
                }
                case 1271703994: {
                    this.extrapolatorLeft = (CurveExtrapolator)newValue;
                    break;
                }
                case 773779145: {
                    this.extrapolatorRight = (CurveExtrapolator)newValue;
                    break;
                }
                case -683564541: {
                    this.sabrVolatilityFormula = (SabrVolatilityFormula)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SabrIborCapletFloorletVolatilityBootstrapDefinition build() {
            SabrIborCapletFloorletVolatilityBootstrapDefinition.preBuild(this);
            return new SabrIborCapletFloorletVolatilityBootstrapDefinition(this.name, this.index, this.dayCount, this.betaCurve, this.rhoCurve, this.shiftCurve, this.interpolator, this.extrapolatorLeft, this.extrapolatorRight, this.sabrVolatilityFormula);
        }

        public Builder name(IborCapletFloorletVolatilitiesName name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder betaCurve(Curve betaCurve) {
            this.betaCurve = betaCurve;
            return this;
        }

        public Builder rhoCurve(Curve rhoCurve) {
            this.rhoCurve = rhoCurve;
            return this;
        }

        public Builder shiftCurve(Curve shiftCurve) {
            JodaBeanUtils.notNull((Object)shiftCurve, (String)"shiftCurve");
            this.shiftCurve = shiftCurve;
            return this;
        }

        public Builder interpolator(CurveInterpolator interpolator) {
            JodaBeanUtils.notNull((Object)interpolator, (String)"interpolator");
            this.interpolator = interpolator;
            return this;
        }

        public Builder extrapolatorLeft(CurveExtrapolator extrapolatorLeft) {
            JodaBeanUtils.notNull((Object)extrapolatorLeft, (String)"extrapolatorLeft");
            this.extrapolatorLeft = extrapolatorLeft;
            return this;
        }

        public Builder extrapolatorRight(CurveExtrapolator extrapolatorRight) {
            JodaBeanUtils.notNull((Object)extrapolatorRight, (String)"extrapolatorRight");
            this.extrapolatorRight = extrapolatorRight;
            return this;
        }

        public Builder sabrVolatilityFormula(SabrVolatilityFormula sabrVolatilityFormula) {
            JodaBeanUtils.notNull((Object)sabrVolatilityFormula, (String)"sabrVolatilityFormula");
            this.sabrVolatilityFormula = sabrVolatilityFormula;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(352);
            buf.append("SabrIborCapletFloorletVolatilityBootstrapDefinition.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("betaCurve").append('=').append(JodaBeanUtils.toString((Object)this.betaCurve)).append(',').append(' ');
            buf.append("rhoCurve").append('=').append(JodaBeanUtils.toString((Object)this.rhoCurve)).append(',').append(' ');
            buf.append("shiftCurve").append('=').append(JodaBeanUtils.toString((Object)this.shiftCurve)).append(',').append(' ');
            buf.append("interpolator").append('=').append(JodaBeanUtils.toString((Object)this.interpolator)).append(',').append(' ');
            buf.append("extrapolatorLeft").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorLeft)).append(',').append(' ');
            buf.append("extrapolatorRight").append('=').append(JodaBeanUtils.toString((Object)this.extrapolatorRight)).append(',').append(' ');
            buf.append("sabrVolatilityFormula").append('=').append(JodaBeanUtils.toString((Object)this.sabrVolatilityFormula));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborCapletFloorletVolatilitiesName> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", SabrIborCapletFloorletVolatilityBootstrapDefinition.class, IborCapletFloorletVolatilitiesName.class);
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", SabrIborCapletFloorletVolatilityBootstrapDefinition.class, IborIndex.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", SabrIborCapletFloorletVolatilityBootstrapDefinition.class, DayCount.class);
        private final MetaProperty<Curve> betaCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"betaCurve", SabrIborCapletFloorletVolatilityBootstrapDefinition.class, Curve.class);
        private final MetaProperty<Curve> rhoCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rhoCurve", SabrIborCapletFloorletVolatilityBootstrapDefinition.class, Curve.class);
        private final MetaProperty<Curve> shiftCurve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"shiftCurve", SabrIborCapletFloorletVolatilityBootstrapDefinition.class, Curve.class);
        private final MetaProperty<CurveInterpolator> interpolator = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"interpolator", SabrIborCapletFloorletVolatilityBootstrapDefinition.class, CurveInterpolator.class);
        private final MetaProperty<CurveExtrapolator> extrapolatorLeft = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"extrapolatorLeft", SabrIborCapletFloorletVolatilityBootstrapDefinition.class, CurveExtrapolator.class);
        private final MetaProperty<CurveExtrapolator> extrapolatorRight = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"extrapolatorRight", SabrIborCapletFloorletVolatilityBootstrapDefinition.class, CurveExtrapolator.class);
        private final MetaProperty<SabrVolatilityFormula> sabrVolatilityFormula = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"sabrVolatilityFormula", SabrIborCapletFloorletVolatilityBootstrapDefinition.class, SabrVolatilityFormula.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "index", "dayCount", "betaCurve", "rhoCurve", "shiftCurve", "interpolator", "extrapolatorLeft", "extrapolatorRight", "sabrVolatilityFormula"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 100346066: {
                    return this.index;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 1607020767: {
                    return this.betaCurve;
                }
                case -2128671882: {
                    return this.rhoCurve;
                }
                case 1908090253: {
                    return this.shiftCurve;
                }
                case 2096253127: {
                    return this.interpolator;
                }
                case 1271703994: {
                    return this.extrapolatorLeft;
                }
                case 773779145: {
                    return this.extrapolatorRight;
                }
                case -683564541: {
                    return this.sabrVolatilityFormula;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends SabrIborCapletFloorletVolatilityBootstrapDefinition> beanType() {
            return SabrIborCapletFloorletVolatilityBootstrapDefinition.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborCapletFloorletVolatilitiesName> name() {
            return this.name;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<Curve> betaCurve() {
            return this.betaCurve;
        }

        public MetaProperty<Curve> rhoCurve() {
            return this.rhoCurve;
        }

        public MetaProperty<Curve> shiftCurve() {
            return this.shiftCurve;
        }

        public MetaProperty<CurveInterpolator> interpolator() {
            return this.interpolator;
        }

        public MetaProperty<CurveExtrapolator> extrapolatorLeft() {
            return this.extrapolatorLeft;
        }

        public MetaProperty<CurveExtrapolator> extrapolatorRight() {
            return this.extrapolatorRight;
        }

        public MetaProperty<SabrVolatilityFormula> sabrVolatilityFormula() {
            return this.sabrVolatilityFormula;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((SabrIborCapletFloorletVolatilityBootstrapDefinition)bean).getName();
                }
                case 100346066: {
                    return ((SabrIborCapletFloorletVolatilityBootstrapDefinition)bean).getIndex();
                }
                case 1905311443: {
                    return ((SabrIborCapletFloorletVolatilityBootstrapDefinition)bean).getDayCount();
                }
                case 1607020767: {
                    return ((SabrIborCapletFloorletVolatilityBootstrapDefinition)bean).betaCurve;
                }
                case -2128671882: {
                    return ((SabrIborCapletFloorletVolatilityBootstrapDefinition)bean).rhoCurve;
                }
                case 1908090253: {
                    return ((SabrIborCapletFloorletVolatilityBootstrapDefinition)bean).getShiftCurve();
                }
                case 2096253127: {
                    return ((SabrIborCapletFloorletVolatilityBootstrapDefinition)bean).getInterpolator();
                }
                case 1271703994: {
                    return ((SabrIborCapletFloorletVolatilityBootstrapDefinition)bean).getExtrapolatorLeft();
                }
                case 773779145: {
                    return ((SabrIborCapletFloorletVolatilityBootstrapDefinition)bean).getExtrapolatorRight();
                }
                case -683564541: {
                    return ((SabrIborCapletFloorletVolatilityBootstrapDefinition)bean).getSabrVolatilityFormula();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

