/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.capfloor.VolatilityIborCapletFloorletPeriodPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.IborCapletFloorletBinaryPeriod;
import com.opengamma.strata.product.capfloor.IborCapletFloorletPeriod;
import com.opengamma.strata.product.common.PutCall;

public class VerticalSpreadVolatilityIborCapletFloorletBinaryPeriodPricer {
    private static final double DEFAULT_SPREAD = 1.0E-4;
    public static final VerticalSpreadVolatilityIborCapletFloorletBinaryPeriodPricer DEFAULT = new VerticalSpreadVolatilityIborCapletFloorletBinaryPeriodPricer(VolatilityIborCapletFloorletPeriodPricer.DEFAULT, 1.0E-4);
    private final VolatilityIborCapletFloorletPeriodPricer capletPricer;
    private final double spread;

    public VerticalSpreadVolatilityIborCapletFloorletBinaryPeriodPricer(VolatilityIborCapletFloorletPeriodPricer capletPricer, double spread) {
        this.capletPricer = (VolatilityIborCapletFloorletPeriodPricer)ArgChecker.notNull((Object)capletPricer, (String)"capletPricer");
        this.spread = ArgChecker.notNegativeOrZero((double)spread, (String)"spread");
    }

    VolatilityIborCapletFloorletPeriodPricer getVanillaOptionProductPricer() {
        return this.capletPricer;
    }

    double getSpread() {
        return this.spread;
    }

    public CurrencyAmount presentValue(IborCapletFloorletBinaryPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        double expiry = volatilities.relativeTime(period.getFixingDateTime());
        Currency currency = period.getCurrency();
        if (expiry < 0.0) {
            return CurrencyAmount.of((Currency)currency, (double)0.0);
        }
        Pair<IborCapletFloorletPeriod, IborCapletFloorletPeriod> callSpread = this.vanillaOptionVerticalSpreadPair(period);
        CurrencyAmount firstOptionPv = this.capletPricer.presentValue((IborCapletFloorletPeriod)callSpread.getFirst(), ratesProvider, volatilities);
        CurrencyAmount secondOptionPv = this.capletPricer.presentValue((IborCapletFloorletPeriod)callSpread.getSecond(), ratesProvider, volatilities);
        return firstOptionPv.plus(secondOptionPv).multipliedBy(Math.signum(period.getAmount()));
    }

    public PointSensitivityBuilder presentValueSensitivityRatesStickyStrike(IborCapletFloorletBinaryPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        double expiry = volatilities.relativeTime(period.getFixingDateTime());
        if (expiry < 0.0) {
            return PointSensitivityBuilder.none();
        }
        Pair<IborCapletFloorletPeriod, IborCapletFloorletPeriod> callSpread = this.vanillaOptionVerticalSpreadPair(period);
        PointSensitivityBuilder firstOptionPts = this.capletPricer.presentValueSensitivityRates((IborCapletFloorletPeriod)callSpread.getFirst(), ratesProvider, volatilities);
        PointSensitivityBuilder secondOptionPts = this.capletPricer.presentValueSensitivityRates((IborCapletFloorletPeriod)callSpread.getSecond(), ratesProvider, volatilities);
        return firstOptionPts.combinedWith(secondOptionPts).multipliedBy(Math.signum(period.getAmount()));
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsVolatility(IborCapletFloorletBinaryPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        double expiry = volatilities.relativeTime(period.getFixingDateTime());
        if (expiry < 0.0) {
            return PointSensitivityBuilder.none();
        }
        Pair<IborCapletFloorletPeriod, IborCapletFloorletPeriod> callSpread = this.vanillaOptionVerticalSpreadPair(period);
        PointSensitivityBuilder firstOptionPts = this.capletPricer.presentValueSensitivityModelParamsVolatility((IborCapletFloorletPeriod)callSpread.getFirst(), ratesProvider, volatilities);
        PointSensitivityBuilder secondOptionPts = this.capletPricer.presentValueSensitivityModelParamsVolatility((IborCapletFloorletPeriod)callSpread.getSecond(), ratesProvider, volatilities);
        return firstOptionPts.combinedWith(secondOptionPts).multipliedBy(Math.signum(period.getAmount()));
    }

    public Pair<IborCapletFloorletPeriod, IborCapletFloorletPeriod> vanillaOptionVerticalSpreadPair(IborCapletFloorletBinaryPeriod binary) {
        double capFloorInd = binary.getPutCall().equals((Object)PutCall.CALL) ? 1.0 : -1.0;
        double adjStrikeLow = binary.getStrike() - this.spread;
        double adjStrikeHigh = binary.getStrike() + this.spread;
        double amount = Math.abs(binary.getAmount());
        double rescaledNotional = amount / (2.0 * this.spread) * capFloorInd;
        IborCapletFloorletPeriod.Builder optionLong = IborCapletFloorletPeriod.builder().currency(binary.getCurrency()).notional(rescaledNotional).startDate(binary.getStartDate()).endDate(binary.getEndDate()).yearFraction(binary.getYearFraction()).paymentDate(binary.getPaymentDate()).iborRate(binary.getIborRate());
        IborCapletFloorletPeriod.Builder optionShort = IborCapletFloorletPeriod.builder().currency(binary.getCurrency()).notional(-rescaledNotional).startDate(binary.getStartDate()).endDate(binary.getEndDate()).yearFraction(binary.getYearFraction()).paymentDate(binary.getPaymentDate()).iborRate(binary.getIborRate());
        if (binary.getPutCall().equals((Object)PutCall.CALL)) {
            return Pair.of((Object)optionLong.caplet(Double.valueOf(adjStrikeLow)).build(), (Object)optionShort.caplet(Double.valueOf(adjStrikeHigh)).build());
        }
        return Pair.of((Object)optionLong.floorlet(Double.valueOf(adjStrikeLow)).build(), (Object)optionShort.floorlet(Double.valueOf(adjStrikeHigh)).build());
    }
}

