/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.capfloor;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletSensitivity;
import com.opengamma.strata.pricer.capfloor.IborCapletFloorletVolatilities;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.capfloor.IborCapletFloorletPeriod;
import com.opengamma.strata.product.common.PutCall;

public class VolatilityIborCapletFloorletPeriodPricer {
    public static final VolatilityIborCapletFloorletPeriodPricer DEFAULT = new VolatilityIborCapletFloorletPeriodPricer();

    public CurrencyAmount presentValue(IborCapletFloorletPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(volatilities);
        Currency currency = period.getCurrency();
        if (ratesProvider.getValuationDate().isAfter(period.getPaymentDate())) {
            return CurrencyAmount.of((Currency)currency, (double)0.0);
        }
        double expiry = volatilities.relativeTime(period.getFixingDateTime());
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        PutCall putCall = period.getPutCall();
        double strike = period.getStrike();
        double indexRate = this.forwardRate(period, ratesProvider);
        if (expiry < 0.0) {
            double sign = putCall.isCall() ? 1.0 : -1.0;
            double payoff = Math.max(sign * (indexRate - strike), 0.0);
            return CurrencyAmount.of((Currency)currency, (double)(df * payoff * period.getYearFraction() * period.getNotional()));
        }
        double volatility = this.impliedVolatility(period, ratesProvider, volatilities);
        double price = df * period.getYearFraction() * volatilities.price(expiry, putCall, strike, indexRate, volatility);
        return CurrencyAmount.of((Currency)currency, (double)(price * period.getNotional()));
    }

    public double impliedVolatility(IborCapletFloorletPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(volatilities);
        double expiry = volatilities.relativeTime(period.getFixingDateTime());
        ArgChecker.isTrue((expiry >= 0.0 ? 1 : 0) != 0, (String)"Option must be before expiry to compute an implied volatility");
        double forward = this.forwardRate(period, ratesProvider);
        double strike = period.getStrike();
        return volatilities.volatility(expiry, strike, forward);
    }

    public double forwardRate(IborCapletFloorletPeriod period, RatesProvider ratesProvider) {
        return ratesProvider.iborIndexRates(period.getIndex()).rate(period.getIborRate().getObservation());
    }

    public CurrencyAmount presentValueDelta(IborCapletFloorletPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(volatilities);
        double expiry = volatilities.relativeTime(period.getFixingDateTime());
        Currency currency = period.getCurrency();
        if (expiry < 0.0) {
            return CurrencyAmount.of((Currency)currency, (double)0.0);
        }
        double forward = this.forwardRate(period, ratesProvider);
        double strike = period.getStrike();
        double volatility = volatilities.volatility(expiry, strike, forward);
        PutCall putCall = period.getPutCall();
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        double priceDelta = df * period.getYearFraction() * volatilities.priceDelta(expiry, putCall, strike, forward, volatility);
        return CurrencyAmount.of((Currency)currency, (double)(priceDelta * period.getNotional()));
    }

    public CurrencyAmount presentValueGamma(IborCapletFloorletPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(volatilities);
        double expiry = volatilities.relativeTime(period.getFixingDateTime());
        Currency currency = period.getCurrency();
        if (expiry < 0.0) {
            return CurrencyAmount.of((Currency)currency, (double)0.0);
        }
        double forward = this.forwardRate(period, ratesProvider);
        double strike = period.getStrike();
        double volatility = volatilities.volatility(expiry, strike, forward);
        PutCall putCall = period.getPutCall();
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        double priceGamma = df * period.getYearFraction() * volatilities.priceGamma(expiry, putCall, strike, forward, volatility);
        return CurrencyAmount.of((Currency)currency, (double)(priceGamma * period.getNotional()));
    }

    public CurrencyAmount presentValueTheta(IborCapletFloorletPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(volatilities);
        double expiry = volatilities.relativeTime(period.getFixingDateTime());
        Currency currency = period.getCurrency();
        if (expiry < 0.0) {
            return CurrencyAmount.of((Currency)currency, (double)0.0);
        }
        double forward = this.forwardRate(period, ratesProvider);
        double strike = period.getStrike();
        double volatility = volatilities.volatility(expiry, strike, forward);
        PutCall putCall = period.getPutCall();
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        double priceTheta = df * period.getYearFraction() * volatilities.priceTheta(expiry, putCall, strike, forward, volatility);
        return CurrencyAmount.of((Currency)currency, (double)(priceTheta * period.getNotional()));
    }

    public PointSensitivityBuilder presentValueSensitivityRates(IborCapletFloorletPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(volatilities);
        Currency currency = period.getCurrency();
        if (ratesProvider.getValuationDate().isAfter(period.getPaymentDate())) {
            return PointSensitivityBuilder.none();
        }
        double expiry = volatilities.relativeTime(period.getFixingDateTime());
        PutCall putCall = period.getPutCall();
        double strike = period.getStrike();
        double indexRate = this.forwardRate(period, ratesProvider);
        ZeroRateSensitivity dfSensi = ratesProvider.discountFactors(currency).zeroRatePointSensitivity(period.getPaymentDate());
        if (expiry < 0.0) {
            double sign = putCall.isCall() ? 1.0 : -1.0;
            double payoff = Math.max(sign * (indexRate - strike), 0.0);
            return dfSensi.multipliedBy(payoff * period.getYearFraction() * period.getNotional());
        }
        PointSensitivityBuilder indexRateSensiSensi = ratesProvider.iborIndexRates(period.getIndex()).ratePointSensitivity(period.getIborRate().getObservation());
        double volatility = this.impliedVolatility(period, ratesProvider, volatilities);
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        double factor = period.getNotional() * period.getYearFraction();
        double fwdPv = factor * volatilities.price(expiry, putCall, strike, indexRate, volatility);
        double fwdDelta = factor * volatilities.priceDelta(expiry, putCall, strike, indexRate, volatility);
        return dfSensi.multipliedBy(fwdPv).combinedWith(indexRateSensiSensi.multipliedBy(fwdDelta * df));
    }

    public PointSensitivityBuilder presentValueSensitivityModelParamsVolatility(IborCapletFloorletPeriod period, RatesProvider ratesProvider, IborCapletFloorletVolatilities volatilities) {
        this.validate(volatilities);
        double expiry = volatilities.relativeTime(period.getFixingDateTime());
        double strike = period.getStrike();
        Currency currency = period.getCurrency();
        if (expiry <= 0.0) {
            return PointSensitivityBuilder.none();
        }
        double forward = this.forwardRate(period, ratesProvider);
        double volatility = volatilities.volatility(expiry, strike, forward);
        PutCall putCall = period.getPutCall();
        double df = ratesProvider.discountFactor(currency, period.getPaymentDate());
        double vega = df * period.getYearFraction() * volatilities.priceVega(expiry, putCall, strike, forward, volatility);
        return IborCapletFloorletSensitivity.of(volatilities.getName(), expiry, strike, forward, currency, vega * period.getNotional());
    }

    protected void validate(IborCapletFloorletVolatilities volatilities) {
    }
}

