/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.cms;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.impl.cms.DiscountingCmsPeriodPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.cms.CmsPeriod;
import com.opengamma.strata.product.cms.ResolvedCmsLeg;

public class DiscountingCmsLegPricer {
    private final DiscountingCmsPeriodPricer cmsPeriodPricer;

    public DiscountingCmsLegPricer(DiscountingCmsPeriodPricer cmsPeriodPricer) {
        this.cmsPeriodPricer = (DiscountingCmsPeriodPricer)ArgChecker.notNull((Object)cmsPeriodPricer, (String)"cmsPeriodPricer");
    }

    public CurrencyAmount presentValue(ResolvedCmsLeg cmsLeg, RatesProvider ratesProvider) {
        return cmsLeg.getCmsPeriods().stream().map(cmsPeriod -> this.cmsPeriodPricer.presentValue((CmsPeriod)cmsPeriod, ratesProvider)).reduce((c1, c2) -> c1.plus(c2)).get();
    }

    public PointSensitivityBuilder presentValueSensitivity(ResolvedCmsLeg cmsLeg, RatesProvider ratesProvider) {
        return cmsLeg.getCmsPeriods().stream().map(cmsPeriod -> this.cmsPeriodPricer.presentValueSensitivity((CmsPeriod)cmsPeriod, ratesProvider)).reduce((p1, p2) -> p1.combinedWith(p2)).get();
    }

    public CurrencyAmount currentCash(ResolvedCmsLeg cmsLeg, RatesProvider ratesProvider) {
        return cmsLeg.getCmsPeriods().stream().filter(x -> x.getPaymentDate().equals(ratesProvider.getValuationDate())).map(x -> this.cmsPeriodPricer.presentValue((CmsPeriod)x, ratesProvider)).reduce((c1, c2) -> c1.plus(c2)).orElse(CurrencyAmount.zero((Currency)cmsLeg.getCurrency()));
    }
}

