/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.cms;

import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.MultiCurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.cms.DiscountingCmsProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.product.cms.ResolvedCmsTrade;

public class DiscountingCmsTradePricer {
    public static final DiscountingCmsTradePricer DEFAULT = new DiscountingCmsTradePricer(DiscountingSwapProductPricer.DEFAULT, DiscountingPaymentPricer.DEFAULT);
    private final DiscountingCmsProductPricer productPricer;
    private final DiscountingPaymentPricer paymentPricer;

    public DiscountingCmsTradePricer(DiscountingSwapProductPricer swapPricer, DiscountingPaymentPricer paymentPricer) {
        this.paymentPricer = (DiscountingPaymentPricer)ArgChecker.notNull((Object)paymentPricer, (String)"paymentPricer");
        this.productPricer = new DiscountingCmsProductPricer(swapPricer);
    }

    public MultiCurrencyAmount presentValue(ResolvedCmsTrade trade, RatesProvider ratesProvider) {
        MultiCurrencyAmount pvCms = this.productPricer.presentValue(trade.getProduct(), ratesProvider);
        if (!trade.getPremium().isPresent()) {
            return pvCms;
        }
        CurrencyAmount pvPremium = this.paymentPricer.presentValue((Payment)trade.getPremium().get(), ratesProvider);
        return pvCms.plus(pvPremium);
    }

    public PointSensitivities presentValueSensitivity(ResolvedCmsTrade trade, RatesProvider ratesProvider) {
        PointSensitivityBuilder pvSensiCms = this.productPricer.presentValueSensitivity(trade.getProduct(), ratesProvider);
        if (!trade.getPremium().isPresent()) {
            return pvSensiCms.build();
        }
        PointSensitivityBuilder pvSensiPremium = this.paymentPricer.presentValueSensitivity((Payment)trade.getPremium().get(), ratesProvider);
        return pvSensiCms.combinedWith(pvSensiPremium).build();
    }

    public MultiCurrencyAmount currencyExposure(ResolvedCmsTrade trade, RatesProvider ratesProvider) {
        MultiCurrencyAmount ceCms = this.productPricer.currencyExposure(trade.getProduct(), ratesProvider);
        if (!trade.getPremium().isPresent()) {
            return ceCms;
        }
        CurrencyAmount pvPremium = this.paymentPricer.presentValue((Payment)trade.getPremium().get(), ratesProvider);
        return ceCms.plus(pvPremium);
    }

    public MultiCurrencyAmount currentCash(ResolvedCmsTrade trade, RatesProvider ratesProvider) {
        MultiCurrencyAmount ccCms = this.productPricer.currentCash(trade.getProduct(), ratesProvider);
        if (!trade.getPremium().isPresent()) {
            return ccCms;
        }
        Payment premium = (Payment)trade.getPremium().get();
        if (premium.getDate().equals(ratesProvider.getValuationDate())) {
            ccCms = ccCms.plus(premium.getCurrency(), premium.getAmount());
        }
        return ccCms;
    }
}

