/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.math.impl.linearalgebra.LUDecompositionCommons;
import com.opengamma.strata.math.impl.linearalgebra.LUDecompositionResult;
import com.opengamma.strata.math.impl.matrix.CommonsMatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.pricer.credit.AccrualOnDefaultFormula;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.ImmutableCreditRatesProvider;
import com.opengamma.strata.pricer.credit.IsdaCreditDiscountFactors;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.pricer.credit.SpreadSensitivityCalculator;
import com.opengamma.strata.product.credit.ResolvedCds;
import com.opengamma.strata.product.credit.ResolvedCdsTrade;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

public class AnalyticSpreadSensitivityCalculator
extends SpreadSensitivityCalculator {
    public static final AnalyticSpreadSensitivityCalculator DEFAULT = new AnalyticSpreadSensitivityCalculator(AccrualOnDefaultFormula.ORIGINAL_ISDA);
    private static final MatrixAlgebra MATRIX_ALGEBRA = new CommonsMatrixAlgebra();
    private static final LUDecompositionCommons DECOMPOSITION = new LUDecompositionCommons();

    public AnalyticSpreadSensitivityCalculator(AccrualOnDefaultFormula formula) {
        super(formula);
    }

    @Override
    public CurrencyAmount parallelCs01(ResolvedCdsTrade trade, List<ResolvedCdsTrade> bucketCds, CreditRatesProvider ratesProvider, ReferenceData refData) {
        DoubleArray temp = this.computedBucketedCs01(trade, bucketCds, ratesProvider, refData);
        return CurrencyAmount.of((Currency)trade.getProduct().getCurrency(), (double)temp.sum());
    }

    @Override
    DoubleArray computedBucketedCs01(ResolvedCdsTrade trade, List<ResolvedCdsTrade> bucketCds, CreditRatesProvider ratesProvider, ReferenceData refData) {
        this.checkCdsBucket(trade, bucketCds);
        ResolvedCds product = trade.getProduct();
        Currency currency = product.getCurrency();
        StandardId legalEntityId = product.getLegalEntityId();
        LocalDate valuationDate = ratesProvider.getValuationDate();
        int nBucket = bucketCds.size();
        DoubleArray impSp = this.impliedSpread(bucketCds, ratesProvider, refData);
        NodalCurve creditCurveBase = this.getCalibrator().calibrate(bucketCds, impSp, DoubleArray.filled((int)nBucket), CurveName.of((String)"baseImpliedCreditCurve"), valuationDate, ratesProvider.discountFactors(currency), ratesProvider.recoveryRates(legalEntityId), refData);
        IsdaCreditDiscountFactors df = IsdaCreditDiscountFactors.of(currency, valuationDate, creditCurveBase);
        ImmutableCreditRatesProvider ratesProviderBase = ratesProvider.toImmutableCreditRatesProvider().toBuilder().creditCurves((Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>)ImmutableMap.of((Object)Pair.of((Object)legalEntityId, (Object)currency), (Object)LegalEntitySurvivalProbabilities.of(legalEntityId, df))).build();
        double[][] res = new double[nBucket][];
        PointSensitivities pointPv = this.getPricer().presentValueOnSettleSensitivity(trade, ratesProviderBase, refData);
        DoubleArray vLambda = ratesProviderBase.singleCreditCurveParameterSensitivity(pointPv, legalEntityId, currency).getSensitivity();
        for (int i = 0; i < nBucket; ++i) {
            PointSensitivities pointSp = this.getPricer().parSpreadSensitivity(bucketCds.get(i), ratesProviderBase, refData);
            res[i] = ratesProviderBase.singleCreditCurveParameterSensitivity(pointSp, legalEntityId, currency).getSensitivity().toArray();
        }
        DoubleMatrix jacT = MATRIX_ALGEBRA.getTranspose((Matrix)DoubleMatrix.ofUnsafe((double[][])res));
        LUDecompositionResult luRes = DECOMPOSITION.apply(jacT);
        DoubleArray vS = luRes.solve(vLambda);
        return vS;
    }
}

