/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.pricer.common.PriceType;
import com.opengamma.strata.pricer.credit.AccrualOnDefaultFormula;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.FastCreditCurveCalibrator;
import com.opengamma.strata.pricer.credit.ImmutableCreditRatesProvider;
import com.opengamma.strata.pricer.credit.IsdaCdsTradePricer;
import com.opengamma.strata.pricer.credit.IsdaCompliantCreditCurveCalibrator;
import com.opengamma.strata.pricer.credit.IsdaCreditDiscountFactors;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.pricer.credit.RecoveryRates;
import com.opengamma.strata.product.credit.CdsQuote;
import com.opengamma.strata.product.credit.ResolvedCds;
import com.opengamma.strata.product.credit.ResolvedCdsTrade;
import com.opengamma.strata.product.credit.type.CdsQuoteConvention;
import java.time.LocalDate;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CdsMarketQuoteConverter {
    public static final CdsMarketQuoteConverter DEFAULT = new CdsMarketQuoteConverter();
    private final IsdaCompliantCreditCurveCalibrator calibrator;
    private final IsdaCdsTradePricer pricer;

    public CdsMarketQuoteConverter() {
        this.calibrator = FastCreditCurveCalibrator.standard();
        this.pricer = IsdaCdsTradePricer.DEFAULT;
    }

    public CdsMarketQuoteConverter(AccrualOnDefaultFormula formula) {
        this.calibrator = new FastCreditCurveCalibrator(formula);
        this.pricer = new IsdaCdsTradePricer(formula);
    }

    public double cleanPriceFromPointsUpfront(double pointsUpfront) {
        return 1.0 - pointsUpfront;
    }

    public double cleanPrice(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        double puf = this.pointsUpfront(trade, ratesProvider, refData);
        return 1.0 - puf;
    }

    public double pointsUpfront(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        return this.pricer.price(trade, ratesProvider, PriceType.CLEAN, refData);
    }

    public CdsQuote pointsUpFrontFromQuotedSpread(ResolvedCdsTrade trade, CdsQuote quote, CreditRatesProvider ratesProvider, ReferenceData refData) {
        ArgChecker.notNull((Object)trade, (String)"trade");
        ArgChecker.notNull((Object)quote, (String)"quote");
        ArgChecker.notNull((Object)ratesProvider, (String)"ratesProvider");
        ArgChecker.notNull((Object)refData, (String)"refData");
        ArgChecker.isTrue((boolean)quote.getQuoteConvention().equals((Object)CdsQuoteConvention.QUOTED_SPREAD), (String)"quote must be quoted spread");
        ResolvedCds product = trade.getProduct();
        Currency currency = product.getCurrency();
        StandardId legalEntityId = product.getLegalEntityId();
        LocalDate valuationDate = ratesProvider.getValuationDate();
        NodalCurve creditCurve = this.calibrator.calibrate((List<ResolvedCdsTrade>)ImmutableList.of((Object)trade), DoubleArray.of((double)quote.getQuotedValue()), DoubleArray.of((double)0.0), CurveName.of((String)"temp"), valuationDate, ratesProvider.discountFactors(currency), ratesProvider.recoveryRates(legalEntityId), refData);
        ImmutableCreditRatesProvider ratesProviderNew = ratesProvider.toImmutableCreditRatesProvider().toBuilder().creditCurves((Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>)ImmutableMap.of((Object)Pair.of((Object)legalEntityId, (Object)currency), (Object)LegalEntitySurvivalProbabilities.of(legalEntityId, IsdaCreditDiscountFactors.of(currency, valuationDate, creditCurve)))).build();
        double puf = this.pointsUpfront(trade, ratesProviderNew, refData);
        return CdsQuote.of((CdsQuoteConvention)CdsQuoteConvention.POINTS_UPFRONT, (double)puf);
    }

    public CdsQuote quotedSpreadFromPointsUpfront(ResolvedCdsTrade trade, CdsQuote quote, CreditRatesProvider ratesProvider, ReferenceData refData) {
        ArgChecker.notNull((Object)trade, (String)"trade");
        ArgChecker.notNull((Object)quote, (String)"quote");
        ArgChecker.notNull((Object)ratesProvider, (String)"ratesProvider");
        ArgChecker.notNull((Object)refData, (String)"refData");
        ArgChecker.isTrue((boolean)quote.getQuoteConvention().equals((Object)CdsQuoteConvention.POINTS_UPFRONT), (String)"quote must be points upfront");
        ResolvedCds product = trade.getProduct();
        Currency currency = product.getCurrency();
        StandardId legalEntityId = product.getLegalEntityId();
        LocalDate valuationDate = ratesProvider.getValuationDate();
        NodalCurve creditCurve = this.calibrator.calibrate((List<ResolvedCdsTrade>)ImmutableList.of((Object)trade), DoubleArray.of((double)product.getFixedRate()), DoubleArray.of((double)quote.getQuotedValue()), CurveName.of((String)"temp"), valuationDate, ratesProvider.discountFactors(currency), ratesProvider.recoveryRates(legalEntityId), refData);
        ImmutableCreditRatesProvider ratesProviderNew = ratesProvider.toImmutableCreditRatesProvider().toBuilder().creditCurves((Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>)ImmutableMap.of((Object)Pair.of((Object)legalEntityId, (Object)currency), (Object)LegalEntitySurvivalProbabilities.of(legalEntityId, IsdaCreditDiscountFactors.of(currency, valuationDate, creditCurve)))).build();
        double sp = this.pricer.parSpread(trade, ratesProviderNew, refData);
        return CdsQuote.of((CdsQuoteConvention)CdsQuoteConvention.QUOTED_SPREAD, (double)sp);
    }

    public List<CdsQuote> quotesFromParSpread(List<ResolvedCdsTrade> trades, List<CdsQuote> quotes, CreditRatesProvider ratesProvider, CdsQuoteConvention targetConvention, ReferenceData refData) {
        ArgChecker.noNulls(trades, (String)"trades");
        ArgChecker.noNulls(quotes, (String)"quotes");
        ArgChecker.notNull((Object)ratesProvider, (String)"ratesProvider");
        ArgChecker.notNull((Object)targetConvention, (String)"targetConvention");
        ArgChecker.notNull((Object)refData, (String)"refData");
        int nNodes = trades.size();
        ArgChecker.isTrue((quotes.size() == nNodes ? 1 : 0) != 0, (String)"trades and quotes must be the same size");
        quotes.forEach(q -> ArgChecker.isTrue((boolean)q.getQuoteConvention().equals((Object)CdsQuoteConvention.PAR_SPREAD), (String)"quote must be par spread"));
        Iterator legalEntities = trades.stream().map(t -> t.getProduct().getLegalEntityId()).collect(Collectors.toSet()).iterator();
        StandardId legalEntityId = (StandardId)legalEntities.next();
        ArgChecker.isFalse((boolean)legalEntities.hasNext(), (String)"legal entity must be common to trades");
        Iterator currencies = trades.stream().map(t -> t.getProduct().getCurrency()).collect(Collectors.toSet()).iterator();
        Currency currency = (Currency)currencies.next();
        ArgChecker.isFalse((boolean)currencies.hasNext(), (String)"currency must be common to trades");
        LocalDate valuationDate = ratesProvider.getValuationDate();
        CreditDiscountFactors discountFactors = ratesProvider.discountFactors(currency);
        RecoveryRates recoveryRates = ratesProvider.recoveryRates(legalEntityId);
        NodalCurve creditCurve = this.calibrator.calibrate(trades, DoubleArray.of((int)nNodes, q -> ((CdsQuote)quotes.get(q)).getQuotedValue()), DoubleArray.filled((int)nNodes), CurveName.of((String)"temp"), valuationDate, discountFactors, recoveryRates, refData);
        ImmutableCreditRatesProvider ratesProviderNew = ratesProvider.toImmutableCreditRatesProvider().toBuilder().creditCurves((Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>)ImmutableMap.of((Object)Pair.of((Object)legalEntityId, (Object)currency), (Object)LegalEntitySurvivalProbabilities.of(legalEntityId, IsdaCreditDiscountFactors.of(currency, valuationDate, creditCurve)))).build();
        Function<ResolvedCdsTrade, CdsQuote> quoteValueFunction = this.createQuoteValueFunction(ratesProviderNew, targetConvention, refData);
        ImmutableList result = trades.stream().map(c -> (CdsQuote)quoteValueFunction.apply((ResolvedCdsTrade)c)).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        return result;
    }

    private Function<ResolvedCdsTrade, CdsQuote> createQuoteValueFunction(final CreditRatesProvider ratesProviderNew, final CdsQuoteConvention targetConvention, final ReferenceData refData) {
        Function<ResolvedCdsTrade, CdsQuote> quoteValueFunction;
        if (targetConvention.equals((Object)CdsQuoteConvention.POINTS_UPFRONT)) {
            quoteValueFunction = new Function<ResolvedCdsTrade, CdsQuote>(){

                @Override
                public CdsQuote apply(ResolvedCdsTrade x) {
                    double puf = CdsMarketQuoteConverter.this.pointsUpfront(x, ratesProviderNew, refData);
                    return CdsQuote.of((CdsQuoteConvention)targetConvention, (double)puf);
                }
            };
        } else if (targetConvention.equals((Object)CdsQuoteConvention.QUOTED_SPREAD)) {
            quoteValueFunction = new Function<ResolvedCdsTrade, CdsQuote>(){

                @Override
                public CdsQuote apply(ResolvedCdsTrade x) {
                    double puf = CdsMarketQuoteConverter.this.pointsUpfront(x, ratesProviderNew, refData);
                    return CdsMarketQuoteConverter.this.quotedSpreadFromPointsUpfront(x, CdsQuote.of((CdsQuoteConvention)CdsQuoteConvention.POINTS_UPFRONT, (double)puf), ratesProviderNew, refData);
                }
            };
        } else {
            throw new IllegalArgumentException("unsuported CDS quote convention");
        }
        return quoteValueFunction;
    }
}

