/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.MarketDataView;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.ConstantNodalCurve;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.InterpolatedNodalCurve;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolators;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.credit.IsdaCreditDiscountFactors;
import java.time.LocalDate;

public interface CreditDiscountFactors
extends MarketDataView,
ParameterizedData {
    public static CreditDiscountFactors of(Currency currency, LocalDate valuationDate, Curve curve) {
        CurveMetadata metadata = curve.getMetadata();
        if (metadata.getXValueType().equals((Object)ValueType.YEAR_FRACTION) && metadata.getYValueType().equals((Object)ValueType.ZERO_RATE)) {
            if (curve instanceof ConstantNodalCurve) {
                ConstantNodalCurve constantCurve = (ConstantNodalCurve)curve;
                return IsdaCreditDiscountFactors.of(currency, valuationDate, (NodalCurve)constantCurve);
            }
            if (curve instanceof InterpolatedNodalCurve) {
                InterpolatedNodalCurve interpolatedCurve = (InterpolatedNodalCurve)curve;
                ArgChecker.isTrue((boolean)interpolatedCurve.getInterpolator().equals(CurveInterpolators.PRODUCT_LINEAR), (String)"Interpolator must be PRODUCT_LINEAR");
                ArgChecker.isTrue((boolean)interpolatedCurve.getExtrapolatorLeft().equals(CurveExtrapolators.FLAT), (String)"Left extrapolator must be FLAT");
                ArgChecker.isTrue((boolean)interpolatedCurve.getExtrapolatorRight().equals(CurveExtrapolators.PRODUCT_LINEAR), (String)"Right extrapolator must be PRODUCT_LINEAR");
                return IsdaCreditDiscountFactors.of(currency, valuationDate, (NodalCurve)interpolatedCurve);
            }
        }
        throw new IllegalArgumentException("Unknown curve type");
    }

    public Currency getCurrency();

    public DayCount getDayCount();

    public DiscountFactors toDiscountFactors();

    public DoubleArray getParameterKeys();

    public CreditDiscountFactors withParameter(int var1, double var2);

    public CreditDiscountFactors withPerturbation(ParameterPerturbation var1);

    default public boolean isIsdaCompliant() {
        return false;
    }

    public double relativeYearFraction(LocalDate var1);

    default public double discountFactor(LocalDate date) {
        double yearFraction = this.relativeYearFraction(date);
        return this.discountFactor(yearFraction);
    }

    public double discountFactor(double var1);

    default public double zeroRate(LocalDate date) {
        double yearFraction = this.relativeYearFraction(date);
        return this.zeroRate(yearFraction);
    }

    public double zeroRate(double var1);

    default public ZeroRateSensitivity zeroRatePointSensitivity(LocalDate date) {
        double yearFraction = this.relativeYearFraction(date);
        return this.zeroRatePointSensitivity(yearFraction);
    }

    default public ZeroRateSensitivity zeroRatePointSensitivity(double yearFraction) {
        return this.zeroRatePointSensitivity(yearFraction, this.getCurrency());
    }

    default public ZeroRateSensitivity zeroRatePointSensitivity(LocalDate date, Currency sensitivityCurrency) {
        double yearFraction = this.relativeYearFraction(date);
        return this.zeroRatePointSensitivity(yearFraction, sensitivityCurrency);
    }

    public ZeroRateSensitivity zeroRatePointSensitivity(double var1, Currency var3);

    public CurrencyParameterSensitivities parameterSensitivity(ZeroRateSensitivity var1);

    public CurrencyParameterSensitivities createParameterSensitivity(Currency var1, DoubleArray var2);
}

