/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import com.opengamma.strata.pricer.credit.ImmutableCreditRatesProvider;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.pricer.credit.RecoveryRates;
import java.time.LocalDate;
import java.util.Optional;

public interface CreditRatesProvider {
    public LocalDate getValuationDate();

    public LegalEntitySurvivalProbabilities survivalProbabilities(StandardId var1, Currency var2);

    public CreditDiscountFactors discountFactors(Currency var1);

    public RecoveryRates recoveryRates(StandardId var1);

    public CurrencyParameterSensitivities parameterSensitivity(PointSensitivities var1);

    public CurrencyParameterSensitivity singleCreditCurveParameterSensitivity(PointSensitivities var1, StandardId var2, Currency var3);

    public CurrencyParameterSensitivity singleDiscountCurveParameterSensitivity(PointSensitivities var1, Currency var2);

    public <T> Optional<T> findData(MarketDataName<T> var1);

    public ImmutableCreditRatesProvider toImmutableCreditRatesProvider();
}

