/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.opengamma.strata.collect.array.DoubleArray;
import java.util.Arrays;

public class DoublesScheduleGenerator {
    private static final double TOL = 0.0013698630136986301;

    public static DoubleArray getIntegrationsPoints(double start, double end, DoubleArray discountCurveNodes, DoubleArray creditCurveNodes) {
        double[] set1 = DoublesScheduleGenerator.truncateSetExclusive(start, end, discountCurveNodes.toArray());
        double[] set2 = DoublesScheduleGenerator.truncateSetExclusive(start, end, creditCurveNodes.toArray());
        int n1 = set1.length;
        int n2 = set2.length;
        int n = n1 + n2;
        double[] set = new double[n];
        System.arraycopy(set1, 0, set, 0, n1);
        System.arraycopy(set2, 0, set, n1, n2);
        Arrays.sort(set);
        double[] temp = new double[n + 2];
        temp[0] = start;
        int pos = 0;
        for (int i = 0; i < n; ++i) {
            if (!DoublesScheduleGenerator.different(temp[pos], set[i])) continue;
            temp[++pos] = set[i];
        }
        if (DoublesScheduleGenerator.different(temp[pos], end)) {
            ++pos;
        }
        temp[pos] = end;
        int resLength = pos + 1;
        return DoubleArray.copyOf((double[])temp, (int)0, (int)resLength);
    }

    private static boolean different(double a, double b) {
        return Math.abs(a - b) > 0.0013698630136986301;
    }

    private static double[] truncateSetExclusive(double lower, double upper, double[] set) {
        int temp;
        int lIndex;
        int n = set.length;
        if (upper < set[0] || lower > set[n - 1]) {
            return new double[0];
        }
        if (lower < set[0]) {
            lIndex = 0;
        } else {
            int temp2 = Arrays.binarySearch(set, lower);
            int n2 = lIndex = temp2 >= 0 ? temp2 + 1 : -(temp2 + 1);
        }
        int uIndex = upper > set[n - 1] ? n : ((temp = Arrays.binarySearch(set, lIndex, n, upper)) >= 0 ? temp : -(temp + 1));
        int m = uIndex - lIndex;
        if (m == n) {
            return set;
        }
        double[] trunc = new double[m];
        System.arraycopy(set, lIndex, trunc, 0, m);
        return trunc;
    }

    public static DoubleArray truncateSetInclusive(double lower, double upper, DoubleArray set) {
        double[] temp = DoublesScheduleGenerator.truncateSetExclusive(lower, upper, set.toArray());
        int n = temp.length;
        if (n == 0) {
            return DoubleArray.of((double)lower, (double)upper);
        }
        boolean addLower = DoublesScheduleGenerator.different(lower, temp[0]);
        boolean addUpper = DoublesScheduleGenerator.different(upper, temp[n - 1]);
        if (!addLower && !addUpper) {
            temp[0] = lower;
            temp[n - 1] = upper;
            return DoubleArray.ofUnsafe((double[])temp);
        }
        int m = n + (addLower ? 1 : 0) + (addUpper ? 1 : 0);
        double[] res = new double[m];
        System.arraycopy(temp, 0, res, addLower ? 1 : 0, n);
        res[0] = lower;
        res[m - 1] = upper;
        return DoubleArray.ofUnsafe((double[])res);
    }

    private DoublesScheduleGenerator() {
    }
}

