/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.ConstantNodalCurve;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.DefaultCurveMetadata;
import com.opengamma.strata.market.curve.InterpolatedNodalCurve;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolators;
import com.opengamma.strata.math.MathException;
import com.opengamma.strata.math.impl.rootfinding.BracketRoot;
import com.opengamma.strata.math.impl.rootfinding.BrentSingleRootFinder;
import com.opengamma.strata.math.impl.rootfinding.RealSingleRootFinder;
import com.opengamma.strata.math.impl.util.Epsilon;
import com.opengamma.strata.pricer.common.PriceType;
import com.opengamma.strata.pricer.credit.AccrualOnDefaultFormula;
import com.opengamma.strata.pricer.credit.ArbitrageHandling;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import com.opengamma.strata.pricer.credit.DoublesScheduleGenerator;
import com.opengamma.strata.pricer.credit.IsdaCompliantCreditCurveCalibrator;
import com.opengamma.strata.pricer.credit.RecoveryRates;
import com.opengamma.strata.product.credit.CreditCouponPaymentPeriod;
import com.opengamma.strata.product.credit.ResolvedCds;
import com.opengamma.strata.product.credit.ResolvedCdsTrade;
import java.time.LocalDate;
import java.util.List;
import java.util.function.Function;

public final class FastCreditCurveCalibrator
extends IsdaCompliantCreditCurveCalibrator {
    private static final FastCreditCurveCalibrator STANDARD = new FastCreditCurveCalibrator();
    private static final BracketRoot BRACKETER = new BracketRoot();
    private static final RealSingleRootFinder ROOTFINDER = new BrentSingleRootFinder();
    private static final double MAX_RT = 37.0;

    public static FastCreditCurveCalibrator standard() {
        return STANDARD;
    }

    private FastCreditCurveCalibrator() {
    }

    public FastCreditCurveCalibrator(AccrualOnDefaultFormula formula) {
        super(formula);
    }

    public FastCreditCurveCalibrator(AccrualOnDefaultFormula formula, ArbitrageHandling arbHandling) {
        super(formula, arbHandling);
    }

    @Override
    public NodalCurve calibrate(List<ResolvedCdsTrade> calibrationCDSs, DoubleArray flactionalSpreads, DoubleArray pointsUpfront, CurveName name, LocalDate valuationDate, CreditDiscountFactors discountFactors, RecoveryRates recoveryRates, ReferenceData refData) {
        int n = calibrationCDSs.size();
        double[] guess = new double[n];
        double[] t = new double[n];
        double[] lgd = new double[n];
        for (int i = 0; i < n; ++i) {
            LocalDate endDate = calibrationCDSs.get(i).getProduct().getProtectionEndDate();
            t[i] = discountFactors.relativeYearFraction(endDate);
            lgd[i] = 1.0 - recoveryRates.recoveryRate(endDate);
            guess[i] = (flactionalSpreads.get(i) + pointsUpfront.get(i) / t[i]) / lgd[i];
        }
        DoubleArray times = DoubleArray.ofUnsafe((double[])t);
        DefaultCurveMetadata baseMetadata = DefaultCurveMetadata.builder().xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.ZERO_RATE).curveName(name).dayCount(discountFactors.getDayCount()).build();
        ConstantNodalCurve creditCurve = n == 1 ? ConstantNodalCurve.of((CurveMetadata)baseMetadata, (double)t[0], (double)guess[0]) : InterpolatedNodalCurve.of((CurveMetadata)baseMetadata, (DoubleArray)times, (DoubleArray)DoubleArray.ofUnsafe((double[])guess), (CurveInterpolator)CurveInterpolators.PRODUCT_LINEAR, (CurveExtrapolator)CurveExtrapolators.FLAT, (CurveExtrapolator)CurveExtrapolators.PRODUCT_LINEAR);
        block8: for (int i = 0; i < n; ++i) {
            ResolvedCds cds = calibrationCDSs.get(i).getProduct();
            LocalDate stepinDate = cds.getStepinDateOffset().adjust(valuationDate, refData);
            LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
            LocalDate settlementDate = calibrationCDSs.get(i).getInfo().getSettlementDate().orElse(cds.getSettlementDateOffset().adjust(valuationDate, refData));
            double accrued = cds.accruedYearFraction(stepinDate);
            Pricer pricer = new Pricer(cds, discountFactors, times, flactionalSpreads.get(i), pointsUpfront.get(i), lgd[i], stepinDate, effectiveStartDate, settlementDate, accrued);
            Function<Double, Double> func = pricer.getPointFunction(i, (NodalCurve)creditCurve);
            switch (this.getArbitrageHandling()) {
                case IGNORE: {
                    try {
                        double[] bracket = BRACKETER.getBracketedPoints(func, 0.8 * guess[i], 1.25 * guess[i], Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                        double zeroRate = bracket[0] > bracket[1] ? ROOTFINDER.getRoot(func, Double.valueOf(bracket[1]), Double.valueOf(bracket[0])) : ROOTFINDER.getRoot(func, Double.valueOf(bracket[0]), Double.valueOf(bracket[1]));
                        creditCurve = creditCurve.withParameter(i, zeroRate);
                        continue block8;
                    }
                    catch (MathException e) {
                        if (Math.abs(func.apply(creditCurve.getYValues().get(i - 1))) < 1.0E-12) {
                            creditCurve = creditCurve.withParameter(i, creditCurve.getYValues().get(i - 1));
                            continue block8;
                        }
                        if (func.apply(37.0 / times.get(i)) < -1.0E-12) {
                            creditCurve = creditCurve.withParameter(i, 37.0 / times.get(i));
                            continue block8;
                        }
                        throw new MathException((Throwable)e);
                    }
                }
                case FAIL: {
                    double minValue;
                    double d = minValue = i == 0 ? 0.0 : creditCurve.getYValues().get(i - 1) * creditCurve.getXValues().get(i - 1) / creditCurve.getXValues().get(i);
                    if (i > 0 && func.apply(minValue) > 0.0) {
                        StringBuilder msg = new StringBuilder();
                        if (pointsUpfront.get(i) == 0.0) {
                            msg.append("The par spread of " + flactionalSpreads.get(i) + " at index " + i);
                        } else {
                            msg.append("The premium of " + flactionalSpreads.get(i) + "and points up-front of " + pointsUpfront.get(i) + " at index " + i);
                        }
                        msg.append(" is an arbitrage; cannot fit a curve with positive forward hazard rate. ");
                        throw new IllegalArgumentException(msg.toString());
                    }
                    guess[i] = Math.max(minValue, guess[i]);
                    double[] bracket = BRACKETER.getBracketedPoints(func, guess[i], 1.2 * guess[i], minValue, Double.POSITIVE_INFINITY);
                    double zeroRate = ROOTFINDER.getRoot(func, Double.valueOf(bracket[0]), Double.valueOf(bracket[1]));
                    creditCurve = creditCurve.withParameter(i, zeroRate);
                    continue block8;
                }
                case ZERO_HAZARD_RATE: {
                    double minValue;
                    double d = minValue = i == 0 ? 0.0 : creditCurve.getYValues().get(i - 1) * creditCurve.getXValues().get(i - 1) / creditCurve.getXValues().get(i);
                    if (i > 0 && func.apply(minValue) > 0.0) {
                        creditCurve = creditCurve.withParameter(i, minValue);
                        continue block8;
                    }
                    guess[i] = Math.max(minValue, guess[i]);
                    double[] bracket = BRACKETER.getBracketedPoints(func, guess[i], 1.2 * guess[i], minValue, Double.POSITIVE_INFINITY);
                    double zeroRate = ROOTFINDER.getRoot(func, Double.valueOf(bracket[0]), Double.valueOf(bracket[1]));
                    creditCurve = creditCurve.withParameter(i, zeroRate);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("unknown case " + (Object)((Object)this.getArbitrageHandling()));
                }
            }
        }
        return creditCurve;
    }

    final class Pricer {
        private final ResolvedCds cds;
        private final double lgdDF;
        private final double valuationDF;
        private final double fracSpread;
        private final double puf;
        private final int nProPoints;
        private final double[] proLegIntPoints;
        private final double[] proYieldCurveRT;
        private final double[] proDF;
        private final int nPayments;
        private final double[] paymentDF;
        private final double[][] premLegIntPoints;
        private final double[][] premDF;
        private final double[][] rt;
        private final double[][] premDt;
        private final double[] accRate;
        private final double[] offsetAccStart;
        private final double[] offsetAccEnd;
        private final double accYearFraction;
        private final double productEffectiveStart;
        private final int startPeriodIndex;

        public Pricer(ResolvedCds nodeCds, CreditDiscountFactors yieldCurve, DoubleArray creditCurveKnots, double fractionalSpread, double pointsUpfront, double lgd, LocalDate stepinDate, LocalDate effectiveStartDate, LocalDate settlementDate, double accruedYearFraction) {
            this.accYearFraction = accruedYearFraction;
            this.cds = nodeCds;
            this.fracSpread = fractionalSpread;
            this.puf = pointsUpfront;
            this.productEffectiveStart = yieldCurve.relativeYearFraction(effectiveStartDate);
            double protectionEnd = yieldCurve.relativeYearFraction(this.cds.getProtectionEndDate());
            this.proLegIntPoints = DoublesScheduleGenerator.getIntegrationsPoints(this.productEffectiveStart, protectionEnd, yieldCurve.getParameterKeys(), creditCurveKnots).toArray();
            this.nProPoints = this.proLegIntPoints.length;
            this.valuationDF = yieldCurve.discountFactor(settlementDate);
            this.lgdDF = lgd / this.valuationDF;
            this.proYieldCurveRT = new double[this.nProPoints];
            this.proDF = new double[this.nProPoints];
            for (int i = 0; i < this.nProPoints; ++i) {
                this.proYieldCurveRT[i] = yieldCurve.zeroRate(this.proLegIntPoints[i]) * this.proLegIntPoints[i];
                this.proDF[i] = Math.exp(-this.proYieldCurveRT[i]);
            }
            this.nPayments = this.cds.getPaymentPeriods().size();
            this.paymentDF = new double[this.nPayments];
            int indexTmp = -1;
            for (int i = 0; i < this.nPayments; ++i) {
                if (stepinDate.isBefore(((CreditCouponPaymentPeriod)this.cds.getPaymentPeriods().get(i)).getEndDate())) {
                    this.paymentDF[i] = yieldCurve.discountFactor(((CreditCouponPaymentPeriod)this.cds.getPaymentPeriods().get(i)).getPaymentDate());
                    continue;
                }
                indexTmp = i;
            }
            this.startPeriodIndex = indexTmp + 1;
            if (this.cds.getPaymentOnDefault().isAccruedInterest()) {
                LocalDate tmp = this.nPayments == 1 ? effectiveStartDate : this.cds.getAccrualStartDate();
                DoubleArray integrationSchedule = DoublesScheduleGenerator.getIntegrationsPoints(yieldCurve.relativeYearFraction(tmp), protectionEnd, yieldCurve.getParameterKeys(), creditCurveKnots);
                this.accRate = new double[this.nPayments];
                this.offsetAccStart = new double[this.nPayments];
                this.offsetAccEnd = new double[this.nPayments];
                this.premLegIntPoints = new double[this.nPayments][];
                this.premDF = new double[this.nPayments][];
                this.rt = new double[this.nPayments][];
                this.premDt = new double[this.nPayments][];
                for (int i = this.startPeriodIndex; i < this.nPayments; ++i) {
                    int k;
                    CreditCouponPaymentPeriod coupon = (CreditCouponPaymentPeriod)this.cds.getPaymentPeriods().get(i);
                    this.offsetAccStart[i] = yieldCurve.relativeYearFraction(coupon.getEffectiveStartDate());
                    this.offsetAccEnd[i] = yieldCurve.relativeYearFraction(coupon.getEffectiveEndDate());
                    this.accRate[i] = coupon.getYearFraction() / yieldCurve.getDayCount().relativeYearFraction(coupon.getStartDate(), coupon.getEndDate());
                    double start = Math.max(this.productEffectiveStart, this.offsetAccStart[i]);
                    if (start >= this.offsetAccEnd[i]) continue;
                    this.premLegIntPoints[i] = DoublesScheduleGenerator.truncateSetInclusive(start, this.offsetAccEnd[i], integrationSchedule).toArray();
                    int n = this.premLegIntPoints[i].length;
                    this.rt[i] = new double[n];
                    this.premDF[i] = new double[n];
                    for (k = 0; k < n; ++k) {
                        this.rt[i][k] = yieldCurve.zeroRate(this.premLegIntPoints[i][k]) * this.premLegIntPoints[i][k];
                        this.premDF[i][k] = Math.exp(-this.rt[i][k]);
                    }
                    this.premDt[i] = new double[n - 1];
                    for (k = 1; k < n; ++k) {
                        double dt;
                        this.premDt[i][k - 1] = dt = this.premLegIntPoints[i][k] - this.premLegIntPoints[i][k - 1];
                    }
                }
            } else {
                this.accRate = null;
                this.offsetAccStart = null;
                this.offsetAccEnd = null;
                this.premDF = null;
                this.premDt = null;
                this.rt = null;
                this.premLegIntPoints = null;
            }
        }

        public Function<Double, Double> getPointFunction(final int index, final NodalCurve creditCurve) {
            return new Function<Double, Double>(){

                @Override
                public Double apply(Double x) {
                    NodalCurve cc = creditCurve.withParameter(index, x.doubleValue());
                    double rpv01 = Pricer.this.rpv01(cc, PriceType.CLEAN);
                    double pro = Pricer.this.protectionLeg(cc);
                    return pro - Pricer.this.fracSpread * rpv01 - Pricer.this.puf;
                }
            };
        }

        public double rpv01(NodalCurve creditCurve, PriceType cleanOrDirty) {
            double pv = 0.0;
            for (int i = this.startPeriodIndex; i < this.nPayments; ++i) {
                CreditCouponPaymentPeriod coupon = (CreditCouponPaymentPeriod)this.cds.getPaymentPeriods().get(i);
                double yc = this.offsetAccEnd[i];
                double q = Math.exp(-creditCurve.yValue(yc) * yc);
                pv += coupon.getYearFraction() * this.paymentDF[i] * q;
            }
            if (this.cds.getPaymentOnDefault().isAccruedInterest()) {
                double accPV = 0.0;
                for (int i = this.startPeriodIndex; i < this.nPayments; ++i) {
                    accPV += this.calculateSinglePeriodAccrualOnDefault(i, creditCurve);
                }
                pv += accPV;
            }
            pv /= this.valuationDF;
            if (cleanOrDirty == PriceType.CLEAN) {
                pv -= this.accYearFraction;
            }
            return pv;
        }

        private double calculateSinglePeriodAccrualOnDefault(int paymentIndex, NodalCurve creditCurve) {
            double[] knots = this.premLegIntPoints[paymentIndex];
            if (knots == null) {
                return 0.0;
            }
            double[] df = this.premDF[paymentIndex];
            double[] deltaT = this.premDt[paymentIndex];
            double[] rtCurrent = this.rt[paymentIndex];
            double accRateCurrent = this.accRate[paymentIndex];
            double accStart = this.offsetAccStart[paymentIndex];
            double t = knots[0];
            double ht0 = creditCurve.yValue(t) * t;
            double rt0 = rtCurrent[0];
            double b0 = df[0] * Math.exp(-ht0);
            double t0 = t - accStart + FastCreditCurveCalibrator.this.getAccrualOnDefaultFormula().getOmega();
            double pv = 0.0;
            int nItems = knots.length;
            for (int j = 1; j < nItems; ++j) {
                double tPV;
                t = knots[j];
                double ht1 = creditCurve.yValue(t) * t;
                double rt1 = rtCurrent[j];
                double b1 = df[j] * Math.exp(-ht1);
                double dt = deltaT[j - 1];
                double dht = ht1 - ht0;
                double drt = rt1 - rt0;
                double dhrt = dht + drt + 1.0E-50;
                if (FastCreditCurveCalibrator.this.getAccrualOnDefaultFormula() == AccrualOnDefaultFormula.MARKIT_FIX) {
                    tPV = Math.abs(dhrt) < 1.0E-5 ? dht * dt * b0 * Epsilon.epsilonP((double)(-dhrt)) : dht * dt / dhrt * ((b0 - b1) / dhrt - b1);
                } else {
                    double t1 = t - accStart + FastCreditCurveCalibrator.this.getAccrualOnDefaultFormula().getOmega();
                    tPV = Math.abs(dhrt) < 1.0E-5 ? dht * b0 * (t0 * Epsilon.epsilon((double)(-dhrt)) + dt * Epsilon.epsilonP((double)(-dhrt))) : dht / dhrt * (t0 * b0 - t1 * b1 + dt / dhrt * (b0 - b1));
                    t0 = t1;
                }
                pv += tPV;
                ht0 = ht1;
                rt0 = rt1;
                b0 = b1;
            }
            return accRateCurrent * pv;
        }

        public double protectionLeg(NodalCurve creditCurve) {
            double ht0 = creditCurve.yValue(this.proLegIntPoints[0]) * this.proLegIntPoints[0];
            double rt0 = this.proYieldCurveRT[0];
            double b0 = this.proDF[0] * Math.exp(-ht0);
            double pv = 0.0;
            for (int i = 1; i < this.nProPoints; ++i) {
                double ht1 = creditCurve.yValue(this.proLegIntPoints[i]) * this.proLegIntPoints[i];
                double rt1 = this.proYieldCurveRT[i];
                double b1 = this.proDF[i] * Math.exp(-ht1);
                double dht = ht1 - ht0;
                double drt = rt1 - rt0;
                double dhrt = dht + drt;
                double dPV = Math.abs(dhrt) < 1.0E-5 ? dht * b0 * Epsilon.epsilon((double)(-dhrt)) : (b0 - b1) * dht / dhrt;
                pv += dPV;
                ht0 = ht1;
                rt0 = rt1;
                b0 = b1;
            }
            return pv *= this.lgdDF;
        }
    }
}

