/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.math.impl.util.Epsilon;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.common.PriceType;
import com.opengamma.strata.pricer.credit.AccrualOnDefaultFormula;
import com.opengamma.strata.pricer.credit.ConstantRecoveryRates;
import com.opengamma.strata.pricer.credit.CreditCurveZeroRateSensitivity;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.DoublesScheduleGenerator;
import com.opengamma.strata.pricer.credit.JumpToDefault;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.pricer.credit.RecoveryRates;
import com.opengamma.strata.product.credit.CreditCouponPaymentPeriod;
import com.opengamma.strata.product.credit.ResolvedCds;
import java.time.LocalDate;
import java.util.Map;

public class IsdaCdsProductPricer {
    public static final IsdaCdsProductPricer DEFAULT = new IsdaCdsProductPricer(AccrualOnDefaultFormula.ORIGINAL_ISDA);
    private static final double SMALL = 1.0E-5;
    private final AccrualOnDefaultFormula formula;
    private final double omega;

    public IsdaCdsProductPricer(AccrualOnDefaultFormula formula) {
        this.formula = (AccrualOnDefaultFormula)((Object)ArgChecker.notNull((Object)((Object)formula), (String)"formula"));
        this.omega = formula.getOmega();
    }

    public AccrualOnDefaultFormula getAccrualOnDefaultFormula() {
        return this.formula;
    }

    public double price(ResolvedCds cds, CreditRatesProvider ratesProvider, LocalDate referenceDate, PriceType priceType, ReferenceData refData) {
        return this.price(cds, ratesProvider, cds.getFixedRate(), referenceDate, priceType, refData);
    }

    double price(ResolvedCds cds, CreditRatesProvider ratesProvider, double fractionalSpread, LocalDate referenceDate, PriceType priceType, ReferenceData refData) {
        if (!cds.getProtectionEndDate().isAfter(ratesProvider.getValuationDate())) {
            return 0.0;
        }
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        double recoveryRate = this.recoveryRate(cds, ratesProvider);
        Pair<CreditDiscountFactors, LegalEntitySurvivalProbabilities> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double protectionLeg = this.protectionLeg(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate, recoveryRate);
        double rpv01 = this.riskyAnnuity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate, priceType);
        return protectionLeg - rpv01 * fractionalSpread;
    }

    public PointSensitivityBuilder priceSensitivity(ResolvedCds cds, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        if (this.isExpired(cds, ratesProvider)) {
            return PointSensitivityBuilder.none();
        }
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        double recoveryRate = this.recoveryRate(cds, ratesProvider);
        Pair<CreditDiscountFactors, LegalEntitySurvivalProbabilities> rates = this.reduceDiscountFactors(cds, ratesProvider);
        PointSensitivityBuilder protectionLegSensi = this.protectionLegSensitivity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate, recoveryRate);
        PointSensitivityBuilder riskyAnnuitySensi = this.riskyAnnuitySensitivity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate).multipliedBy(-cds.getFixedRate());
        return protectionLegSensi.combinedWith(riskyAnnuitySensi);
    }

    public CurrencyAmount presentValue(ResolvedCds cds, CreditRatesProvider ratesProvider, LocalDate referenceDate, PriceType priceType, ReferenceData refData) {
        double price = this.price(cds, ratesProvider, referenceDate, priceType, refData);
        return CurrencyAmount.of((Currency)cds.getCurrency(), (double)(cds.getBuySell().normalize(cds.getNotional()) * price));
    }

    public PointSensitivityBuilder presentValueSensitivity(ResolvedCds cds, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        if (this.isExpired(cds, ratesProvider)) {
            return PointSensitivityBuilder.none();
        }
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        double recoveryRate = this.recoveryRate(cds, ratesProvider);
        Pair<CreditDiscountFactors, LegalEntitySurvivalProbabilities> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double signedNotional = cds.getBuySell().normalize(cds.getNotional());
        PointSensitivityBuilder protectionLegSensi = this.protectionLegSensitivity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate, recoveryRate).multipliedBy(signedNotional);
        PointSensitivityBuilder riskyAnnuitySensi = this.riskyAnnuitySensitivity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate).multipliedBy(-cds.getFixedRate() * signedNotional);
        return protectionLegSensi.combinedWith(riskyAnnuitySensi);
    }

    public double parSpread(ResolvedCds cds, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        ArgChecker.isTrue((boolean)cds.getProtectionEndDate().isAfter(ratesProvider.getValuationDate()), (String)"CDS already expired");
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        double recoveryRate = this.recoveryRate(cds, ratesProvider);
        Pair<CreditDiscountFactors, LegalEntitySurvivalProbabilities> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double protectionLeg = this.protectionLeg(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate, recoveryRate);
        double riskyAnnuity = this.riskyAnnuity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate, PriceType.CLEAN);
        return protectionLeg / riskyAnnuity;
    }

    public PointSensitivityBuilder parSpreadSensitivity(ResolvedCds cds, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        ArgChecker.isTrue((boolean)cds.getProtectionEndDate().isAfter(ratesProvider.getValuationDate()), (String)"CDS already expired");
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        double recoveryRate = this.recoveryRate(cds, ratesProvider);
        Pair<CreditDiscountFactors, LegalEntitySurvivalProbabilities> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double protectionLeg = this.protectionLeg(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate, recoveryRate);
        double riskyAnnuityInv = 1.0 / this.riskyAnnuity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate, PriceType.CLEAN);
        PointSensitivityBuilder protectionLegSensi = this.protectionLegSensitivity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate, recoveryRate).multipliedBy(riskyAnnuityInv);
        PointSensitivityBuilder riskyAnnuitySensi = this.riskyAnnuitySensitivity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate).multipliedBy(-protectionLeg * riskyAnnuityInv * riskyAnnuityInv);
        return protectionLegSensi.combinedWith(riskyAnnuitySensi);
    }

    public double protectionLeg(ResolvedCds cds, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        if (this.isExpired(cds, ratesProvider)) {
            return 0.0;
        }
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        double recoveryRate = this.recoveryRate(cds, ratesProvider);
        Pair<CreditDiscountFactors, LegalEntitySurvivalProbabilities> rates = this.reduceDiscountFactors(cds, ratesProvider);
        return this.protectionLeg(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate, recoveryRate);
    }

    public double riskyAnnuity(ResolvedCds cds, CreditRatesProvider ratesProvider, LocalDate referenceDate, PriceType priceType, ReferenceData refData) {
        if (this.isExpired(cds, ratesProvider)) {
            return 0.0;
        }
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        Pair<CreditDiscountFactors, LegalEntitySurvivalProbabilities> rates = this.reduceDiscountFactors(cds, ratesProvider);
        return this.riskyAnnuity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate, priceType);
    }

    public PointSensitivityBuilder riskyAnnuitySensitivity(ResolvedCds cds, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        if (this.isExpired(cds, ratesProvider)) {
            return PointSensitivityBuilder.none();
        }
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        Pair<CreditDiscountFactors, LegalEntitySurvivalProbabilities> rates = this.reduceDiscountFactors(cds, ratesProvider);
        return this.riskyAnnuitySensitivity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate);
    }

    public CurrencyAmount rpv01(ResolvedCds cds, CreditRatesProvider ratesProvider, LocalDate referenceDate, PriceType priceType, ReferenceData refData) {
        double riskyAnnuity = this.riskyAnnuity(cds, ratesProvider, referenceDate, priceType, refData);
        return CurrencyAmount.of((Currency)cds.getCurrency(), (double)(cds.getBuySell().normalize(cds.getNotional()) * riskyAnnuity));
    }

    public CurrencyAmount recovery01(ResolvedCds cds, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        if (this.isExpired(cds, ratesProvider)) {
            return CurrencyAmount.of((Currency)cds.getCurrency(), (double)0.0);
        }
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        this.validateRecoveryRates(cds, ratesProvider);
        Pair<CreditDiscountFactors, LegalEntitySurvivalProbabilities> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double protectionFull = this.protectionFull(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate);
        return CurrencyAmount.of((Currency)cds.getCurrency(), (double)(-cds.getBuySell().normalize(cds.getNotional()) * protectionFull));
    }

    public JumpToDefault jumpToDefault(ResolvedCds cds, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        StandardId legalEntityId = cds.getLegalEntityId();
        Currency currency = cds.getCurrency();
        if (this.isExpired(cds, ratesProvider)) {
            return JumpToDefault.of(currency, (Map<StandardId, Double>)ImmutableMap.of((Object)legalEntityId, (Object)0.0));
        }
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        double recoveryRate = this.recoveryRate(cds, ratesProvider);
        Pair<CreditDiscountFactors, LegalEntitySurvivalProbabilities> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double protectionFull = this.protectionFull(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate);
        double lgd = 1.0 - recoveryRate;
        double rpv01 = this.riskyAnnuity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate, PriceType.CLEAN);
        double jtd = lgd - (lgd * protectionFull - cds.getFixedRate() * rpv01);
        return JumpToDefault.of(currency, (Map<StandardId, Double>)ImmutableMap.of((Object)legalEntityId, (Object)(cds.getBuySell().normalize(cds.getNotional()) * jtd)));
    }

    public CurrencyAmount expectedLoss(ResolvedCds cds, CreditRatesProvider ratesProvider) {
        if (this.isExpired(cds, ratesProvider)) {
            return CurrencyAmount.of((Currency)cds.getCurrency(), (double)0.0);
        }
        double recoveryRate = this.recoveryRate(cds, ratesProvider);
        Pair<CreditDiscountFactors, LegalEntitySurvivalProbabilities> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double survivalProbability = ((LegalEntitySurvivalProbabilities)rates.getSecond()).survivalProbability(cds.getProtectionEndDate());
        double el = (1.0 - recoveryRate) * (1.0 - survivalProbability);
        return CurrencyAmount.of((Currency)cds.getCurrency(), (double)(Math.abs(cds.getNotional()) * el));
    }

    private double protectionLeg(ResolvedCds cds, CreditDiscountFactors discountFactors, LegalEntitySurvivalProbabilities survivalProbabilities, LocalDate referenceDate, LocalDate effectiveStartDate, double recoveryRate) {
        double protectionFull = this.protectionFull(cds, discountFactors, survivalProbabilities, referenceDate, effectiveStartDate);
        return (1.0 - recoveryRate) * protectionFull;
    }

    double protectionFull(ResolvedCds cds, CreditDiscountFactors discountFactors, LegalEntitySurvivalProbabilities survivalProbabilities, LocalDate referenceDate, LocalDate effectiveStartDate) {
        DoubleArray integrationSchedule = DoublesScheduleGenerator.getIntegrationsPoints(discountFactors.relativeYearFraction(effectiveStartDate), discountFactors.relativeYearFraction(cds.getProtectionEndDate()), discountFactors.getParameterKeys(), survivalProbabilities.getParameterKeys());
        double pv = 0.0;
        double ht0 = survivalProbabilities.zeroRate(integrationSchedule.get(0)) * integrationSchedule.get(0);
        double rt0 = discountFactors.zeroRate(integrationSchedule.get(0)) * integrationSchedule.get(0);
        double b0 = Math.exp(-ht0 - rt0);
        int n = integrationSchedule.size();
        for (int i = 1; i < n; ++i) {
            double ht1 = survivalProbabilities.zeroRate(integrationSchedule.get(i)) * integrationSchedule.get(i);
            double rt1 = discountFactors.zeroRate(integrationSchedule.get(i)) * integrationSchedule.get(i);
            double b1 = Math.exp(-ht1 - rt1);
            double dht = ht1 - ht0;
            double drt = rt1 - rt0;
            double dhrt = dht + drt;
            double dPV = 0.0;
            dPV = Math.abs(dhrt) < 1.0E-5 ? dht * b0 * Epsilon.epsilon((double)(-dhrt)) : (b0 - b1) * dht / dhrt;
            pv += dPV;
            ht0 = ht1;
            rt0 = rt1;
            b0 = b1;
        }
        double df = discountFactors.discountFactor(referenceDate);
        return pv / df;
    }

    double riskyAnnuity(ResolvedCds cds, CreditDiscountFactors discountFactors, LegalEntitySurvivalProbabilities survivalProbabilities, LocalDate referenceDate, LocalDate stepinDate, LocalDate effectiveStartDate, PriceType priceType) {
        double pv = 0.0;
        for (CreditCouponPaymentPeriod coupon : cds.getPaymentPeriods()) {
            if (!stepinDate.isBefore(coupon.getEndDate())) continue;
            double q = survivalProbabilities.survivalProbability(coupon.getEffectiveEndDate());
            double p = discountFactors.discountFactor(coupon.getPaymentDate());
            pv += coupon.getYearFraction() * p * q;
        }
        if (cds.getPaymentOnDefault().isAccruedInterest()) {
            LocalDate start = cds.getPaymentPeriods().size() == 1 ? effectiveStartDate : cds.getAccrualStartDate();
            DoubleArray integrationSchedule = DoublesScheduleGenerator.getIntegrationsPoints(discountFactors.relativeYearFraction(start), discountFactors.relativeYearFraction(cds.getProtectionEndDate()), discountFactors.getParameterKeys(), survivalProbabilities.getParameterKeys());
            for (CreditCouponPaymentPeriod coupon : cds.getPaymentPeriods()) {
                pv += this.singlePeriodAccrualOnDefault(coupon, effectiveStartDate, integrationSchedule, discountFactors, survivalProbabilities);
            }
        }
        double df = discountFactors.discountFactor(referenceDate);
        pv /= df;
        if (priceType.isCleanPrice()) {
            pv -= cds.accruedYearFraction(stepinDate);
        }
        return pv;
    }

    private double singlePeriodAccrualOnDefault(CreditCouponPaymentPeriod coupon, LocalDate effectiveStartDate, DoubleArray integrationSchedule, CreditDiscountFactors discountFactors, LegalEntitySurvivalProbabilities survivalProbabilities) {
        LocalDate start;
        LocalDate localDate = start = coupon.getEffectiveStartDate().isBefore(effectiveStartDate) ? effectiveStartDate : coupon.getEffectiveStartDate();
        if (!start.isBefore(coupon.getEffectiveEndDate())) {
            return 0.0;
        }
        DoubleArray knots = DoublesScheduleGenerator.truncateSetInclusive(discountFactors.relativeYearFraction(start), discountFactors.relativeYearFraction(coupon.getEffectiveEndDate()), integrationSchedule);
        double t0Knot = knots.get(0);
        double ht0 = survivalProbabilities.zeroRate(t0Knot) * t0Knot;
        double rt0 = discountFactors.zeroRate(t0Knot) * t0Knot;
        double b0 = Math.exp(-rt0 - ht0);
        double effStart = discountFactors.relativeYearFraction(coupon.getEffectiveStartDate());
        double t0 = t0Knot - effStart + this.omega;
        double pv = 0.0;
        int nItems = knots.size();
        for (int j = 1; j < nItems; ++j) {
            double tPV;
            double t = knots.get(j);
            double ht1 = survivalProbabilities.zeroRate(t) * t;
            double rt1 = discountFactors.zeroRate(t) * t;
            double b1 = Math.exp(-rt1 - ht1);
            double dt = knots.get(j) - knots.get(j - 1);
            double dht = ht1 - ht0;
            double drt = rt1 - rt0;
            double dhrt = dht + drt;
            if (this.formula == AccrualOnDefaultFormula.MARKIT_FIX) {
                tPV = Math.abs(dhrt) < 1.0E-5 ? dht * dt * b0 * Epsilon.epsilonP((double)(-dhrt)) : dht * dt / dhrt * ((b0 - b1) / dhrt - b1);
            } else {
                double t1 = t - effStart + this.omega;
                tPV = Math.abs(dhrt) < 1.0E-5 ? dht * b0 * (t0 * Epsilon.epsilon((double)(-dhrt)) + dt * Epsilon.epsilonP((double)(-dhrt))) : dht / dhrt * (t0 * b0 - t1 * b1 + dt / dhrt * (b0 - b1));
                t0 = t1;
            }
            pv += tPV;
            ht0 = ht1;
            rt0 = rt1;
            b0 = b1;
        }
        double yearFractionCurve = discountFactors.getDayCount().relativeYearFraction(coupon.getStartDate(), coupon.getEndDate());
        return coupon.getYearFraction() * pv / yearFractionCurve;
    }

    PointSensitivityBuilder protectionLegSensitivity(ResolvedCds cds, CreditDiscountFactors discountFactors, LegalEntitySurvivalProbabilities survivalProbabilities, LocalDate referenceDate, LocalDate effectiveStartDate, double recoveryRate) {
        DoubleArray integrationSchedule = DoublesScheduleGenerator.getIntegrationsPoints(discountFactors.relativeYearFraction(effectiveStartDate), discountFactors.relativeYearFraction(cds.getProtectionEndDate()), discountFactors.getParameterKeys(), survivalProbabilities.getParameterKeys());
        int n = integrationSchedule.size();
        double[] dht = new double[n - 1];
        double[] drt = new double[n - 1];
        double[] dhrt = new double[n - 1];
        double[] p = new double[n];
        double[] q = new double[n];
        double pv = 0.0;
        double ht0 = survivalProbabilities.zeroRate(integrationSchedule.get(0)) * integrationSchedule.get(0);
        double rt0 = discountFactors.zeroRate(integrationSchedule.get(0)) * integrationSchedule.get(0);
        p[0] = Math.exp(-rt0);
        q[0] = Math.exp(-ht0);
        double b0 = p[0] * q[0];
        for (int i = 1; i < n; ++i) {
            double ht1 = survivalProbabilities.zeroRate(integrationSchedule.get(i)) * integrationSchedule.get(i);
            double rt1 = discountFactors.zeroRate(integrationSchedule.get(i)) * integrationSchedule.get(i);
            p[i] = Math.exp(-rt1);
            q[i] = Math.exp(-ht1);
            double b1 = p[i] * q[i];
            dht[i - 1] = ht1 - ht0;
            drt[i - 1] = rt1 - rt0;
            dhrt[i - 1] = dht[i - 1] + drt[i - 1];
            double dPv = 0.0;
            if (Math.abs(dhrt[i - 1]) < 1.0E-5) {
                double eps = Epsilon.epsilon((double)(-dhrt[i - 1]));
                dPv = dht[i - 1] * b0 * eps;
            } else {
                dPv = (b0 - b1) * dht[i - 1] / dhrt[i - 1];
            }
            pv += dPv;
            ht0 = ht1;
            rt0 = rt1;
            b0 = b1;
        }
        double df = discountFactors.discountFactor(referenceDate);
        double factor = (1.0 - recoveryRate) / df;
        double eps0 = this.computeExtendedEpsilon(-dhrt[0], p[1], q[1], p[0], q[0]);
        ZeroRateSensitivity pvSensi = discountFactors.zeroRatePointSensitivity(integrationSchedule.get(0)).multipliedBy(-dht[0] * q[0] * eps0 * factor);
        pvSensi = pvSensi.combinedWith(survivalProbabilities.zeroRatePointSensitivity(integrationSchedule.get(0)).multipliedBy(factor * (drt[0] * p[0] * eps0 + p[0])));
        for (int i = 1; i < n - 1; ++i) {
            double epsp = this.computeExtendedEpsilon(-dhrt[i], p[i + 1], q[i + 1], p[i], q[i]);
            double epsm = this.computeExtendedEpsilon(dhrt[i - 1], p[i - 1], q[i - 1], p[i], q[i]);
            ZeroRateSensitivity pSensi = discountFactors.zeroRatePointSensitivity(integrationSchedule.get(i)).multipliedBy(factor * (-dht[i] * q[i] * epsp - dht[i - 1] * q[i] * epsm));
            CreditCurveZeroRateSensitivity qSensi = survivalProbabilities.zeroRatePointSensitivity(integrationSchedule.get(i)).multipliedBy(factor * (drt[i - 1] * p[i] * epsm + drt[i] * p[i] * epsp));
            pvSensi = pvSensi.combinedWith(pSensi).combinedWith((PointSensitivityBuilder)qSensi);
        }
        if (n > 1) {
            double epsLast = this.computeExtendedEpsilon(dhrt[n - 2], p[n - 2], q[n - 2], p[n - 1], q[n - 1]);
            pvSensi = pvSensi.combinedWith(discountFactors.zeroRatePointSensitivity(integrationSchedule.get(n - 1)).multipliedBy(-dht[n - 2] * q[n - 1] * epsLast * factor));
            pvSensi = pvSensi.combinedWith(survivalProbabilities.zeroRatePointSensitivity(integrationSchedule.get(n - 1)).multipliedBy(factor * (drt[n - 2] * p[n - 1] * epsLast - p[n - 1])));
        }
        ZeroRateSensitivity dfSensi = discountFactors.zeroRatePointSensitivity(referenceDate).multipliedBy(-pv * factor / df);
        return dfSensi.combinedWith(pvSensi);
    }

    private double computeExtendedEpsilon(double dhrt, double pn, double qn, double pd, double qd) {
        if (Math.abs(dhrt) < 1.0E-5) {
            return -0.5 - dhrt / 6.0 - dhrt * dhrt / 24.0;
        }
        return (1.0 - (pn * qn / (pd * qd) - 1.0) / dhrt) / dhrt;
    }

    PointSensitivityBuilder riskyAnnuitySensitivity(ResolvedCds cds, CreditDiscountFactors discountFactors, LegalEntitySurvivalProbabilities survivalProbabilities, LocalDate referenceDate, LocalDate stepinDate, LocalDate effectiveStartDate) {
        double pv = 0.0;
        PointSensitivityBuilder pvSensi = PointSensitivityBuilder.none();
        for (CreditCouponPaymentPeriod coupon : cds.getPaymentPeriods()) {
            if (!stepinDate.isBefore(coupon.getEndDate())) continue;
            double q = survivalProbabilities.survivalProbability(coupon.getEffectiveEndDate());
            CreditCurveZeroRateSensitivity qSensi = survivalProbabilities.zeroRatePointSensitivity(coupon.getEffectiveEndDate());
            double p = discountFactors.discountFactor(coupon.getPaymentDate());
            ZeroRateSensitivity pSensi = discountFactors.zeroRatePointSensitivity(coupon.getPaymentDate());
            pv += coupon.getYearFraction() * p * q;
            pvSensi = pvSensi.combinedWith(pSensi.multipliedBy(coupon.getYearFraction() * q).combinedWith(qSensi.multipliedBy(coupon.getYearFraction() * p)));
        }
        if (cds.getPaymentOnDefault().isAccruedInterest()) {
            LocalDate start = cds.getPaymentPeriods().size() == 1 ? effectiveStartDate : cds.getAccrualStartDate();
            DoubleArray integrationSchedule = DoublesScheduleGenerator.getIntegrationsPoints(discountFactors.relativeYearFraction(start), discountFactors.relativeYearFraction(cds.getProtectionEndDate()), discountFactors.getParameterKeys(), survivalProbabilities.getParameterKeys());
            for (CreditCouponPaymentPeriod coupon : cds.getPaymentPeriods()) {
                Pair<Double, PointSensitivityBuilder> pvAndSensi = this.singlePeriodAccrualOnDefaultSensitivity(coupon, effectiveStartDate, integrationSchedule, discountFactors, survivalProbabilities);
                pv += ((Double)pvAndSensi.getFirst()).doubleValue();
                pvSensi = pvSensi.combinedWith((PointSensitivityBuilder)pvAndSensi.getSecond());
            }
        }
        double df = discountFactors.discountFactor(referenceDate);
        ZeroRateSensitivity dfSensi = discountFactors.zeroRatePointSensitivity(referenceDate).multipliedBy(-pv / (df * df));
        pvSensi = pvSensi.multipliedBy(1.0 / df);
        return dfSensi.combinedWith(pvSensi);
    }

    private Pair<Double, PointSensitivityBuilder> singlePeriodAccrualOnDefaultSensitivity(CreditCouponPaymentPeriod coupon, LocalDate effectiveStartDate, DoubleArray integrationSchedule, CreditDiscountFactors discountFactors, LegalEntitySurvivalProbabilities survivalProbabilities) {
        LocalDate start;
        LocalDate localDate = start = coupon.getEffectiveStartDate().isBefore(effectiveStartDate) ? effectiveStartDate : coupon.getEffectiveStartDate();
        if (!start.isBefore(coupon.getEffectiveEndDate())) {
            return Pair.of((Object)0.0, (Object)PointSensitivityBuilder.none());
        }
        DoubleArray knots = DoublesScheduleGenerator.truncateSetInclusive(discountFactors.relativeYearFraction(start), discountFactors.relativeYearFraction(coupon.getEffectiveEndDate()), integrationSchedule);
        double pv = 0.0;
        int nItems = knots.size();
        double[] dhrtBar = new double[nItems - 1];
        double[] dhtBar = new double[nItems - 1];
        double[] bBar = new double[nItems];
        double[] p = new double[nItems];
        double[] q = new double[nItems];
        double t = knots.get(0);
        double ht0 = survivalProbabilities.zeroRate(t) * t;
        double rt0 = discountFactors.zeroRate(t) * t;
        q[0] = Math.exp(-ht0);
        p[0] = Math.exp(-rt0);
        double b0 = q[0] * p[0];
        double effStart = discountFactors.relativeYearFraction(coupon.getEffectiveStartDate());
        double t0 = t - effStart + this.omega;
        for (int i = 1; i < nItems; ++i) {
            double tPv;
            t = knots.get(i);
            double ht1 = survivalProbabilities.zeroRate(t) * t;
            double rt1 = discountFactors.zeroRate(t) * t;
            q[i] = Math.exp(-ht1);
            p[i] = Math.exp(-rt1);
            double b1 = q[i] * p[i];
            double dt = knots.get(i) - knots.get(i - 1);
            double dht = ht1 - ht0;
            double drt = rt1 - rt0;
            double dhrt = dht + drt;
            if (this.formula == AccrualOnDefaultFormula.MARKIT_FIX) {
                if (Math.abs(dhrt) < 1.0E-5) {
                    double eps = Epsilon.epsilonP((double)(-dhrt));
                    tPv = dht * dt * b0 * eps;
                    dhtBar[i - 1] = dt * b0 * eps;
                    dhrtBar[i - 1] = -dht * dt * b0 * Epsilon.epsilonPP((double)(-dhrt));
                    int n = i - 1;
                    bBar[n] = bBar[n] + dht * eps;
                } else {
                    tPv = dht * dt / dhrt * ((b0 - b1) / dhrt - b1);
                    dhtBar[i - 1] = dt / dhrt * ((b0 - b1) / dhrt - b1);
                    dhrtBar[i - 1] = dht * dt / (dhrt * dhrt) * (b1 - 2.0 * (b0 - b1) / dhrt);
                    int n = i - 1;
                    bBar[n] = bBar[n] + dht * dt / (dhrt * dhrt);
                    int n2 = i;
                    bBar[n2] = bBar[n2] + -dht * dt / dhrt * (1.0 + 1.0 / dhrt);
                }
            } else {
                double t1 = t - effStart + this.omega;
                if (Math.abs(dhrt) < 1.0E-5) {
                    double eps = Epsilon.epsilon((double)(-dhrt));
                    double epsp = Epsilon.epsilonP((double)(-dhrt));
                    tPv = dht * b0 * (t0 * eps + dt * epsp);
                    dhtBar[i - 1] = b0 * (t0 * eps + dt * epsp);
                    dhrtBar[i - 1] = -dht * b0 * (t0 * epsp + dt * Epsilon.epsilonPP((double)(-dhrt)));
                    int n = i - 1;
                    bBar[n] = bBar[n] + dht * (t0 * eps + dt * epsp);
                } else {
                    tPv = dht / dhrt * (t0 * b0 - t1 * b1 + dt / dhrt * (b0 - b1));
                    dhtBar[i - 1] = (t0 * b0 - t1 * b1 + dt / dhrt * (b0 - b1)) / dhrt;
                    dhrtBar[i - 1] = dht / (dhrt * dhrt) * (-2.0 * dt / dhrt * (b0 - b1) - t0 * b0 + t1 * b1);
                    int n = i - 1;
                    bBar[n] = bBar[n] + dht / dhrt * (t0 + dt / dhrt);
                    int n3 = i;
                    bBar[n3] = bBar[n3] + dht / dhrt * (-t1 - dt / dhrt);
                }
                t0 = t1;
            }
            pv += tPv;
            ht0 = ht1;
            rt0 = rt1;
            b0 = b1;
        }
        double yfRatio = coupon.getYearFraction() / discountFactors.getDayCount().relativeYearFraction(coupon.getStartDate(), coupon.getEndDate());
        CreditCurveZeroRateSensitivity qSensiFirst = survivalProbabilities.zeroRatePointSensitivity(knots.get(0)).multipliedBy(yfRatio * ((dhrtBar[0] + dhtBar[0]) / q[0] + bBar[0] * p[0]));
        ZeroRateSensitivity pSensiFirst = discountFactors.zeroRatePointSensitivity(knots.get(0)).multipliedBy(yfRatio * (dhrtBar[0] / p[0] + bBar[0] * q[0]));
        PointSensitivityBuilder pvSensi = pSensiFirst.combinedWith(qSensiFirst);
        for (int i = 1; i < nItems - 1; ++i) {
            CreditCurveZeroRateSensitivity qSensi = survivalProbabilities.zeroRatePointSensitivity(knots.get(i)).multipliedBy(yfRatio * (-(dhrtBar[i - 1] + dhtBar[i - 1]) / q[i] + (dhrtBar[i] + dhtBar[i]) / q[i] + bBar[i] * p[i]));
            ZeroRateSensitivity pSensi = discountFactors.zeroRatePointSensitivity(knots.get(i)).multipliedBy(yfRatio * (-dhrtBar[i - 1] / p[i] + dhrtBar[i] / p[i] + bBar[i] * q[i]));
            pvSensi = pvSensi.combinedWith((PointSensitivityBuilder)pSensi).combinedWith((PointSensitivityBuilder)qSensi);
        }
        if (nItems > 1) {
            CreditCurveZeroRateSensitivity qSensiLast = survivalProbabilities.zeroRatePointSensitivity(knots.get(nItems - 1)).multipliedBy(yfRatio * (-(dhrtBar[nItems - 2] + dhtBar[nItems - 2]) / q[nItems - 1] + bBar[nItems - 1] * p[nItems - 1]));
            ZeroRateSensitivity pSensiLast = discountFactors.zeroRatePointSensitivity(knots.get(nItems - 1)).multipliedBy(yfRatio * (-dhrtBar[nItems - 2] / p[nItems - 1] + bBar[nItems - 1] * q[nItems - 1]));
            pvSensi = pvSensi.combinedWith((PointSensitivityBuilder)pSensiLast).combinedWith((PointSensitivityBuilder)qSensiLast);
        }
        return Pair.of((Object)(yfRatio * pv), (Object)pvSensi);
    }

    private boolean isExpired(ResolvedCds cds, CreditRatesProvider ratesProvider) {
        return !cds.getProtectionEndDate().isAfter(ratesProvider.getValuationDate());
    }

    double recoveryRate(ResolvedCds cds, CreditRatesProvider ratesProvider) {
        RecoveryRates recoveryRates = ratesProvider.recoveryRates(cds.getLegalEntityId());
        ArgChecker.isTrue((boolean)(recoveryRates instanceof ConstantRecoveryRates), (String)"recoveryRates must be ConstantRecoveryRates");
        return recoveryRates.recoveryRate(cds.getProtectionEndDate());
    }

    void validateRecoveryRates(ResolvedCds cds, CreditRatesProvider ratesProvider) {
        RecoveryRates recoveryRates = ratesProvider.recoveryRates(cds.getLegalEntityId());
        ArgChecker.isTrue((boolean)(recoveryRates instanceof ConstantRecoveryRates), (String)"recoveryRates must be ConstantRecoveryRates");
    }

    private Pair<CreditDiscountFactors, LegalEntitySurvivalProbabilities> reduceDiscountFactors(ResolvedCds cds, CreditRatesProvider ratesProvider) {
        Currency currency = cds.getCurrency();
        CreditDiscountFactors discountFactors = ratesProvider.discountFactors(currency);
        ArgChecker.isTrue((boolean)discountFactors.isIsdaCompliant(), (String)"discount factors must be IsdaCompliantZeroRateDiscountFactors");
        LegalEntitySurvivalProbabilities survivalProbabilities = ratesProvider.survivalProbabilities(cds.getLegalEntityId(), currency);
        ArgChecker.isTrue((boolean)survivalProbabilities.getSurvivalProbabilities().isIsdaCompliant(), (String)"survival probabilities must be IsdaCompliantZeroRateDiscountFactors");
        ArgChecker.isTrue((boolean)discountFactors.getDayCount().equals(survivalProbabilities.getSurvivalProbabilities().getDayCount()), (String)"day count conventions of discounting curve and credit curve must be the same");
        return Pair.of((Object)discountFactors, (Object)survivalProbabilities);
    }
}

