/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataId;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.DefaultCurveMetadata;
import com.opengamma.strata.market.curve.IsdaCreditCurveDefinition;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.curve.node.CdsIndexIsdaCreditCurveNode;
import com.opengamma.strata.market.curve.node.CdsIsdaCreditCurveNode;
import com.opengamma.strata.market.observable.LegalEntityInformation;
import com.opengamma.strata.market.observable.LegalEntityInformationId;
import com.opengamma.strata.market.param.ResolvedTradeParameterMetadata;
import com.opengamma.strata.pricer.credit.FastCreditCurveCalibrator;
import com.opengamma.strata.pricer.credit.ImmutableCreditRatesProvider;
import com.opengamma.strata.pricer.credit.IsdaCompliantCreditCurveCalibrator;
import com.opengamma.strata.pricer.credit.IsdaCreditDiscountFactors;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.product.ResolvedTrade;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class IsdaCompliantIndexCurveCalibrator {
    private static final IsdaCompliantIndexCurveCalibrator STANDARD = new IsdaCompliantIndexCurveCalibrator(FastCreditCurveCalibrator.standard());
    private final IsdaCompliantCreditCurveCalibrator creditCurveCalibrator;

    public static IsdaCompliantIndexCurveCalibrator standard() {
        return STANDARD;
    }

    public IsdaCompliantIndexCurveCalibrator(IsdaCompliantCreditCurveCalibrator creditCurveCalibrator) {
        this.creditCurveCalibrator = (IsdaCompliantCreditCurveCalibrator)ArgChecker.notNull((Object)creditCurveCalibrator, (String)"creditCurveCalibrator");
    }

    public LegalEntitySurvivalProbabilities calibrate(IsdaCreditCurveDefinition curveDefinition, MarketData marketData, ImmutableCreditRatesProvider ratesProvider, ReferenceData refData) {
        ArgChecker.isTrue((boolean)curveDefinition.getCurveValuationDate().equals(ratesProvider.getValuationDate()), (String)"ratesProvider and curveDefinition must be based on the same valuation date");
        ImmutableList curveNodes = (ImmutableList)curveDefinition.getCurveNodes().stream().filter(n -> n instanceof CdsIndexIsdaCreditCurveNode).map(n -> (CdsIndexIsdaCreditCurveNode)n).collect(Guavate.toImmutableList());
        double indexFactor = this.computeIndexFactor((CdsIndexIsdaCreditCurveNode)curveNodes.get(0), marketData);
        List cdsNodes = (List)curveNodes.stream().map(i -> this.toCdsNode((CdsIndexIsdaCreditCurveNode)i)).collect(Guavate.toImmutableList());
        LegalEntitySurvivalProbabilities creditCurve = this.creditCurveCalibrator.calibrate(cdsNodes, curveDefinition.getName(), marketData, ratesProvider, curveDefinition.getDayCount(), curveDefinition.getCurrency(), curveDefinition.isComputeJacobian(), false, refData);
        NodalCurve underlyingCurve = ((IsdaCreditDiscountFactors)creditCurve.getSurvivalProbabilities()).getCurve();
        DefaultCurveMetadata metadata = underlyingCurve.getMetadata().withInfo(CurveInfoType.CDS_INDEX_FACTOR, (Object)indexFactor);
        if (curveDefinition.isStoreNodeTrade()) {
            int nNodes = curveDefinition.getCurveNodes().size();
            ImmutableList parameterMetadata = (ImmutableList)IntStream.range(0, nNodes).mapToObj(n -> ResolvedTradeParameterMetadata.of((ResolvedTrade)((CdsIndexIsdaCreditCurveNode)curveNodes.get(n)).trade(1.0, marketData, refData).getUnderlyingTrade().resolve(refData), (String)((CdsIndexIsdaCreditCurveNode)curveNodes.get(n)).getLabel())).collect(Guavate.toImmutableList());
            metadata = metadata.withParameterMetadata((List)parameterMetadata);
        }
        NodalCurve curveWithFactor = underlyingCurve.withMetadata((CurveMetadata)metadata);
        return LegalEntitySurvivalProbabilities.of(creditCurve.getLegalEntityId(), IsdaCreditDiscountFactors.of(creditCurve.getCurrency(), creditCurve.getValuationDate(), curveWithFactor));
    }

    private CdsIsdaCreditCurveNode toCdsNode(CdsIndexIsdaCreditCurveNode index) {
        return CdsIsdaCreditCurveNode.builder().label(index.getLabel()).legalEntityId(index.getCdsIndexId()).observableId(index.getObservableId()).quoteConvention(index.getQuoteConvention()).template(index.getTemplate()).fixedRate(index.getFixedRate().isPresent() ? Double.valueOf(index.getFixedRate().getAsDouble()) : null).build();
    }

    private double computeIndexFactor(CdsIndexIsdaCreditCurveNode node, MarketData marketData) {
        double numDefaulted = node.getLegalEntityIds().stream().map(s -> (LegalEntityInformation)marketData.getValue((MarketDataId)LegalEntityInformationId.of((StandardId)s))).map(Guavate.casting(LegalEntityInformation.class)).filter(LegalEntityInformation::isDefaulted).collect(Collectors.toList()).size();
        double numTotal = node.getLegalEntityIds().size();
        return (numTotal - numDefaulted) / numTotal;
    }
}

