/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.ConstantNodalCurve;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.DefaultCurveMetadata;
import com.opengamma.strata.market.curve.InterpolatedNodalCurve;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolators;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.UnitParameterSensitivity;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableConstructor;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class IsdaCreditDiscountFactors
implements CreditDiscountFactors,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Currency currency;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final LocalDate valuationDate;
    @PropertyDefinition(validate="notNull")
    private final NodalCurve curve;
    private final DayCount dayCount;
    private static final long serialVersionUID = 1L;

    public static IsdaCreditDiscountFactors of(Currency currency, LocalDate valuationDate, NodalCurve curve) {
        curve.getMetadata().getXValueType().checkEquals(ValueType.YEAR_FRACTION, "Incorrect x-value type for zero-rate discount curve");
        curve.getMetadata().getYValueType().checkEquals(ValueType.ZERO_RATE, "Incorrect y-value type for zero-rate discount curve");
        if (curve instanceof InterpolatedNodalCurve) {
            InterpolatedNodalCurve interpolatedCurve = (InterpolatedNodalCurve)curve;
            ArgChecker.isTrue((boolean)interpolatedCurve.getInterpolator().equals(CurveInterpolators.PRODUCT_LINEAR), (String)"Interpolator must be PRODUCT_LINEAR");
            ArgChecker.isTrue((boolean)interpolatedCurve.getExtrapolatorLeft().equals(CurveExtrapolators.FLAT), (String)"Left extrapolator must be FLAT");
            ArgChecker.isTrue((boolean)interpolatedCurve.getExtrapolatorRight().equals(CurveExtrapolators.PRODUCT_LINEAR), (String)"Right extrapolator must be PRODUCT_LINEAR");
        } else {
            ArgChecker.isTrue((boolean)(curve instanceof ConstantNodalCurve), (String)"the underlying curve must be InterpolatedNodalCurve or ConstantNodalCurve");
        }
        return new IsdaCreditDiscountFactors(currency, valuationDate, curve);
    }

    public static IsdaCreditDiscountFactors of(Currency currency, LocalDate valuationDate, CurveName curveName, DoubleArray yearFractions, DoubleArray zeroRates, DayCount dayCount) {
        ArgChecker.notNull((Object)yearFractions, (String)"yearFractions");
        ArgChecker.notNull((Object)zeroRates, (String)"zeroRates");
        DefaultCurveMetadata metadata = DefaultCurveMetadata.builder().xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.ZERO_RATE).curveName(curveName).dayCount(dayCount).build();
        InterpolatedNodalCurve curve = yearFractions.size() == 1 && zeroRates.size() == 1 ? ConstantNodalCurve.of((CurveMetadata)metadata, (double)yearFractions.get(0), (double)zeroRates.get(0)) : InterpolatedNodalCurve.of((CurveMetadata)metadata, (DoubleArray)yearFractions, (DoubleArray)zeroRates, (CurveInterpolator)CurveInterpolators.PRODUCT_LINEAR, (CurveExtrapolator)CurveExtrapolators.FLAT, (CurveExtrapolator)CurveExtrapolators.PRODUCT_LINEAR);
        return new IsdaCreditDiscountFactors(currency, valuationDate, (NodalCurve)curve);
    }

    @ImmutableConstructor
    private IsdaCreditDiscountFactors(Currency currency, LocalDate valuationDate, NodalCurve curve) {
        ArgChecker.notNull((Object)currency, (String)"currency");
        ArgChecker.notNull((Object)valuationDate, (String)"valuationDate");
        ArgChecker.notNull((Object)curve, (String)"curve");
        DayCount dayCount = (DayCount)curve.getMetadata().findInfo(CurveInfoType.DAY_COUNT).orElseThrow(() -> new IllegalArgumentException("Incorrect curve metadata, missing DayCount"));
        this.currency = currency;
        this.valuationDate = valuationDate;
        this.curve = curve;
        this.dayCount = dayCount;
    }

    @Override
    public boolean isIsdaCompliant() {
        return true;
    }

    public <T> Optional<T> findData(MarketDataName<T> name) {
        if (this.curve.getName().equals(name)) {
            return Optional.of(name.getMarketDataType().cast(this.curve));
        }
        return Optional.empty();
    }

    public int getParameterCount() {
        return this.curve.getParameterCount();
    }

    public double getParameter(int parameterIndex) {
        return this.curve.getParameter(parameterIndex);
    }

    @Override
    public DoubleArray getParameterKeys() {
        return this.curve.getXValues();
    }

    public ParameterMetadata getParameterMetadata(int parameterIndex) {
        return this.curve.getParameterMetadata(parameterIndex);
    }

    public OptionalInt findParameterIndex(ParameterMetadata metadata) {
        return this.curve.findParameterIndex(metadata);
    }

    @Override
    public IsdaCreditDiscountFactors withParameter(int parameterIndex, double newValue) {
        return this.withCurve(this.curve.withParameter(parameterIndex, newValue));
    }

    @Override
    public IsdaCreditDiscountFactors withPerturbation(ParameterPerturbation perturbation) {
        return this.withCurve(this.curve.withPerturbation(perturbation));
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount;
    }

    @Override
    public double relativeYearFraction(LocalDate date) {
        return this.dayCount.relativeYearFraction(this.valuationDate, date);
    }

    @Override
    public double discountFactor(double yearFraction) {
        return Math.exp(-yearFraction * this.curve.yValue(yearFraction));
    }

    @Override
    public double zeroRate(double yearFraction) {
        return this.curve.yValue(yearFraction);
    }

    @Override
    public ZeroRateSensitivity zeroRatePointSensitivity(double yearFraction, Currency sensitivityCurrency) {
        double discountFactor = this.discountFactor(yearFraction);
        return ZeroRateSensitivity.of(this.currency, yearFraction, sensitivityCurrency, -discountFactor * yearFraction);
    }

    @Override
    public CurrencyParameterSensitivities parameterSensitivity(ZeroRateSensitivity pointSensitivity) {
        double yearFraction = pointSensitivity.getYearFraction();
        UnitParameterSensitivity unitSens = this.curve.yValueParameterSensitivity(yearFraction);
        CurrencyParameterSensitivity curSens = unitSens.multipliedBy(pointSensitivity.getCurrency(), pointSensitivity.getSensitivity());
        return CurrencyParameterSensitivities.of((CurrencyParameterSensitivity)curSens);
    }

    @Override
    public CurrencyParameterSensitivities createParameterSensitivity(Currency currency, DoubleArray sensitivities) {
        return CurrencyParameterSensitivities.of((CurrencyParameterSensitivity)this.curve.createParameterSensitivity(currency, sensitivities));
    }

    @Override
    public DiscountFactors toDiscountFactors() {
        return DiscountFactors.of(this.currency, this.valuationDate, (Curve)this.curve);
    }

    public IsdaCreditDiscountFactors withCurve(NodalCurve curve) {
        return IsdaCreditDiscountFactors.of(this.currency, this.valuationDate, curve);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public Currency getCurrency() {
        return this.currency;
    }

    public LocalDate getValuationDate() {
        return this.valuationDate;
    }

    public NodalCurve getCurve() {
        return this.curve;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IsdaCreditDiscountFactors other = (IsdaCreditDiscountFactors)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.valuationDate, (Object)other.valuationDate) && JodaBeanUtils.equal((Object)this.curve, (Object)other.curve);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.valuationDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.curve);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("IsdaCreditDiscountFactors{");
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
        buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<IsdaCreditDiscountFactors> {
        private Currency currency;
        private LocalDate valuationDate;
        private NodalCurve curve;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case 95027439: {
                    return this.curve;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 113107279: {
                    this.valuationDate = (LocalDate)newValue;
                    break;
                }
                case 95027439: {
                    this.curve = (NodalCurve)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public IsdaCreditDiscountFactors build() {
            return new IsdaCreditDiscountFactors(this.currency, this.valuationDate, this.curve);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("IsdaCreditDiscountFactors.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("valuationDate").append('=').append(JodaBeanUtils.toString((Object)this.valuationDate)).append(',').append(' ');
            buf.append("curve").append('=').append(JodaBeanUtils.toString((Object)this.curve));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", IsdaCreditDiscountFactors.class, Currency.class);
        private final MetaProperty<LocalDate> valuationDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"valuationDate", IsdaCreditDiscountFactors.class, LocalDate.class);
        private final MetaProperty<NodalCurve> curve = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"curve", IsdaCreditDiscountFactors.class, NodalCurve.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "valuationDate", "curve"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 113107279: {
                    return this.valuationDate;
                }
                case 95027439: {
                    return this.curve;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends IsdaCreditDiscountFactors> builder() {
            return new Builder();
        }

        public Class<? extends IsdaCreditDiscountFactors> beanType() {
            return IsdaCreditDiscountFactors.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<LocalDate> valuationDate() {
            return this.valuationDate;
        }

        public MetaProperty<NodalCurve> curve() {
            return this.curve;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((IsdaCreditDiscountFactors)bean).getCurrency();
                }
                case 113107279: {
                    return ((IsdaCreditDiscountFactors)bean).getValuationDate();
                }
                case 95027439: {
                    return ((IsdaCreditDiscountFactors)bean).getCurve();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

