/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Triple;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.common.PriceType;
import com.opengamma.strata.pricer.credit.AccrualOnDefaultFormula;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.IsdaCdsProductPricer;
import com.opengamma.strata.pricer.credit.IsdaCreditDiscountFactors;
import com.opengamma.strata.pricer.credit.JumpToDefault;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.product.credit.ResolvedCds;
import com.opengamma.strata.product.credit.ResolvedCdsIndex;
import java.time.LocalDate;
import java.util.Map;

public class IsdaHomogenousCdsIndexProductPricer {
    public static final IsdaHomogenousCdsIndexProductPricer DEFAULT = new IsdaHomogenousCdsIndexProductPricer(AccrualOnDefaultFormula.ORIGINAL_ISDA);
    private final IsdaCdsProductPricer underlyingPricer;

    public IsdaHomogenousCdsIndexProductPricer(AccrualOnDefaultFormula formula) {
        this.underlyingPricer = new IsdaCdsProductPricer(formula);
    }

    public AccrualOnDefaultFormula getAccrualOnDefaultFormula() {
        return this.underlyingPricer.getAccrualOnDefaultFormula();
    }

    public double price(ResolvedCdsIndex cdsIndex, CreditRatesProvider ratesProvider, LocalDate referenceDate, PriceType priceType, ReferenceData refData) {
        ResolvedCds cds = cdsIndex.toSingleNameCds();
        return this.underlyingPricer.price(cds, ratesProvider, referenceDate, priceType, refData);
    }

    public PointSensitivityBuilder priceSensitivity(ResolvedCdsIndex cdsIndex, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        ResolvedCds cds = cdsIndex.toSingleNameCds();
        return this.underlyingPricer.priceSensitivity(cds, ratesProvider, referenceDate, refData);
    }

    public CurrencyAmount presentValue(ResolvedCdsIndex cdsIndex, CreditRatesProvider ratesProvider, LocalDate referenceDate, PriceType priceType, ReferenceData refData) {
        if (this.isExpired(cdsIndex, ratesProvider)) {
            return CurrencyAmount.of((Currency)cdsIndex.getCurrency(), (double)0.0);
        }
        ResolvedCds cds = cdsIndex.toSingleNameCds();
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        double recoveryRate = this.underlyingPricer.recoveryRate(cds, ratesProvider);
        Triple<CreditDiscountFactors, LegalEntitySurvivalProbabilities, Double> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double protectionLeg = (1.0 - recoveryRate) * this.underlyingPricer.protectionFull(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate);
        double rpv01 = this.underlyingPricer.riskyAnnuity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate, priceType);
        double amount = cds.getBuySell().normalize(cds.getNotional()) * (Double)rates.getThird() * (protectionLeg - rpv01 * cds.getFixedRate());
        return CurrencyAmount.of((Currency)cds.getCurrency(), (double)amount);
    }

    public PointSensitivityBuilder presentValueSensitivity(ResolvedCdsIndex cdsIndex, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        if (this.isExpired(cdsIndex, ratesProvider)) {
            return PointSensitivityBuilder.none();
        }
        ResolvedCds cds = cdsIndex.toSingleNameCds();
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        double recoveryRate = this.underlyingPricer.recoveryRate(cds, ratesProvider);
        Triple<CreditDiscountFactors, LegalEntitySurvivalProbabilities, Double> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double signedNotional = cds.getBuySell().normalize(cds.getNotional());
        PointSensitivityBuilder protectionLegSensi = this.underlyingPricer.protectionLegSensitivity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate, recoveryRate);
        protectionLegSensi = protectionLegSensi.multipliedBy(signedNotional * (Double)rates.getThird());
        PointSensitivityBuilder riskyAnnuitySensi = this.underlyingPricer.riskyAnnuitySensitivity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate);
        riskyAnnuitySensi = riskyAnnuitySensi.multipliedBy(-cds.getFixedRate() * signedNotional * (Double)rates.getThird());
        return protectionLegSensi.combinedWith(riskyAnnuitySensi);
    }

    public double parSpread(ResolvedCdsIndex cdsIndex, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        ResolvedCds cds = cdsIndex.toSingleNameCds();
        return this.underlyingPricer.parSpread(cds, ratesProvider, referenceDate, refData);
    }

    public PointSensitivityBuilder parSpreadSensitivity(ResolvedCdsIndex cdsIndex, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        ResolvedCds cds = cdsIndex.toSingleNameCds();
        return this.underlyingPricer.parSpreadSensitivity(cds, ratesProvider, referenceDate, refData);
    }

    public CurrencyAmount rpv01(ResolvedCdsIndex cdsIndex, CreditRatesProvider ratesProvider, LocalDate referenceDate, PriceType priceType, ReferenceData refData) {
        if (this.isExpired(cdsIndex, ratesProvider)) {
            return CurrencyAmount.of((Currency)cdsIndex.getCurrency(), (double)0.0);
        }
        ResolvedCds cds = cdsIndex.toSingleNameCds();
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        Triple<CreditDiscountFactors, LegalEntitySurvivalProbabilities, Double> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double riskyAnnuity = this.underlyingPricer.riskyAnnuity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate, priceType);
        double amount = cds.getBuySell().normalize(cds.getNotional()) * riskyAnnuity * (Double)rates.getThird();
        return CurrencyAmount.of((Currency)cds.getCurrency(), (double)amount);
    }

    public double riskyAnnuity(ResolvedCdsIndex cdsIndex, CreditRatesProvider ratesProvider, LocalDate referenceDate, PriceType priceType, ReferenceData refData) {
        if (this.isExpired(cdsIndex, ratesProvider)) {
            return 0.0;
        }
        ResolvedCds cds = cdsIndex.toSingleNameCds();
        LocalDate stepinDate = cdsIndex.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cdsIndex.calculateEffectiveStartDate(stepinDate);
        Triple<CreditDiscountFactors, LegalEntitySurvivalProbabilities, Double> rates = this.reduceDiscountFactors(cds, ratesProvider);
        return this.underlyingPricer.riskyAnnuity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate, priceType);
    }

    public PointSensitivityBuilder riskyAnnuitySensitivity(ResolvedCdsIndex cdsIndex, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        if (this.isExpired(cdsIndex, ratesProvider)) {
            return PointSensitivityBuilder.none();
        }
        LocalDate stepinDate = cdsIndex.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cdsIndex.calculateEffectiveStartDate(stepinDate);
        ResolvedCds cds = cdsIndex.toSingleNameCds();
        Triple<CreditDiscountFactors, LegalEntitySurvivalProbabilities, Double> rates = this.reduceDiscountFactors(cds, ratesProvider);
        return this.underlyingPricer.riskyAnnuitySensitivity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate);
    }

    public CurrencyAmount recovery01(ResolvedCdsIndex cdsIndex, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        if (this.isExpired(cdsIndex, ratesProvider)) {
            return CurrencyAmount.of((Currency)cdsIndex.getCurrency(), (double)0.0);
        }
        ResolvedCds cds = cdsIndex.toSingleNameCds();
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        this.underlyingPricer.validateRecoveryRates(cds, ratesProvider);
        Triple<CreditDiscountFactors, LegalEntitySurvivalProbabilities, Double> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double protectionFull = this.underlyingPricer.protectionFull(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate);
        double amount = -cds.getBuySell().normalize(cds.getNotional()) * protectionFull * (Double)rates.getThird();
        return CurrencyAmount.of((Currency)cds.getCurrency(), (double)amount);
    }

    public JumpToDefault jumpToDefault(ResolvedCdsIndex cdsIndex, CreditRatesProvider ratesProvider, LocalDate referenceDate, ReferenceData refData) {
        StandardId indexId = cdsIndex.getCdsIndexId();
        Currency currency = cdsIndex.getCurrency();
        if (this.isExpired(cdsIndex, ratesProvider)) {
            return JumpToDefault.of(currency, (Map<StandardId, Double>)ImmutableMap.of((Object)indexId, (Object)0.0));
        }
        ResolvedCds cds = cdsIndex.toSingleNameCds();
        LocalDate stepinDate = cds.getStepinDateOffset().adjust(ratesProvider.getValuationDate(), refData);
        LocalDate effectiveStartDate = cds.calculateEffectiveStartDate(stepinDate);
        double recoveryRate = this.underlyingPricer.recoveryRate(cds, ratesProvider);
        Triple<CreditDiscountFactors, LegalEntitySurvivalProbabilities, Double> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double protectionFull = this.underlyingPricer.protectionFull(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, effectiveStartDate);
        double rpv01 = this.underlyingPricer.riskyAnnuity(cds, (CreditDiscountFactors)rates.getFirst(), (LegalEntitySurvivalProbabilities)rates.getSecond(), referenceDate, stepinDate, effectiveStartDate, PriceType.CLEAN);
        double lgd = 1.0 - recoveryRate;
        double numTotal = cdsIndex.getLegalEntityIds().size();
        double jtd = (lgd - (lgd * protectionFull - cds.getFixedRate() * rpv01)) / numTotal;
        return JumpToDefault.of(currency, (Map<StandardId, Double>)ImmutableMap.of((Object)indexId, (Object)(cds.getBuySell().normalize(cds.getNotional()) * jtd)));
    }

    public CurrencyAmount expectedLoss(ResolvedCdsIndex cdsIndex, CreditRatesProvider ratesProvider) {
        if (this.isExpired(cdsIndex, ratesProvider)) {
            return CurrencyAmount.of((Currency)cdsIndex.getCurrency(), (double)0.0);
        }
        ResolvedCds cds = cdsIndex.toSingleNameCds();
        double recoveryRate = this.underlyingPricer.recoveryRate(cds, ratesProvider);
        Triple<CreditDiscountFactors, LegalEntitySurvivalProbabilities, Double> rates = this.reduceDiscountFactors(cds, ratesProvider);
        double survivalProbability = ((LegalEntitySurvivalProbabilities)rates.getSecond()).survivalProbability(cds.getProtectionEndDate());
        double el = (1.0 - recoveryRate) * (1.0 - survivalProbability) * (Double)rates.getThird();
        return CurrencyAmount.of((Currency)cds.getCurrency(), (double)(Math.abs(cds.getNotional()) * el));
    }

    boolean isExpired(ResolvedCdsIndex index, CreditRatesProvider ratesProvider) {
        return !index.getProtectionEndDate().isAfter(ratesProvider.getValuationDate());
    }

    Triple<CreditDiscountFactors, LegalEntitySurvivalProbabilities, Double> reduceDiscountFactors(ResolvedCds cds, CreditRatesProvider ratesProvider) {
        Currency currency = cds.getCurrency();
        CreditDiscountFactors discountFactors = ratesProvider.discountFactors(currency);
        ArgChecker.isTrue((boolean)discountFactors.isIsdaCompliant(), (String)"discount factors must be IsdaCompliantZeroRateDiscountFactors");
        LegalEntitySurvivalProbabilities survivalProbabilities = ratesProvider.survivalProbabilities(cds.getLegalEntityId(), currency);
        ArgChecker.isTrue((boolean)survivalProbabilities.getSurvivalProbabilities().isIsdaCompliant(), (String)"survival probabilities must be IsdaCompliantZeroRateDiscountFactors");
        ArgChecker.isTrue((boolean)discountFactors.getDayCount().equals(survivalProbabilities.getSurvivalProbabilities().getDayCount()), (String)"day count conventions of discounting curve and credit curve must be the same");
        double indexFactor = (Double)((IsdaCreditDiscountFactors)survivalProbabilities.getSurvivalProbabilities()).getCurve().getMetadata().getInfo(CurveInfoType.CDS_INDEX_FACTOR);
        return Triple.of((Object)discountFactors, (Object)survivalProbabilities, (Object)indexFactor);
    }
}

