/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.basics.currency.Payment;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountingPaymentPricer;
import com.opengamma.strata.pricer.common.PriceType;
import com.opengamma.strata.pricer.credit.AccrualOnDefaultFormula;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.IsdaHomogenousCdsIndexProductPricer;
import com.opengamma.strata.pricer.credit.JumpToDefault;
import com.opengamma.strata.product.credit.ResolvedCdsIndexTrade;
import java.time.LocalDate;

public class IsdaHomogenousCdsIndexTradePricer {
    public static final IsdaHomogenousCdsIndexTradePricer DEFAULT = new IsdaHomogenousCdsIndexTradePricer();
    private final IsdaHomogenousCdsIndexProductPricer productPricer;
    private final DiscountingPaymentPricer upfrontPricer;

    public IsdaHomogenousCdsIndexTradePricer() {
        this.productPricer = IsdaHomogenousCdsIndexProductPricer.DEFAULT;
        this.upfrontPricer = DiscountingPaymentPricer.DEFAULT;
    }

    public IsdaHomogenousCdsIndexTradePricer(AccrualOnDefaultFormula formula) {
        this.productPricer = new IsdaHomogenousCdsIndexProductPricer(formula);
        this.upfrontPricer = DiscountingPaymentPricer.DEFAULT;
    }

    public AccrualOnDefaultFormula getAccrualOnDefaultFormula() {
        return this.productPricer.getAccrualOnDefaultFormula();
    }

    public double price(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, PriceType priceType, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.price(trade.getProduct(), ratesProvider, settlementDate, priceType, refData);
    }

    public PointSensitivities priceSensitivity(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.priceSensitivity(trade.getProduct(), ratesProvider, settlementDate, refData).build();
    }

    public double parSpread(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.parSpread(trade.getProduct(), ratesProvider, settlementDate, refData);
    }

    public PointSensitivities parSpreadSensitivity(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.parSpreadSensitivity(trade.getProduct(), ratesProvider, settlementDate, refData).build();
    }

    public CurrencyAmount presentValue(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, PriceType priceType, ReferenceData refData) {
        CurrencyAmount pvProduct = this.productPricer.presentValue(trade.getProduct(), ratesProvider, ratesProvider.getValuationDate(), priceType, refData);
        if (!trade.getUpfrontFee().isPresent()) {
            return pvProduct;
        }
        Payment upfront = (Payment)trade.getUpfrontFee().get();
        CurrencyAmount pvUpfront = this.upfrontPricer.presentValue(upfront, ratesProvider.discountFactors(upfront.getCurrency()).toDiscountFactors());
        return pvProduct.plus(pvUpfront);
    }

    public PointSensitivities presentValueSensitivity(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        PointSensitivityBuilder pvSensiProduct = this.productPricer.presentValueSensitivity(trade.getProduct(), ratesProvider, ratesProvider.getValuationDate(), refData);
        if (!trade.getUpfrontFee().isPresent()) {
            return pvSensiProduct.build();
        }
        Payment upfront = (Payment)trade.getUpfrontFee().get();
        PointSensitivityBuilder pvUpfront = this.upfrontPricer.presentValueSensitivity(upfront, ratesProvider.discountFactors(upfront.getCurrency()).toDiscountFactors());
        return pvSensiProduct.combinedWith(pvUpfront).build();
    }

    public CurrencyAmount presentValueOnSettle(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, PriceType priceType, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.presentValue(trade.getProduct(), ratesProvider, settlementDate, priceType, refData);
    }

    public PointSensitivities presentValueOnSettleSensitivity(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.presentValueSensitivity(trade.getProduct(), ratesProvider, settlementDate, refData).build();
    }

    public CurrencyAmount rpv01OnSettle(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, PriceType priceType, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.rpv01(trade.getProduct(), ratesProvider, settlementDate, priceType, refData);
    }

    public CurrencyAmount recovery01OnSettle(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.recovery01(trade.getProduct(), ratesProvider, settlementDate, refData);
    }

    public JumpToDefault jumpToDefault(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        LocalDate settlementDate = this.calculateSettlementDate(trade, ratesProvider, refData);
        return this.productPricer.jumpToDefault(trade.getProduct(), ratesProvider, settlementDate, refData);
    }

    public CurrencyAmount expectedLoss(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider) {
        return this.productPricer.expectedLoss(trade.getProduct(), ratesProvider);
    }

    private LocalDate calculateSettlementDate(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        return trade.getInfo().getSettlementDate().orElse(trade.getProduct().calculateSettlementDateFromValuation(ratesProvider.getValuationDate(), refData));
    }
}

