/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.FxConvertible;
import com.opengamma.strata.basics.currency.FxRateProvider;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class JumpToDefault
implements FxConvertible<JumpToDefault>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="notNull")
    private final ImmutableMap<StandardId, Double> amounts;
    private static final long serialVersionUID = 1L;

    public static JumpToDefault of(Currency currency, Map<StandardId, Double> splitValues) {
        return new JumpToDefault(currency, splitValues);
    }

    public JumpToDefault convertedTo(Currency resultCurrency, FxRateProvider rateProvider) {
        HashMap<StandardId, Double> mutable = new HashMap<StandardId, Double>();
        for (Map.Entry entry : this.amounts.entrySet()) {
            double converted = rateProvider.convert(((Double)entry.getValue()).doubleValue(), this.currency, resultCurrency);
            mutable.put((StandardId)entry.getKey(), converted);
        }
        return JumpToDefault.of(resultCurrency, mutable);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private JumpToDefault(Currency currency, Map<StandardId, Double> amounts) {
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull(amounts, (String)"amounts");
        this.currency = currency;
        this.amounts = ImmutableMap.copyOf(amounts);
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public ImmutableMap<StandardId, Double> getAmounts() {
        return this.amounts;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            JumpToDefault other = (JumpToDefault)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal(this.amounts, other.amounts);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode(this.amounts);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("JumpToDefault{");
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("amounts").append('=').append(JodaBeanUtils.toString(this.amounts));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<JumpToDefault> {
        private Currency currency;
        private Map<StandardId, Double> amounts = ImmutableMap.of();

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case -879772901: {
                    return this.amounts;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case -879772901: {
                    this.amounts = (Map)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public JumpToDefault build() {
            return new JumpToDefault(this.currency, this.amounts);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("JumpToDefault.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("amounts").append('=').append(JodaBeanUtils.toString(this.amounts));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", JumpToDefault.class, Currency.class);
        private final MetaProperty<ImmutableMap<StandardId, Double>> amounts = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"amounts", JumpToDefault.class, ImmutableMap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "amounts"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case -879772901: {
                    return this.amounts;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends JumpToDefault> builder() {
            return new Builder();
        }

        public Class<? extends JumpToDefault> beanType() {
            return JumpToDefault.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<ImmutableMap<StandardId, Double>> amounts() {
            return this.amounts;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((JumpToDefault)bean).getCurrency();
                }
                case -879772901: {
                    return ((JumpToDefault)bean).getAmounts();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

