/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.market.MarketDataView;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.ConstantCurve;
import com.opengamma.strata.market.curve.Curve;
import com.opengamma.strata.market.param.ParameterPerturbation;
import com.opengamma.strata.market.param.ParameterizedData;
import com.opengamma.strata.pricer.credit.ConstantRecoveryRates;
import java.time.LocalDate;

public interface RecoveryRates
extends MarketDataView,
ParameterizedData {
    public static RecoveryRates of(StandardId legalEntityId, LocalDate valuationDate, Curve curve) {
        if (curve.getMetadata().getYValueType().equals((Object)ValueType.RECOVERY_RATE)) {
            ConstantCurve constantCurve = (ConstantCurve)curve;
            return ConstantRecoveryRates.of(legalEntityId, valuationDate, constantCurve.getYValue());
        }
        throw new IllegalArgumentException("Unknown curve type");
    }

    public LocalDate getValuationDate();

    public StandardId getLegalEntityId();

    public double recoveryRate(LocalDate var1);

    public RecoveryRates withParameter(int var1, double var2);

    public RecoveryRates withPerturbation(ParameterPerturbation var1);
}

