/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.market.ValueType;
import com.opengamma.strata.market.curve.ConstantNodalCurve;
import com.opengamma.strata.market.curve.CurveMetadata;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.DefaultCurveMetadata;
import com.opengamma.strata.market.curve.InterpolatedNodalCurve;
import com.opengamma.strata.market.curve.NodalCurve;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolator;
import com.opengamma.strata.market.curve.interpolator.CurveExtrapolators;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolator;
import com.opengamma.strata.market.curve.interpolator.CurveInterpolators;
import com.opengamma.strata.math.impl.rootfinding.BracketRoot;
import com.opengamma.strata.math.impl.rootfinding.BrentSingleRootFinder;
import com.opengamma.strata.math.impl.rootfinding.RealSingleRootFinder;
import com.opengamma.strata.pricer.common.PriceType;
import com.opengamma.strata.pricer.credit.AccrualOnDefaultFormula;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import com.opengamma.strata.pricer.credit.ImmutableCreditRatesProvider;
import com.opengamma.strata.pricer.credit.IsdaCompliantCreditCurveCalibrator;
import com.opengamma.strata.pricer.credit.IsdaCreditDiscountFactors;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.pricer.credit.RecoveryRates;
import com.opengamma.strata.product.credit.ResolvedCds;
import com.opengamma.strata.product.credit.ResolvedCdsTrade;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class SimpleCreditCurveCalibrator
extends IsdaCompliantCreditCurveCalibrator {
    private static final SimpleCreditCurveCalibrator STANDARD = new SimpleCreditCurveCalibrator();
    private static final BracketRoot BRACKER = new BracketRoot();
    private static final RealSingleRootFinder ROOTFINDER = new BrentSingleRootFinder();

    public static SimpleCreditCurveCalibrator standard() {
        return STANDARD;
    }

    private SimpleCreditCurveCalibrator() {
    }

    public SimpleCreditCurveCalibrator(AccrualOnDefaultFormula formula) {
        super(formula);
    }

    @Override
    public NodalCurve calibrate(List<ResolvedCdsTrade> calibrationCDSs, DoubleArray premiums, DoubleArray pointsUpfront, CurveName name, LocalDate valuationDate, CreditDiscountFactors discountFactors, RecoveryRates recoveryRates, ReferenceData refData) {
        int n = calibrationCDSs.size();
        double[] guess = new double[n];
        double[] t = new double[n];
        double[] lgd = new double[n];
        for (int i = 0; i < n; ++i) {
            LocalDate endDate = calibrationCDSs.get(i).getProduct().getProtectionEndDate();
            t[i] = discountFactors.relativeYearFraction(endDate);
            lgd[i] = 1.0 - recoveryRates.recoveryRate(endDate);
            guess[i] = (premiums.get(i) + pointsUpfront.get(i) / t[i]) / lgd[i];
        }
        DoubleArray times = DoubleArray.ofUnsafe((double[])t);
        DefaultCurveMetadata baseMetadata = DefaultCurveMetadata.builder().xValueType(ValueType.YEAR_FRACTION).yValueType(ValueType.ZERO_RATE).curveName(name).dayCount(discountFactors.getDayCount()).build();
        ConstantNodalCurve creditCurve = n == 1 ? ConstantNodalCurve.of((CurveMetadata)baseMetadata, (double)t[0], (double)guess[0]) : InterpolatedNodalCurve.of((CurveMetadata)baseMetadata, (DoubleArray)times, (DoubleArray)DoubleArray.ofUnsafe((double[])guess), (CurveInterpolator)CurveInterpolators.PRODUCT_LINEAR, (CurveExtrapolator)CurveExtrapolators.FLAT, (CurveExtrapolator)CurveExtrapolators.PRODUCT_LINEAR);
        for (int i = 0; i < n; ++i) {
            Function<Double, Double> func = this.getPriceFunction(i, calibrationCDSs.get(i), premiums.get(i), pointsUpfront.get(i), valuationDate, (NodalCurve)creditCurve, discountFactors, recoveryRates, refData);
            double[] bracket = BRACKER.getBracketedPoints(func, 0.8 * guess[i], 1.25 * guess[i], 0.0, Double.POSITIVE_INFINITY);
            double zeroRate = bracket[0] > bracket[1] ? ROOTFINDER.getRoot(func, Double.valueOf(bracket[1]), Double.valueOf(bracket[0])) : ROOTFINDER.getRoot(func, Double.valueOf(bracket[0]), Double.valueOf(bracket[1]));
            creditCurve = creditCurve.withParameter(i, zeroRate);
        }
        return creditCurve;
    }

    private Function<Double, Double> getPriceFunction(final int index, final ResolvedCdsTrade cds, final double flactionalSpread, final double pointsUpfront, final LocalDate valuationDate, final NodalCurve creditCurve, CreditDiscountFactors discountFactors, RecoveryRates recoveryRates, final ReferenceData refData) {
        ResolvedCds cdsProduct = cds.getProduct();
        final Currency currency = cdsProduct.getCurrency();
        final StandardId legalEntityId = cdsProduct.getLegalEntityId();
        final Pair pair = Pair.of((Object)legalEntityId, (Object)currency);
        final ImmutableCreditRatesProvider ratesbase = ImmutableCreditRatesProvider.builder().valuationDate(valuationDate).discountCurves((Map<Currency, CreditDiscountFactors>)ImmutableMap.of((Object)currency, (Object)discountFactors)).recoveryRateCurves((Map<StandardId, RecoveryRates>)ImmutableMap.of((Object)legalEntityId, (Object)recoveryRates)).build();
        Function<Double, Double> func = new Function<Double, Double>(){

            @Override
            public Double apply(Double x) {
                NodalCurve tempCreditCurve = creditCurve.withParameter(index, x.doubleValue());
                ImmutableCreditRatesProvider rates = ratesbase.toBuilder().creditCurves((Map<Pair<StandardId, Currency>, LegalEntitySurvivalProbabilities>)ImmutableMap.of((Object)pair, (Object)LegalEntitySurvivalProbabilities.of(legalEntityId, IsdaCreditDiscountFactors.of(currency, valuationDate, tempCreditCurve)))).build();
                double price = SimpleCreditCurveCalibrator.this.getTradePricer().price(cds, rates, flactionalSpread, PriceType.CLEAN, refData);
                return price - pointsUpfront;
            }
        };
        return func;
    }
}

