/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.credit;

import com.google.common.collect.ImmutableList;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.StandardId;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.data.MarketDataName;
import com.opengamma.strata.market.curve.CurveInfoType;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.param.CurrencyParameterSensitivity;
import com.opengamma.strata.market.param.ParameterMetadata;
import com.opengamma.strata.market.param.ResolvedTradeParameterMetadata;
import com.opengamma.strata.pricer.credit.AccrualOnDefaultFormula;
import com.opengamma.strata.pricer.credit.CreditDiscountFactors;
import com.opengamma.strata.pricer.credit.CreditRatesProvider;
import com.opengamma.strata.pricer.credit.FastCreditCurveCalibrator;
import com.opengamma.strata.pricer.credit.IsdaCdsTradePricer;
import com.opengamma.strata.pricer.credit.IsdaCompliantCreditCurveCalibrator;
import com.opengamma.strata.pricer.credit.IsdaCreditDiscountFactors;
import com.opengamma.strata.pricer.credit.LegalEntitySurvivalProbabilities;
import com.opengamma.strata.product.ResolvedTrade;
import com.opengamma.strata.product.credit.ResolvedCds;
import com.opengamma.strata.product.credit.ResolvedCdsIndex;
import com.opengamma.strata.product.credit.ResolvedCdsIndexTrade;
import com.opengamma.strata.product.credit.ResolvedCdsTrade;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public abstract class SpreadSensitivityCalculator {
    private final IsdaCdsTradePricer pricer;
    private final IsdaCompliantCreditCurveCalibrator calibrator;

    public SpreadSensitivityCalculator(AccrualOnDefaultFormula formula) {
        this.pricer = new IsdaCdsTradePricer(formula);
        this.calibrator = new FastCreditCurveCalibrator(formula);
    }

    protected IsdaCdsTradePricer getPricer() {
        return this.pricer;
    }

    protected IsdaCompliantCreditCurveCalibrator getCalibrator() {
        return this.calibrator;
    }

    public CurrencyAmount parallelCs01(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        ImmutableList<ResolvedCdsTrade> bucketCds = this.getBucketCds(trade.getProduct(), ratesProvider);
        return this.parallelCs01(trade, (List<ResolvedCdsTrade>)bucketCds, ratesProvider, refData);
    }

    public abstract CurrencyAmount parallelCs01(ResolvedCdsTrade var1, List<ResolvedCdsTrade> var2, CreditRatesProvider var3, ReferenceData var4);

    public CurrencyParameterSensitivity bucketedCs01(ResolvedCdsTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        ImmutableList<ResolvedCdsTrade> bucketCds = this.getBucketCds(trade.getProduct(), ratesProvider);
        return this.bucketedCs01(trade, (List<ResolvedCdsTrade>)bucketCds, ratesProvider, refData);
    }

    public CurrencyParameterSensitivity bucketedCs01(ResolvedCdsTrade trade, List<ResolvedCdsTrade> bucketCds, CreditRatesProvider ratesProvider, ReferenceData refData) {
        List metadata = (List)bucketCds.stream().map(t -> ResolvedTradeParameterMetadata.of((ResolvedTrade)t, (String)t.getProduct().getProtectionEndDate().toString())).collect(Guavate.toImmutableList());
        return this.bucketedCs01(trade, bucketCds, metadata, ratesProvider, refData);
    }

    private CurrencyParameterSensitivity bucketedCs01(ResolvedCdsTrade trade, List<ResolvedCdsTrade> bucketCds, List<ResolvedTradeParameterMetadata> metadata, CreditRatesProvider ratesProvider, ReferenceData refData) {
        DoubleArray sensiValue = this.computedBucketedCs01(trade, bucketCds, ratesProvider, refData);
        return CurrencyParameterSensitivity.of((MarketDataName)CurveName.of((String)"impliedSpreads"), metadata, (Currency)trade.getProduct().getCurrency(), (DoubleArray)sensiValue);
    }

    public CurrencyAmount parallelCs01(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        ImmutableList<ResolvedCdsIndexTrade> bucketCdsIndex = this.getBucketCdsIndex(trade.getProduct(), ratesProvider);
        return this.parallelCs01(trade, (List<ResolvedCdsIndexTrade>)bucketCdsIndex, ratesProvider, refData);
    }

    public CurrencyAmount parallelCs01(ResolvedCdsIndexTrade trade, List<ResolvedCdsIndexTrade> bucketCdsIndex, CreditRatesProvider ratesProvider, ReferenceData refData) {
        ResolvedCdsTrade cdsTrade = trade.toSingleNameCds();
        List<ResolvedCdsTrade> bucketCds = bucketCdsIndex.stream().map(ResolvedCdsIndexTrade::toSingleNameCds).collect(Collectors.toList());
        CurrencyAmount cs01Cds = this.parallelCs01(cdsTrade, bucketCds, ratesProvider, refData);
        double indexFactor = this.getIndexFactor(cdsTrade.getProduct(), ratesProvider);
        return cs01Cds.multipliedBy(indexFactor);
    }

    public CurrencyParameterSensitivity bucketedCs01(ResolvedCdsIndexTrade trade, CreditRatesProvider ratesProvider, ReferenceData refData) {
        ImmutableList<ResolvedCdsIndexTrade> bucketCdsIndex = this.getBucketCdsIndex(trade.getProduct(), ratesProvider);
        return this.bucketedCs01(trade, (List<ResolvedCdsIndexTrade>)bucketCdsIndex, ratesProvider, refData);
    }

    public CurrencyParameterSensitivity bucketedCs01(ResolvedCdsIndexTrade trade, List<ResolvedCdsIndexTrade> bucketCdsIndex, CreditRatesProvider ratesProvider, ReferenceData refData) {
        ResolvedCdsTrade cdsTrade = trade.toSingleNameCds();
        List<ResolvedCdsTrade> bucketCds = bucketCdsIndex.stream().map(ResolvedCdsIndexTrade::toSingleNameCds).collect(Collectors.toList());
        List metadata = (List)bucketCdsIndex.stream().map(t -> ResolvedTradeParameterMetadata.of((ResolvedTrade)t, (String)t.getProduct().getProtectionEndDate().toString())).collect(Guavate.toImmutableList());
        CurrencyParameterSensitivity bucketedCs01 = this.bucketedCs01(cdsTrade, bucketCds, metadata, ratesProvider, refData);
        double indexFactor = this.getIndexFactor(cdsTrade.getProduct(), ratesProvider);
        return bucketedCs01.multipliedBy(indexFactor);
    }

    private ImmutableList<ResolvedCdsTrade> getBucketCds(ResolvedCds product, CreditRatesProvider ratesProvider) {
        CreditDiscountFactors creditCurve = ratesProvider.survivalProbabilities(product.getLegalEntityId(), product.getCurrency()).getSurvivalProbabilities();
        int nNodes = creditCurve.getParameterCount();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < nNodes; ++i) {
            ParameterMetadata metadata = creditCurve.getParameterMetadata(i);
            ArgChecker.isTrue((boolean)(metadata instanceof ResolvedTradeParameterMetadata), (String)"ParameterMetadata of credit curve must be ResolvedTradeParameterMetadata");
            ResolvedTradeParameterMetadata tradeMetadata = (ResolvedTradeParameterMetadata)metadata;
            ResolvedTrade trade = tradeMetadata.getTrade();
            ArgChecker.isTrue((boolean)(trade instanceof ResolvedCdsTrade), (String)"ResolvedTrade must be ResolvedCdsTrade");
            builder.add((Object)((ResolvedCdsTrade)trade));
        }
        return builder.build();
    }

    private ImmutableList<ResolvedCdsIndexTrade> getBucketCdsIndex(ResolvedCdsIndex product, CreditRatesProvider ratesProvider) {
        CreditDiscountFactors creditCurve = ratesProvider.survivalProbabilities(product.getCdsIndexId(), product.getCurrency()).getSurvivalProbabilities();
        int nNodes = creditCurve.getParameterCount();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < nNodes; ++i) {
            ParameterMetadata metadata = creditCurve.getParameterMetadata(i);
            ArgChecker.isTrue((boolean)(metadata instanceof ResolvedTradeParameterMetadata), (String)"ParameterMetadata of credit curve must be ResolvedTradeParameterMetadata");
            ResolvedTradeParameterMetadata tradeMetadata = (ResolvedTradeParameterMetadata)metadata;
            ResolvedTrade trade = tradeMetadata.getTrade();
            ArgChecker.isTrue((boolean)(trade instanceof ResolvedCdsIndexTrade), (String)"ResolvedTrade must be ResolvedCdsIndexTrade");
            builder.add((Object)((ResolvedCdsIndexTrade)trade));
        }
        return builder.build();
    }

    abstract DoubleArray computedBucketedCs01(ResolvedCdsTrade var1, List<ResolvedCdsTrade> var2, CreditRatesProvider var3, ReferenceData var4);

    protected void checkCdsBucket(ResolvedCdsTrade trade, List<ResolvedCdsTrade> bucketCds) {
        Iterator legalEntities = bucketCds.stream().map(t -> t.getProduct().getLegalEntityId()).collect(Collectors.toSet()).iterator();
        ArgChecker.isTrue((boolean)((StandardId)legalEntities.next()).equals((Object)trade.getProduct().getLegalEntityId()), (String)"legal entity must be common");
        ArgChecker.isFalse((boolean)legalEntities.hasNext(), (String)"legal entity must be common");
        Iterator currencies = bucketCds.stream().map(t -> t.getProduct().getCurrency()).collect(Collectors.toSet()).iterator();
        ArgChecker.isTrue((boolean)((Currency)currencies.next()).equals((Object)trade.getProduct().getCurrency()), (String)"currency must be common");
        ArgChecker.isFalse((boolean)currencies.hasNext(), (String)"currency must be common");
    }

    protected DoubleArray impliedSpread(List<ResolvedCdsTrade> bucketCds, CreditRatesProvider ratesProvider, ReferenceData refData) {
        int size = bucketCds.size();
        return DoubleArray.of((int)size, n -> this.pricer.parSpread((ResolvedCdsTrade)bucketCds.get(n), ratesProvider, refData));
    }

    private double getIndexFactor(ResolvedCds cds, CreditRatesProvider ratesProvider) {
        LegalEntitySurvivalProbabilities survivalProbabilities = ratesProvider.survivalProbabilities(cds.getLegalEntityId(), cds.getCurrency());
        double indexFactor = (Double)((IsdaCreditDiscountFactors)survivalProbabilities.getSurvivalProbabilities()).getCurve().getMetadata().getInfo(CurveInfoType.CDS_INDEX_FACTOR);
        return indexFactor;
    }
}

