/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.curve;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.market.curve.CurveParameterSize;
import com.opengamma.strata.pricer.curve.CalibrationMeasures;
import com.opengamma.strata.pricer.curve.RatesProviderGenerator;
import com.opengamma.strata.pricer.rate.ImmutableRatesProvider;
import com.opengamma.strata.product.ResolvedTrade;
import java.util.List;
import java.util.function.Function;

class CalibrationDerivative
implements Function<DoubleArray, DoubleMatrix> {
    private final List<ResolvedTrade> trades;
    private final CalibrationMeasures measures;
    private final RatesProviderGenerator providerGenerator;
    private final List<CurveParameterSize> curveOrder;

    public CalibrationDerivative(List<ResolvedTrade> trades, CalibrationMeasures measures, RatesProviderGenerator providerGenerator, List<CurveParameterSize> curveOrder) {
        this.measures = measures;
        this.trades = trades;
        this.providerGenerator = providerGenerator;
        this.curveOrder = curveOrder;
    }

    @Override
    public DoubleMatrix apply(DoubleArray x) {
        ImmutableRatesProvider provider = this.providerGenerator.generate(x);
        int size = this.trades.size();
        return DoubleMatrix.ofArrayObjects((int)size, (int)size, i -> this.measures.derivative(this.trades.get(i), provider, this.curveOrder));
    }
}

