/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.curve;

import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.pricer.curve.CalibrationMeasures;
import com.opengamma.strata.pricer.curve.RatesProviderGenerator;
import com.opengamma.strata.pricer.rate.ImmutableRatesProvider;
import com.opengamma.strata.product.ResolvedTrade;
import java.util.List;
import java.util.function.Function;

class CalibrationValue
implements Function<DoubleArray, DoubleArray> {
    private final List<ResolvedTrade> trades;
    private final CalibrationMeasures measures;
    private final RatesProviderGenerator providerGenerator;

    CalibrationValue(List<ResolvedTrade> trades, CalibrationMeasures measures, RatesProviderGenerator providerGenerator) {
        this.trades = trades;
        this.measures = measures;
        this.providerGenerator = providerGenerator;
    }

    @Override
    public DoubleArray apply(DoubleArray x) {
        ImmutableRatesProvider childProvider = this.providerGenerator.generate(x);
        return DoubleArray.of((int)this.trades.size(), i -> this.measures.value(this.trades.get(i), childProvider));
    }
}

