/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.curve;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.curve.CalibrationMeasure;
import com.opengamma.strata.pricer.deposit.DiscountingIborFixingDepositProductPricer;
import com.opengamma.strata.pricer.deposit.DiscountingTermDepositProductPricer;
import com.opengamma.strata.pricer.fra.DiscountingFraProductPricer;
import com.opengamma.strata.pricer.index.DiscountingIborFutureProductPricer;
import com.opengamma.strata.pricer.index.DiscountingOvernightFutureProductPricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.product.ResolvedTrade;
import com.opengamma.strata.product.deposit.ResolvedIborFixingDepositTrade;
import com.opengamma.strata.product.deposit.ResolvedTermDepositTrade;
import com.opengamma.strata.product.fra.ResolvedFraTrade;
import com.opengamma.strata.product.index.ResolvedIborFutureTrade;
import com.opengamma.strata.product.index.ResolvedOvernightFutureTrade;
import com.opengamma.strata.product.swap.ResolvedSwapTrade;
import java.util.function.BiFunction;
import java.util.function.ToDoubleBiFunction;

public final class MarketQuoteMeasure<T extends ResolvedTrade>
implements CalibrationMeasure<T> {
    public static final MarketQuoteMeasure<ResolvedFraTrade> FRA_MQ = MarketQuoteMeasure.of("FraParRateDiscounting", ResolvedFraTrade.class, (trade, p) -> DiscountingFraProductPricer.DEFAULT.parRate(trade.getProduct(), (RatesProvider)p), (trade, p) -> DiscountingFraProductPricer.DEFAULT.parRateSensitivity(trade.getProduct(), (RatesProvider)p));
    public static final MarketQuoteMeasure<ResolvedIborFutureTrade> IBOR_FUTURE_MQ = MarketQuoteMeasure.of("IborFuturePriceDiscounting", ResolvedIborFutureTrade.class, (trade, p) -> DiscountingIborFutureProductPricer.DEFAULT.price(trade.getProduct(), (RatesProvider)p), (trade, p) -> DiscountingIborFutureProductPricer.DEFAULT.priceSensitivity(trade.getProduct(), (RatesProvider)p));
    public static final MarketQuoteMeasure<ResolvedOvernightFutureTrade> OVERNIGHT_FUTURE_MQ = MarketQuoteMeasure.of("OvernightFuturePriceDiscounting", ResolvedOvernightFutureTrade.class, (trade, p) -> DiscountingOvernightFutureProductPricer.DEFAULT.price(trade.getProduct(), (RatesProvider)p), (trade, p) -> DiscountingOvernightFutureProductPricer.DEFAULT.priceSensitivity(trade.getProduct(), (RatesProvider)p));
    public static final MarketQuoteMeasure<ResolvedSwapTrade> SWAP_MQ = MarketQuoteMeasure.of("SwapParRateDiscounting", ResolvedSwapTrade.class, (trade, p) -> DiscountingSwapProductPricer.DEFAULT.marketQuote(trade.getProduct(), (RatesProvider)p), (trade, p) -> DiscountingSwapProductPricer.DEFAULT.marketQuoteSensitivity(trade.getProduct(), (RatesProvider)p).build());
    public static final MarketQuoteMeasure<ResolvedIborFixingDepositTrade> IBOR_FIXING_DEPOSIT_MQ = MarketQuoteMeasure.of("IborFixingDepositParRateDiscounting", ResolvedIborFixingDepositTrade.class, (trade, p) -> DiscountingIborFixingDepositProductPricer.DEFAULT.parRate(trade.getProduct(), (RatesProvider)p), (trade, p) -> DiscountingIborFixingDepositProductPricer.DEFAULT.parRateSensitivity(trade.getProduct(), (RatesProvider)p));
    public static final MarketQuoteMeasure<ResolvedTermDepositTrade> TERM_DEPOSIT_MQ = MarketQuoteMeasure.of("TermDepositParRateDiscounting", ResolvedTermDepositTrade.class, (trade, p) -> DiscountingTermDepositProductPricer.DEFAULT.parRate(trade.getProduct(), (RatesProvider)p), (trade, p) -> DiscountingTermDepositProductPricer.DEFAULT.parRateSensitivity(trade.getProduct(), (RatesProvider)p));
    private final String name;
    private final Class<T> tradeType;
    private final ToDoubleBiFunction<T, RatesProvider> valueFn;
    private final BiFunction<T, RatesProvider, PointSensitivities> sensitivityFn;

    public static <R extends ResolvedTrade> MarketQuoteMeasure<R> of(String name, Class<R> tradeType, ToDoubleBiFunction<R, RatesProvider> valueFn, BiFunction<R, RatesProvider, PointSensitivities> sensitivityFn) {
        return new MarketQuoteMeasure<R>(name, tradeType, valueFn, sensitivityFn);
    }

    private MarketQuoteMeasure(String name, Class<T> tradeType, ToDoubleBiFunction<T, RatesProvider> valueFn, BiFunction<T, RatesProvider, PointSensitivities> sensitivityFn) {
        this.name = name;
        this.tradeType = tradeType;
        this.valueFn = (ToDoubleBiFunction)ArgChecker.notNull(valueFn, (String)"valueFn");
        this.sensitivityFn = (BiFunction)ArgChecker.notNull(sensitivityFn, (String)"sensitivityFn");
    }

    @Override
    public Class<T> getTradeType() {
        return this.tradeType;
    }

    @Override
    public double value(T trade, RatesProvider provider) {
        return this.valueFn.applyAsDouble(trade, provider);
    }

    @Override
    public CurrencyParameterSensitivities sensitivities(T trade, RatesProvider provider) {
        PointSensitivities pts = this.sensitivityFn.apply(trade, provider);
        return provider.parameterSensitivity(pts);
    }

    public String toString() {
        return this.name;
    }
}

