/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.curve;

import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.market.param.CurrencyParameterSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.pricer.curve.CalibrationMeasure;
import com.opengamma.strata.pricer.deposit.DiscountingIborFixingDepositProductPricer;
import com.opengamma.strata.pricer.deposit.DiscountingTermDepositProductPricer;
import com.opengamma.strata.pricer.fra.DiscountingFraProductPricer;
import com.opengamma.strata.pricer.index.DiscountingIborFutureTradePricer;
import com.opengamma.strata.pricer.index.DiscountingOvernightFutureTradePricer;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.pricer.sensitivity.MarketQuoteSensitivityCalculator;
import com.opengamma.strata.pricer.swap.DiscountingSwapProductPricer;
import com.opengamma.strata.product.ResolvedTrade;
import com.opengamma.strata.product.deposit.ResolvedIborFixingDepositTrade;
import com.opengamma.strata.product.deposit.ResolvedTermDepositTrade;
import com.opengamma.strata.product.fra.ResolvedFraTrade;
import com.opengamma.strata.product.index.ResolvedIborFutureTrade;
import com.opengamma.strata.product.index.ResolvedOvernightFutureTrade;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.ResolvedSwapTrade;
import java.util.function.BiFunction;
import java.util.function.ToDoubleBiFunction;

public final class PresentValueCalibrationMeasure<T extends ResolvedTrade>
implements CalibrationMeasure<T> {
    private static final MarketQuoteSensitivityCalculator MQC = MarketQuoteSensitivityCalculator.DEFAULT;
    public static final PresentValueCalibrationMeasure<ResolvedFraTrade> FRA_PV = PresentValueCalibrationMeasure.of("FraPresentValueDiscounting", ResolvedFraTrade.class, (trade, p) -> DiscountingFraProductPricer.DEFAULT.presentValue(trade.getProduct(), (RatesProvider)p).getAmount(), (trade, p) -> DiscountingFraProductPricer.DEFAULT.presentValueSensitivity(trade.getProduct(), (RatesProvider)p));
    public static final PresentValueCalibrationMeasure<ResolvedIborFutureTrade> IBOR_FUTURE_PV = PresentValueCalibrationMeasure.of("IborFuturePresentValueDiscounting", ResolvedIborFutureTrade.class, (trade, p) -> DiscountingIborFutureTradePricer.DEFAULT.presentValue((ResolvedIborFutureTrade)trade, (RatesProvider)p, 0.0).getAmount(), (trade, p) -> DiscountingIborFutureTradePricer.DEFAULT.presentValueSensitivity((ResolvedIborFutureTrade)trade, (RatesProvider)p));
    public static final PresentValueCalibrationMeasure<ResolvedOvernightFutureTrade> OVERNIGHT_FUTURE_PV = PresentValueCalibrationMeasure.of("OvernightFuturePresentValueDiscounting", ResolvedOvernightFutureTrade.class, (trade, p) -> DiscountingOvernightFutureTradePricer.DEFAULT.presentValue((ResolvedOvernightFutureTrade)trade, (RatesProvider)p, 0.0).getAmount(), (trade, p) -> DiscountingOvernightFutureTradePricer.DEFAULT.presentValueSensitivity((ResolvedOvernightFutureTrade)trade, (RatesProvider)p));
    public static final PresentValueCalibrationMeasure<ResolvedSwapTrade> SWAP_PV = PresentValueCalibrationMeasure.of("SwapPresentValueDiscounting", ResolvedSwapTrade.class, (trade, p) -> DiscountingSwapProductPricer.DEFAULT.presentValue(trade.getProduct(), (RatesProvider)p).convertedTo(((ResolvedSwapLeg)trade.getProduct().getLegs().get(0)).getCurrency(), (FxRateProvider)p).getAmount(), (trade, p) -> DiscountingSwapProductPricer.DEFAULT.presentValueSensitivity(trade.getProduct(), (RatesProvider)p).build().convertedTo(((ResolvedSwapLeg)trade.getProduct().getLegs().get(0)).getCurrency(), (FxRateProvider)p));
    public static final PresentValueCalibrationMeasure<ResolvedIborFixingDepositTrade> IBOR_FIXING_DEPOSIT_PV = PresentValueCalibrationMeasure.of("IborFixingDepositPresentValueDiscounting", ResolvedIborFixingDepositTrade.class, (trade, p) -> DiscountingIborFixingDepositProductPricer.DEFAULT.presentValue(trade.getProduct(), (RatesProvider)p).getAmount(), (trade, p) -> DiscountingIborFixingDepositProductPricer.DEFAULT.presentValueSensitivity(trade.getProduct(), (RatesProvider)p));
    public static final PresentValueCalibrationMeasure<ResolvedTermDepositTrade> TERM_DEPOSIT_PV = PresentValueCalibrationMeasure.of("TermDepositPresentValueDiscounting", ResolvedTermDepositTrade.class, (trade, p) -> DiscountingTermDepositProductPricer.DEFAULT.presentValue(trade.getProduct(), (RatesProvider)p).getAmount(), (trade, p) -> DiscountingTermDepositProductPricer.DEFAULT.presentValueSensitivity(trade.getProduct(), (RatesProvider)p));
    private final String name;
    private final Class<T> tradeType;
    private final ToDoubleBiFunction<T, RatesProvider> valueFn;
    private final BiFunction<T, RatesProvider, PointSensitivities> sensitivityFn;

    public static <R extends ResolvedTrade> PresentValueCalibrationMeasure<R> of(String name, Class<R> tradeType, ToDoubleBiFunction<R, RatesProvider> valueFn, BiFunction<R, RatesProvider, PointSensitivities> sensitivityFn) {
        return new PresentValueCalibrationMeasure<R>(name, tradeType, valueFn, sensitivityFn);
    }

    private PresentValueCalibrationMeasure(String name, Class<T> tradeType, ToDoubleBiFunction<T, RatesProvider> valueFn, BiFunction<T, RatesProvider, PointSensitivities> sensitivityFn) {
        this.name = name;
        this.tradeType = tradeType;
        this.valueFn = (ToDoubleBiFunction)ArgChecker.notNull(valueFn, (String)"valueFn");
        this.sensitivityFn = (BiFunction)ArgChecker.notNull(sensitivityFn, (String)"sensitivityFn");
    }

    @Override
    public Class<T> getTradeType() {
        return this.tradeType;
    }

    @Override
    public double value(T trade, RatesProvider provider) {
        return this.valueFn.applyAsDouble(trade, provider);
    }

    @Override
    public CurrencyParameterSensitivities sensitivities(T trade, RatesProvider provider) {
        PointSensitivities pts = this.sensitivityFn.apply(trade, provider);
        CurrencyParameterSensitivities ps = provider.parameterSensitivity(pts);
        return MQC.sensitivity(ps, provider);
    }

    public String toString() {
        return this.name;
    }
}

