/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.curve;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.FxRateProvider;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.DoubleMatrix;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.data.MarketData;
import com.opengamma.strata.data.MarketDataFxRateProvider;
import com.opengamma.strata.data.ObservableId;
import com.opengamma.strata.market.curve.CurveName;
import com.opengamma.strata.market.curve.CurveParameterSize;
import com.opengamma.strata.market.curve.JacobianCalibrationMatrix;
import com.opengamma.strata.market.curve.RatesCurveGroupDefinition;
import com.opengamma.strata.market.observable.IndexQuoteId;
import com.opengamma.strata.math.impl.matrix.CommonsMatrixAlgebra;
import com.opengamma.strata.math.impl.matrix.MatrixAlgebra;
import com.opengamma.strata.math.rootfind.NewtonVectorRootFinder;
import com.opengamma.strata.pricer.curve.CalibrationDerivative;
import com.opengamma.strata.pricer.curve.CalibrationMeasures;
import com.opengamma.strata.pricer.curve.CalibrationValue;
import com.opengamma.strata.pricer.curve.ImmutableRatesProviderGenerator;
import com.opengamma.strata.pricer.curve.RatesProviderGenerator;
import com.opengamma.strata.pricer.rate.ImmutableRatesProvider;
import com.opengamma.strata.product.ResolvedTrade;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class RatesCurveCalibrator {
    private static final RatesCurveCalibrator STANDARD = RatesCurveCalibrator.of(1.0E-9, 1.0E-9, 1000, CalibrationMeasures.PAR_SPREAD, CalibrationMeasures.PRESENT_VALUE);
    private static final MatrixAlgebra MATRIX_ALGEBRA = new CommonsMatrixAlgebra();
    private final NewtonVectorRootFinder rootFinder;
    private final CalibrationMeasures measures;
    private final CalibrationMeasures pvMeasures;

    public static RatesCurveCalibrator standard() {
        return STANDARD;
    }

    public static RatesCurveCalibrator of(double toleranceAbs, double toleranceRel, int stepMaximum) {
        return RatesCurveCalibrator.of(toleranceAbs, toleranceRel, stepMaximum, CalibrationMeasures.PAR_SPREAD, CalibrationMeasures.PRESENT_VALUE);
    }

    public static RatesCurveCalibrator of(double toleranceAbs, double toleranceRel, int stepMaximum, CalibrationMeasures measures) {
        return RatesCurveCalibrator.of(toleranceAbs, toleranceRel, stepMaximum, measures, CalibrationMeasures.PRESENT_VALUE);
    }

    public static RatesCurveCalibrator of(double toleranceAbs, double toleranceRel, int stepMaximum, CalibrationMeasures measures, CalibrationMeasures pvMeasures) {
        NewtonVectorRootFinder rootFinder = NewtonVectorRootFinder.broyden((double)toleranceAbs, (double)toleranceRel, (int)stepMaximum);
        return new RatesCurveCalibrator(rootFinder, measures, pvMeasures);
    }

    public static RatesCurveCalibrator of(NewtonVectorRootFinder rootFinder, CalibrationMeasures measures, CalibrationMeasures pvMeasures) {
        return new RatesCurveCalibrator(rootFinder, measures, pvMeasures);
    }

    private RatesCurveCalibrator(NewtonVectorRootFinder rootFinder, CalibrationMeasures measures, CalibrationMeasures pvMeasures) {
        this.rootFinder = (NewtonVectorRootFinder)ArgChecker.notNull((Object)rootFinder, (String)"rootFinder");
        this.measures = (CalibrationMeasures)ArgChecker.notNull((Object)measures, (String)"measures");
        this.pvMeasures = (CalibrationMeasures)ArgChecker.notNull((Object)pvMeasures, (String)"pvMeasures");
    }

    public CalibrationMeasures getMeasures() {
        return this.measures;
    }

    public ImmutableRatesProvider calibrate(RatesCurveGroupDefinition curveGroupDefn, MarketData marketData, ReferenceData refData) {
        Map timeSeries = (Map)marketData.getTimeSeriesIds().stream().flatMap(Guavate.filtering(IndexQuoteId.class)).collect(Guavate.toImmutableMap(id -> id.getIndex(), id -> marketData.getTimeSeries((ObservableId)id)));
        ImmutableRatesProvider knownData = ImmutableRatesProvider.builder(marketData.getValuationDate()).fxRateProvider((FxRateProvider)MarketDataFxRateProvider.of((MarketData)marketData)).timeSeries(timeSeries).build();
        return this.calibrate((List<RatesCurveGroupDefinition>)ImmutableList.of((Object)curveGroupDefn), knownData, marketData, refData);
    }

    public ImmutableRatesProvider calibrate(List<RatesCurveGroupDefinition> allGroupDefns, ImmutableRatesProvider knownData, MarketData marketData, ReferenceData refData) {
        if (!knownData.getValuationDate().equals(marketData.getValuationDate())) {
            throw new IllegalArgumentException(Messages.format((String)"Valuation dates do not match: {} and {}", (Object[])new Object[]{knownData.getValuationDate(), marketData.getValuationDate()}));
        }
        ImmutableRatesProvider providerCombined = knownData;
        ImmutableList orderPrev = ImmutableList.of();
        ImmutableMap<CurveName, JacobianCalibrationMatrix> jacobians = ImmutableMap.of();
        for (RatesCurveGroupDefinition groupDefn : allGroupDefns) {
            if (groupDefn.getEntries().isEmpty()) continue;
            RatesCurveGroupDefinition groupDefnBound = groupDefn.bindTimeSeries(knownData.getValuationDate(), knownData.getTimeSeries());
            ImmutableList trades = groupDefnBound.resolvedTrades(marketData, refData);
            ImmutableList initialGuesses = groupDefnBound.initialGuesses(marketData);
            ImmutableList<CurveParameterSize> orderGroup = RatesCurveCalibrator.toOrder(groupDefnBound);
            ImmutableList orderPrevAndGroup = ImmutableList.builder().addAll((Iterable)orderPrev).addAll(orderGroup).build();
            ImmutableRatesProviderGenerator providerGenerator = ImmutableRatesProviderGenerator.of(providerCombined, groupDefnBound, refData);
            DoubleArray calibratedGroupParams = this.calibrateGroup(providerGenerator, (ImmutableList<ResolvedTrade>)trades, (ImmutableList<Double>)initialGuesses, orderGroup);
            ImmutableRatesProvider calibratedProvider = providerGenerator.generate(calibratedGroupParams);
            if (groupDefnBound.isComputeJacobian()) {
                jacobians = this.updateJacobiansForGroup(calibratedProvider, (ImmutableList<ResolvedTrade>)trades, orderGroup, (ImmutableList<CurveParameterSize>)orderPrev, (ImmutableList<CurveParameterSize>)orderPrevAndGroup, jacobians);
            }
            ImmutableMap<CurveName, DoubleArray> sensitivityToMarketQuote = ImmutableMap.of();
            if (groupDefnBound.isComputePvSensitivityToMarketQuote()) {
                ImmutableRatesProvider providerWithJacobian = providerGenerator.generate(calibratedGroupParams, (Map<CurveName, JacobianCalibrationMatrix>)jacobians);
                sensitivityToMarketQuote = this.sensitivityToMarketQuoteForGroup(providerWithJacobian, (ImmutableList<ResolvedTrade>)trades, orderGroup);
            }
            orderPrev = orderPrevAndGroup;
            providerCombined = providerGenerator.generate(calibratedGroupParams, (Map<CurveName, JacobianCalibrationMatrix>)jacobians, (Map<CurveName, DoubleArray>)sensitivityToMarketQuote);
        }
        return providerCombined;
    }

    private static ImmutableList<CurveParameterSize> toOrder(RatesCurveGroupDefinition groupDefn) {
        return (ImmutableList)groupDefn.getCurveDefinitions().stream().map(def -> def.toCurveParameterSize()).collect(Guavate.toImmutableList());
    }

    private DoubleArray calibrateGroup(RatesProviderGenerator providerGenerator, ImmutableList<ResolvedTrade> trades, ImmutableList<Double> initialGuesses, ImmutableList<CurveParameterSize> curveOrder) {
        CalibrationValue valueCalculator = new CalibrationValue((List<ResolvedTrade>)trades, this.measures, providerGenerator);
        CalibrationDerivative derivativeCalculator = new CalibrationDerivative((List<ResolvedTrade>)trades, this.measures, providerGenerator, (List<CurveParameterSize>)curveOrder);
        DoubleArray initialGuess = DoubleArray.copyOf(initialGuesses);
        return this.rootFinder.findRoot((Function)valueCalculator, (Function)derivativeCalculator, initialGuess);
    }

    private ImmutableMap<CurveName, JacobianCalibrationMatrix> updateJacobiansForGroup(ImmutableRatesProvider provider, ImmutableList<ResolvedTrade> trades, ImmutableList<CurveParameterSize> orderGroup, ImmutableList<CurveParameterSize> orderPrev, ImmutableList<CurveParameterSize> orderAll, ImmutableMap<CurveName, JacobianCalibrationMatrix> jacobians) {
        int totalParamsAll = orderAll.stream().mapToInt(e -> e.getParameterCount()).sum();
        DoubleMatrix res = this.derivatives(trades, provider, orderAll, totalParamsAll);
        int nbTrades = trades.size();
        int totParamsGroup = orderGroup.stream().mapToInt(e -> e.getParameterCount()).sum();
        int totParamsPrev = totalParamsAll - totParamsGroup;
        DoubleMatrix pDmCurMatrix = RatesCurveCalibrator.jacobianDirect(res, nbTrades, totParamsGroup, totParamsPrev);
        DoubleMatrix pDmPrev = RatesCurveCalibrator.jacobianIndirect(res, pDmCurMatrix, nbTrades, totParamsGroup, totParamsPrev, orderPrev, jacobians);
        ImmutableMap.Builder jacobianBuilder = ImmutableMap.builder();
        jacobianBuilder.putAll(jacobians);
        int startIndex = 0;
        for (CurveParameterSize order : orderGroup) {
            int p;
            int paramCount = order.getParameterCount();
            double[][] pDmCurveArray = new double[paramCount][totalParamsAll];
            if (totParamsPrev > 0) {
                for (p = 0; p < paramCount; ++p) {
                    System.arraycopy(pDmPrev.rowArray(startIndex + p), 0, pDmCurveArray[p], 0, totParamsPrev);
                }
            }
            for (p = 0; p < paramCount; ++p) {
                System.arraycopy(pDmCurMatrix.rowArray(startIndex + p), 0, pDmCurveArray[p], totParamsPrev, totParamsGroup);
            }
            DoubleMatrix pDmCurveMatrix = DoubleMatrix.ofUnsafe((double[][])pDmCurveArray);
            jacobianBuilder.put((Object)order.getName(), (Object)JacobianCalibrationMatrix.of(orderAll, (DoubleMatrix)pDmCurveMatrix));
            startIndex += paramCount;
        }
        return jacobianBuilder.build();
    }

    private ImmutableMap<CurveName, DoubleArray> sensitivityToMarketQuoteForGroup(ImmutableRatesProvider provider, ImmutableList<ResolvedTrade> trades, ImmutableList<CurveParameterSize> orderGroup) {
        ImmutableMap.Builder mqsGroup = new ImmutableMap.Builder();
        int nodeIndex = 0;
        for (CurveParameterSize cps : orderGroup) {
            int nbParameters = cps.getParameterCount();
            double[] mqsCurve = new double[nbParameters];
            for (int looptrade = 0; looptrade < nbParameters; ++looptrade) {
                DoubleArray mqsNode = this.pvMeasures.derivative((ResolvedTrade)trades.get(nodeIndex), provider, (List<CurveParameterSize>)orderGroup);
                mqsCurve[looptrade] = mqsNode.get(nodeIndex);
                ++nodeIndex;
            }
            mqsGroup.put((Object)cps.getName(), (Object)DoubleArray.ofUnsafe((double[])mqsCurve));
        }
        return mqsGroup.build();
    }

    private DoubleMatrix derivatives(ImmutableList<ResolvedTrade> trades, ImmutableRatesProvider provider, ImmutableList<CurveParameterSize> orderAll, int totalParamsAll) {
        return DoubleMatrix.ofArrayObjects((int)trades.size(), (int)totalParamsAll, i -> this.measures.derivative((ResolvedTrade)trades.get(i), provider, (List<CurveParameterSize>)orderAll));
    }

    private static DoubleMatrix jacobianDirect(DoubleMatrix res, int nbTrades, int totalParamsGroup, int totalParamsPrevious) {
        double[][] direct = new double[totalParamsGroup][totalParamsGroup];
        for (int i = 0; i < nbTrades; ++i) {
            System.arraycopy(res.rowArray(i), totalParamsPrevious, direct[i], 0, totalParamsGroup);
        }
        return MATRIX_ALGEBRA.getInverse((Matrix)DoubleMatrix.copyOf((double[][])direct));
    }

    private static DoubleMatrix jacobianIndirect(DoubleMatrix res, DoubleMatrix pDmCurrentMatrix, int nbTrades, int totalParamsGroup, int totalParamsPrevious, ImmutableList<CurveParameterSize> orderPrevious, ImmutableMap<CurveName, JacobianCalibrationMatrix> jacobiansPrevious) {
        if (totalParamsPrevious == 0) {
            return DoubleMatrix.EMPTY;
        }
        double[][] nonDirect = new double[totalParamsGroup][totalParamsPrevious];
        for (int i = 0; i < nbTrades; ++i) {
            System.arraycopy(res.rowArray(i), 0, nonDirect[i], 0, totalParamsPrevious);
        }
        DoubleMatrix pDpPreviousMatrix = (DoubleMatrix)MATRIX_ALGEBRA.scale(MATRIX_ALGEBRA.multiply((Matrix)pDmCurrentMatrix, (Matrix)DoubleMatrix.copyOf((double[][])nonDirect)), -1.0);
        int[] startIndexBefore = new int[orderPrevious.size()];
        for (int i = 1; i < orderPrevious.size(); ++i) {
            startIndexBefore[i] = startIndexBefore[i - 1] + ((CurveParameterSize)orderPrevious.get(i - 1)).getParameterCount();
        }
        double[][] transition = new double[totalParamsPrevious][totalParamsPrevious];
        for (int i = 0; i < orderPrevious.size(); ++i) {
            int paramCountOuter = ((CurveParameterSize)orderPrevious.get(i)).getParameterCount();
            JacobianCalibrationMatrix thisInfo = (JacobianCalibrationMatrix)jacobiansPrevious.get((Object)((CurveParameterSize)orderPrevious.get(i)).getName());
            DoubleMatrix thisMatrix = thisInfo.getJacobianMatrix();
            int startIndexInner = 0;
            for (int j = 0; j < orderPrevious.size(); ++j) {
                int paramCountInner = ((CurveParameterSize)orderPrevious.get(j)).getParameterCount();
                if (thisInfo.containsCurve(((CurveParameterSize)orderPrevious.get(j)).getName())) {
                    for (int k = 0; k < paramCountOuter; ++k) {
                        System.arraycopy(thisMatrix.rowArray(k), startIndexInner, transition[startIndexBefore[i] + k], startIndexBefore[j], paramCountInner);
                    }
                }
                startIndexInner += paramCountInner;
            }
        }
        DoubleMatrix transitionMatrix = DoubleMatrix.copyOf((double[][])transition);
        return (DoubleMatrix)MATRIX_ALGEBRA.multiply((Matrix)pDpPreviousMatrix, (Matrix)transitionMatrix);
    }

    public String toString() {
        return Messages.format((String)"CurveCalibrator[{}]", (Object)this.measures);
    }
}

