/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.pricer.deposit;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyAmount;
import com.opengamma.strata.market.sensitivity.PointSensitivities;
import com.opengamma.strata.market.sensitivity.PointSensitivityBuilder;
import com.opengamma.strata.pricer.DiscountFactors;
import com.opengamma.strata.pricer.ZeroRateSensitivity;
import com.opengamma.strata.pricer.rate.IborIndexRates;
import com.opengamma.strata.pricer.rate.RatesProvider;
import com.opengamma.strata.product.deposit.ResolvedIborFixingDeposit;

public class DiscountingIborFixingDepositProductPricer {
    public static final DiscountingIborFixingDepositProductPricer DEFAULT = new DiscountingIborFixingDepositProductPricer();

    public CurrencyAmount presentValue(ResolvedIborFixingDeposit deposit, RatesProvider provider) {
        Currency currency = deposit.getCurrency();
        if (provider.getValuationDate().isAfter(deposit.getEndDate())) {
            return CurrencyAmount.of((Currency)currency, (double)0.0);
        }
        double forwardRate = this.forwardRate(deposit, provider);
        double discountFactor = provider.discountFactor(currency, deposit.getEndDate());
        double fv = deposit.getNotional() * deposit.getYearFraction() * (deposit.getFixedRate() - forwardRate);
        double pv = discountFactor * fv;
        return CurrencyAmount.of((Currency)currency, (double)pv);
    }

    public PointSensitivities presentValueSensitivity(ResolvedIborFixingDeposit deposit, RatesProvider provider) {
        double forwardRate = this.forwardRate(deposit, provider);
        DiscountFactors discountFactors = provider.discountFactors(deposit.getCurrency());
        double discountFactor = discountFactors.discountFactor(deposit.getEndDate());
        PointSensitivityBuilder sensiFwd = this.forwardRateSensitivity(deposit, provider).multipliedBy(-discountFactor * deposit.getNotional() * deposit.getYearFraction());
        ZeroRateSensitivity sensiDsc = discountFactors.zeroRatePointSensitivity(deposit.getEndDate()).multipliedBy(deposit.getNotional() * deposit.getYearFraction() * (deposit.getFixedRate() - forwardRate));
        return sensiFwd.combinedWith((PointSensitivityBuilder)sensiDsc).build();
    }

    public double parRate(ResolvedIborFixingDeposit deposit, RatesProvider provider) {
        return this.forwardRate(deposit, provider);
    }

    public PointSensitivities parRateSensitivity(ResolvedIborFixingDeposit deposit, RatesProvider provider) {
        return this.forwardRateSensitivity(deposit, provider).build();
    }

    public double parSpread(ResolvedIborFixingDeposit deposit, RatesProvider provider) {
        return this.forwardRate(deposit, provider) - deposit.getFixedRate();
    }

    public PointSensitivities parSpreadSensitivity(ResolvedIborFixingDeposit deposit, RatesProvider provider) {
        return this.forwardRateSensitivity(deposit, provider).build();
    }

    private double forwardRate(ResolvedIborFixingDeposit product, RatesProvider provider) {
        IborIndexRates rates = provider.iborIndexRates(product.getFloatingRate().getIndex());
        return rates.rateIgnoringFixings(product.getFloatingRate().getObservation());
    }

    private PointSensitivityBuilder forwardRateSensitivity(ResolvedIborFixingDeposit product, RatesProvider provider) {
        IborIndexRates rates = provider.iborIndexRates(product.getFloatingRate().getIndex());
        return rates.rateIgnoringFixingsPointSensitivity(product.getFloatingRate().getObservation());
    }
}

